/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.cluster.coordination;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.wso2.andes.server.ClusterResourceHolder;
import org.wso2.andes.server.cluster.coordination.CoordinationException;
import org.wso2.andes.server.cluster.coordination.SubscriptionCoordinationManager;
import org.wso2.andes.server.cluster.coordination.SubscriptionListener;
import org.wso2.andes.server.cluster.coordination.ZooKeeperAgent;
import org.wso2.andes.server.configuration.ClusterConfiguration;

public class SubscriptionCoordinationManagerImpl
implements SubscriptionCoordinationManager {
    private static Log log = LogFactory.getLog(SubscriptionCoordinationManagerImpl.class);
    private ZooKeeperAgent zooKeeperAgent;
    private SubscriptionParentDataChangeListener subscriptionParentDataChangeListener;
    private List<SubscriptionListener> subscriptionListeners = new ArrayList<SubscriptionListener>();

    public void init() throws CoordinationException {
        try {
            ClusterConfiguration clusterConfiguration = ClusterResourceHolder.getInstance().getClusterConfiguration();
            if (clusterConfiguration.isClusteringEnabled().booleanValue()) {
                String zkServer = clusterConfiguration.getZookeeperConnection();
                this.zooKeeperAgent = new ZooKeeperAgent(zkServer);
                this.zooKeeperAgent.initSubscriptionCoordination();
                ZooKeeper zk = this.zooKeeperAgent.getZooKeeper();
                this.subscriptionParentDataChangeListener = new SubscriptionParentDataChangeListener();
                zk.getData("/subscription_coordination_parent", (Watcher)this.subscriptionParentDataChangeListener, null);
            }
        }
        catch (Exception e) {
            throw new CoordinationException("Error while initializing SubscriptionCoordinationManagerImpl", e);
        }
    }

    public void notifySubscriptionChange() {
        log.debug((Object)"Notifying subscribers on Subscription changes ");
        Runnable r = new Runnable(){

            public void run() {
                for (SubscriptionListener listener : SubscriptionCoordinationManagerImpl.this.subscriptionListeners) {
                    try {
                        listener.subscriptionsChanged();
                    }
                    catch (Exception e) {
                        log.error((Object)"Error handling the subscription change ", (Throwable)e);
                    }
                }
            }
        };
        Thread t = new Thread(r);
        t.setName(SubscriptionListener.class.getSimpleName());
        t.start();
    }

    public void handleSubscriptionChange() throws CoordinationException {
        if (ClusterResourceHolder.getInstance().getClusterConfiguration().isClusteringEnabled().booleanValue()) {
            ZooKeeper zooKeeper = this.zooKeeperAgent.getZooKeeper();
            if (zooKeeper != null) {
                try {
                    zooKeeper.setData("/subscription_coordination_parent", new byte[]{1}, -1);
                }
                catch (Exception e) {
                    throw new CoordinationException("Error while handling subscription change");
                }
            } else {
                throw new CoordinationException("Subscription Coordination Manager not initialized yet");
            }
        }
        this.notifySubscriptionChange();
    }

    public void registerSubscriptionListener(SubscriptionListener listener) {
        if (listener == null) {
            throw new RuntimeException("Error while registering subscribers : invalid argument listener = null");
        }
        this.subscriptionListeners.add(listener);
    }

    public void removeSubscriptionListener(SubscriptionListener listener) {
        if (this.subscriptionListeners.contains(listener)) {
            this.subscriptionListeners.remove(listener);
        }
    }

    private class SubscriptionParentDataChangeListener
    implements Watcher {
        private SubscriptionParentDataChangeListener() {
        }

        public void process(WatchedEvent watchedEvent) {
            log.debug((Object)("Subscription data change event received : " + watchedEvent));
            if (Watcher.Event.EventType.NodeDataChanged == watchedEvent.getType()) {
                try {
                    SubscriptionCoordinationManagerImpl.this.zooKeeperAgent.getZooKeeper().getData("/subscription_coordination_parent", (Watcher)SubscriptionCoordinationManagerImpl.this.subscriptionParentDataChangeListener, null);
                    SubscriptionCoordinationManagerImpl.this.notifySubscriptionChange();
                }
                catch (Exception e) {
                    log.error((Object)"Error while processing subscription Data Change event");
                }
            }
        }
    }
}

