/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.cluster;

import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.server.ClusterResourceHolder;
import org.wso2.andes.server.cassandra.CassandraQueueMessage;
import org.wso2.andes.server.cassandra.DefaultClusteringEnabledSubscriptionManager;
import org.wso2.andes.server.store.CassandraMessageStore;
import org.wso2.andes.tools.utils.DataCollector;

public class GlobalQueueWorker
implements Runnable {
    private static Log log = LogFactory.getLog(GlobalQueueWorker.class);
    private String globalQueueName;
    private boolean running;
    private DefaultClusteringEnabledSubscriptionManager cassandraSubscriptionManager;
    private int messageCount;
    private CassandraMessageStore cassandraMessageStore;

    public GlobalQueueWorker(String queueName, CassandraMessageStore cassandraMessageStore, int messageCount) {
        this.cassandraMessageStore = cassandraMessageStore;
        this.globalQueueName = queueName;
        this.cassandraSubscriptionManager = (DefaultClusteringEnabledSubscriptionManager)ClusterResourceHolder.getInstance().getSubscriptionManager();
        this.messageCount = messageCount;
    }

    public void run() {
        String originalName = Thread.currentThread().getName();
        Thread.currentThread().setName(this.getClass().getSimpleName() + ":" + originalName);
        while (this.running) {
            try {
                Queue<CassandraQueueMessage> cassandraMessages = this.cassandraMessageStore.getMessagesFromGlobalQueue(this.globalQueueName, this.messageCount);
                int size = cassandraMessages.size();
                DataCollector.write("TrQWU", size);
                DataCollector.flush();
                List<String> subscriptions = this.cassandraMessageStore.getUserQueues(this.globalQueueName);
                if (subscriptions != null && subscriptions.size() > 0) {
                    ArrayList<Long> addedMsgs = new ArrayList<Long>();
                    for (int i = 0; i < size; ++i) {
                        CassandraQueueMessage msg = cassandraMessages.poll();
                        int index = i % subscriptions.size();
                        String s = subscriptions.get(index);
                        msg.setQueue(s);
                        addedMsgs.add(msg.getMessageId());
                        cassandraMessages.add(msg);
                    }
                    this.cassandraMessageStore.transferMessageBatchFromGlobalQueueToUserQueue(cassandraMessages.toArray(new CassandraQueueMessage[cassandraMessages.size()]), this.globalQueueName);
                    if (size != 0) continue;
                    try {
                        Thread.sleep(ClusterResourceHolder.getInstance().getClusterConfiguration().getQueueWorkerInterval());
                    }
                    catch (InterruptedException e) {}
                    continue;
                }
                try {
                    Thread.sleep(ClusterResourceHolder.getInstance().getClusterConfiguration().getQueueWorkerInterval());
                }
                catch (InterruptedException e) {
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }
}

