/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.cluster;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.server.ClusterResourceHolder;
import org.wso2.andes.server.cluster.ClusterManager;
import org.wso2.andes.server.cluster.GlobalQueueWorker;
import org.wso2.andes.server.store.CassandraMessageStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlobalQueueManager {
    private List<String> queueNameList = new ArrayList<String>();
    private CassandraMessageStore cassandraMessageStore;
    private Map<String, GlobalQueueWorker> queueWorkerMap = new ConcurrentHashMap<String, GlobalQueueWorker>();
    private ExecutorService executorService;
    private static Log log = LogFactory.getLog(GlobalQueueManager.class);

    public GlobalQueueManager(CassandraMessageStore store) {
        this.cassandraMessageStore = store;
        this.executorService = Executors.newCachedThreadPool();
    }

    public void addGlobalQueue(String queueName) {
        if (!this.queueNameList.contains(queueName)) {
            this.queueNameList.add(queueName);
            ClusterManager clusterManager = ClusterResourceHolder.getInstance().getClusterManager();
            log.debug((Object)("Adding Global Queue worker for queue : " + queueName));
            this.scheduleWork(queueName);
        }
    }

    private void scheduleWork(String queueName) {
        int batchSize = ClusterResourceHolder.getInstance().getClusterConfiguration().getGlobalQueueWorkerMessageBatchSize();
        GlobalQueueWorker worker = new GlobalQueueWorker(queueName, this.cassandraMessageStore, batchSize);
        worker.setRunning(true);
        this.queueWorkerMap.put(queueName, worker);
        log.debug((Object)("Starting Global Queue worker for queue : " + queueName));
        System.out.println("Starting Global Queue worker for queue : " + queueName);
        this.executorService.execute(worker);
    }

    public void removeWorker(String queueName) {
        log.debug((Object)("Removing Queue worker for queue : " + queueName));
        ClusterManager clusterManager = ClusterResourceHolder.getInstance().getClusterManager();
        GlobalQueueWorker worker = this.queueWorkerMap.get(queueName);
        if (worker != null) {
            worker.setRunning(false);
            this.queueWorkerMap.remove(queueName);
        }
    }

    public int getMessageCount(String queueName) {
        return this.cassandraMessageStore.getMessageCountOfGlobalQueue(queueName) + this.getMessageCountOfUserQueues(queueName);
    }

    public int getMessageCountOfUserQueues(String globalQueueName) {
        return this.cassandraMessageStore.getMessageCountOfUserQueues(globalQueueName);
    }

    public List<String> getTopics() throws Exception {
        return this.cassandraMessageStore.getTopics();
    }

    public List<String> getSubscribers(String topic) throws Exception {
        return this.cassandraMessageStore.getRegisteredSubscribersForTopic(topic);
    }

    public int getSubscriberCount(String queueName) throws Exception {
        return this.cassandraMessageStore.getUserQueues(queueName).size();
    }
}

