/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.cassandra;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.AMQStoreException;
import org.wso2.andes.server.ClusterResourceHolder;
import org.wso2.andes.server.cassandra.CassandraQueueMessage;
import org.wso2.andes.server.protocol.AMQProtocolSession;
import org.wso2.andes.server.queue.AMQQueue;
import org.wso2.andes.server.queue.QueueEntry;
import org.wso2.andes.server.store.CassandraMessageStore;
import org.wso2.andes.server.store.util.CassandraDataAccessException;
import org.wso2.andes.server.subscription.Subscription;
import org.wso2.andes.server.subscription.SubscriptionImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueueBrowserFlusher
extends Thread {
    private Subscription subscription;
    private AMQQueue queue;
    private AMQProtocolSession session;
    private String id;
    private int defaultMessageCount = Integer.MAX_VALUE;
    private int messageCount;
    private static Log log = LogFactory.getLog(QueueBrowserFlusher.class);

    public QueueBrowserFlusher(Subscription subscription, AMQQueue queue, AMQProtocolSession session) {
        this.subscription = subscription;
        this.queue = queue;
        this.session = session;
        this.id = "" + subscription.getSubscriptionID();
        this.messageCount = this.defaultMessageCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send() {
        List<QueueEntry> messages = null;
        try {
            messages = this.getSortedMessages();
            if (messages.size() > 0) {
                for (QueueEntry message : messages) {
                    try {
                        if (!(this.subscription instanceof SubscriptionImpl.BrowserSubscription)) continue;
                        this.subscription.send(message);
                    }
                    catch (Exception e) {
                        log.error((Object)"Unexpected Error in Message Flusher Task while delivering the message : ", (Throwable)e);
                    }
                }
            }
        }
        catch (AMQStoreException e) {
            log.error((Object)"Error while sending message for Browser subscription", (Throwable)e);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.subscription.confirmAutoClose();
            try {
                if (messages.size() > 0) {
                    this.clearBrowserQueue(messages);
                }
            }
            catch (CassandraDataAccessException e) {
                e.printStackTrace();
            }
        }
    }

    private List<QueueEntry> getSortedMessages() throws Exception {
        CassandraMessageStore messageStore = ClusterResourceHolder.getInstance().getCassandraMessageStore();
        List<String> userQueues = messageStore.getUserQueues(this.queue.getResourceName());
        ArrayList<CassandraQueueMessage> queueMessages = new ArrayList<CassandraQueueMessage>();
        for (String userQueue : userQueues) {
            List<CassandraQueueMessage> messages = messageStore.getMessagesFromUserQueue(userQueue, this.queue.getResourceName(), Integer.MAX_VALUE);
            for (CassandraQueueMessage message : messages) {
                queueMessages.add(message);
            }
        }
        messageStore.addMessageToBrowserQueue(this.queue.getResourceName(), queueMessages);
        return messageStore.getMessagesFromBrowserQueue(this.queue, this.session, this.messageCount);
    }

    private void clearBrowserQueue(List<QueueEntry> queueEntries) throws CassandraDataAccessException {
        CassandraMessageStore messageStore = ClusterResourceHolder.getInstance().getCassandraMessageStore();
        messageStore.clearBrowserQueue(queueEntries, this.queue.getResourceName());
    }
}

