/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.cassandra;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.server.cassandra.CassandraTopicPublisher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CassandraTopicPublisherManager {
    private Map<String, CassandraTopicPublisher> workMap = new ConcurrentHashMap<String, CassandraTopicPublisher>();
    private Queue<String> subscriptionQueue = new ConcurrentLinkedQueue<String>();
    private HashMap<String, List<String>> userQueuesMap = new HashMap();
    private static Log log = LogFactory.getLog(CassandraTopicPublisherManager.class);
    private ExecutorService executor = null;
    private boolean active = true;
    private CassandraTopicPublisher currentWork;
    public static final int poolSize = 20;

    public void init() {
        this.executor = Executors.newFixedThreadPool(20);
    }

    public void start() {
        this.active = true;
        this.executor.submit(new CassandraTopicPublisherManagerTask());
    }

    public void stop() {
        this.active = false;
    }

    public void addWork(String id, CassandraTopicPublisher work) {
        this.workMap.put(id, work);
        this.subscriptionQueue.offer(id);
    }

    public CassandraTopicPublisher getCurrentWork() {
        return this.currentWork;
    }

    public void markSubscriptionForRemoval(String id) {
        CassandraTopicPublisher work = this.workMap.get(id);
        if (work != null) {
            work.setMarkedForRemoval(true);
        }
    }

    public int getSubscriptionCount() {
        return this.subscriptionQueue.size();
    }

    public Map<String, CassandraTopicPublisher> getWorkMap() {
        return this.workMap;
    }

    public Queue<String> getSubscriptionQueue() {
        return this.subscriptionQueue;
    }

    public List<String> getUserQueues(String amqpQueueName) {
        return this.userQueuesMap.get(amqpQueueName);
    }

    private class CassandraTopicPublisherManagerTask
    implements Runnable {
        private CassandraTopicPublisherManagerTask() {
        }

        public void run() {
            while (CassandraTopicPublisherManager.this.active) {
                if (CassandraTopicPublisherManager.this.subscriptionQueue.size() > 0) {
                    String id = (String)CassandraTopicPublisherManager.this.subscriptionQueue.peek();
                    if (CassandraTopicPublisherManager.this.workMap.containsKey(id)) {
                        CassandraTopicPublisher work = (CassandraTopicPublisher)CassandraTopicPublisherManager.this.workMap.get(id);
                        if (work.isMarkedForRemoval()) {
                            CassandraTopicPublisherManager.this.workMap.remove(id);
                            CassandraTopicPublisherManager.this.subscriptionQueue.remove();
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Removing subscription queue " + id + " from work map"));
                            }
                        } else {
                            if (!work.isWorking()) {
                                CassandraTopicPublisherManager.this.executor.execute(work);
                            }
                            CassandraTopicPublisherManager.this.subscriptionQueue.remove();
                            CassandraTopicPublisherManager.this.subscriptionQueue.offer(id);
                        }
                    } else {
                        CassandraTopicPublisherManager.this.subscriptionQueue.remove();
                    }
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    log.error((Object)"Error in thread sleep", (Throwable)e);
                }
            }
        }
    }
}

