/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.cassandra;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.AMQException;
import org.wso2.andes.AMQStoreException;
import org.wso2.andes.exchange.ExchangeDefaults;
import org.wso2.andes.server.ClusterResourceHolder;
import org.wso2.andes.server.binding.Binding;
import org.wso2.andes.server.exchange.AbstractExchange;
import org.wso2.andes.server.exchange.Exchange;
import org.wso2.andes.server.exchange.ExchangeRegistry;
import org.wso2.andes.server.message.MessageTransferMessage;
import org.wso2.andes.server.protocol.AMQProtocolSession;
import org.wso2.andes.server.queue.AMQQueue;
import org.wso2.andes.server.queue.SimpleAMQQueue;
import org.wso2.andes.server.store.CassandraMessageStore;
import org.wso2.andes.server.virtualhost.VirtualHost;

public class CassandraTopicPublisher
extends Thread {
    private AMQProtocolSession session;
    private Binding binding;
    private SimpleAMQQueue queue;
    private AbstractExchange exchange;
    private long lastDeliveredMessageID = 0L;
    private VirtualHost virtualHost;
    private boolean working = false;
    private boolean markedForRemoval;
    private String id;
    private CassandraMessageStore messageStore = null;
    private static Log log = LogFactory.getLog(CassandraTopicPublisher.class);

    public CassandraTopicPublisher(Binding binding, AMQQueue queue, Exchange exchange, VirtualHost virtualHost) {
        this.binding = binding;
        this.exchange = (AbstractExchange)exchange;
        this.queue = (SimpleAMQQueue)queue;
        this.virtualHost = virtualHost;
        this.id = queue.getName();
        this.messageStore = ClusterResourceHolder.getInstance().getCassandraMessageStore();
        this.messageStore.registerSubscriberForTopic(binding.getBindingKey(), queue.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.working = true;
            List<MessageTransferMessage> messages = this.messageStore.getSubscriberMessages(this.queue, this.lastDeliveredMessageID++);
            if (messages != null && messages.size() > 0) {
                ArrayList<Long> publishedMids = new ArrayList<Long>();
                for (MessageTransferMessage message : messages) {
                    try {
                        this.enqueueMessage(message);
                        publishedMids.add(message.getMessageNumber());
                        this.lastDeliveredMessageID = message.getMessageNumber();
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("Sending message  " + this.lastDeliveredMessageID + "from cassandra topic publisher" + this.queue.getName()));
                    }
                    catch (Exception e) {
                        log.error((Object)"Error on enqueing messages to relavent queue", (Throwable)e);
                    }
                }
                this.messageStore.removeDeliveredMessageIds(publishedMids, this.queue.getName());
            }
        }
        catch (AMQStoreException e) {
            log.error((Object)"Error removing delivered Message Ids from Message store ", (Throwable)e);
        }
        finally {
            this.working = false;
        }
    }

    private void enqueueMessage(MessageTransferMessage message) {
        ExchangeRegistry exchangeRegistry = this.virtualHost.getExchangeRegistry();
        Exchange exchange = exchangeRegistry.getExchange(ExchangeDefaults.TOPIC_EXCHANGE_NAME);
        if (exchange != null) {
            for (Binding binding : exchange.getBindings()) {
                if (!binding.getQueue().getName().equalsIgnoreCase(this.queue.getName())) continue;
                try {
                    binding.getQueue().enqueue(message);
                    break;
                }
                catch (AMQException e) {
                    log.error((Object)"Error in enqueing message to queue", (Throwable)e);
                }
            }
        }
    }

    public boolean isWorking() {
        return this.working;
    }

    public boolean isMarkedForRemoval() {
        return this.markedForRemoval;
    }

    public void setMarkedForRemoval(boolean markedForRemoval) {
        this.markedForRemoval = markedForRemoval;
    }

    public String getQueueId() {
        return this.id;
    }
}

