/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.binding;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.wso2.andes.AMQException;
import org.wso2.andes.AMQInternalException;
import org.wso2.andes.AMQSecurityException;
import org.wso2.andes.framing.AMQShortString;
import org.wso2.andes.framing.FieldTable;
import org.wso2.andes.server.ClusterResourceHolder;
import org.wso2.andes.server.binding.Binding;
import org.wso2.andes.server.cassandra.CassandraTopicPublisher;
import org.wso2.andes.server.configuration.BindingConfig;
import org.wso2.andes.server.configuration.BindingConfigType;
import org.wso2.andes.server.configuration.ConfigStore;
import org.wso2.andes.server.configuration.ConfiguredObject;
import org.wso2.andes.server.exchange.Exchange;
import org.wso2.andes.server.logging.actors.CurrentActor;
import org.wso2.andes.server.logging.messages.BindingMessages;
import org.wso2.andes.server.logging.subjects.BindingLogSubject;
import org.wso2.andes.server.queue.AMQQueue;
import org.wso2.andes.server.store.CassandraMessageStore;
import org.wso2.andes.server.store.DurableConfigurationStore;
import org.wso2.andes.server.virtualhost.VirtualHost;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindingFactory {
    private final VirtualHost _virtualHost;
    private final DurableConfigurationStore.Source _configSource;
    private final Exchange _defaultExchange;
    private final ConcurrentHashMap<BindingImpl, BindingImpl> _bindings = new ConcurrentHashMap();

    public BindingFactory(VirtualHost vhost) {
        this(vhost, vhost.getExchangeRegistry().getDefaultExchange());
    }

    public BindingFactory(DurableConfigurationStore.Source configSource, Exchange defaultExchange) {
        this._configSource = configSource;
        this._defaultExchange = defaultExchange;
        this._virtualHost = configSource instanceof VirtualHost ? (VirtualHost)configSource : null;
    }

    public VirtualHost getVirtualHost() {
        return this._virtualHost;
    }

    public boolean addBinding(String bindingKey, AMQQueue queue, Exchange exchange, Map<String, Object> arguments) throws AMQSecurityException, AMQInternalException {
        return this.makeBinding(bindingKey, queue, exchange, arguments, false, false);
    }

    public boolean replaceBinding(String bindingKey, AMQQueue queue, Exchange exchange, Map<String, Object> arguments) throws AMQSecurityException, AMQInternalException {
        return this.makeBinding(bindingKey, queue, exchange, arguments, false, true);
    }

    private boolean makeBinding(String bindingKey, AMQQueue queue, Exchange exchange, Map<String, Object> arguments, boolean restore, boolean force) throws AMQSecurityException, AMQInternalException {
        assert (queue != null);
        if (bindingKey == null) {
            bindingKey = "";
        }
        if (exchange == null) {
            exchange = this._defaultExchange;
        }
        if (arguments == null) {
            arguments = Collections.emptyMap();
        }
        if (!this.getVirtualHost().getSecurityManager().authoriseBind(exchange, queue, new AMQShortString(bindingKey))) {
            throw new AMQSecurityException("Permission denied: binding " + bindingKey);
        }
        BindingImpl b = new BindingImpl(bindingKey, queue, exchange, arguments);
        BindingImpl existingMapping = this._bindings.putIfAbsent(b, b);
        if (existingMapping == null || force) {
            if (existingMapping != null) {
                this.removeBinding(existingMapping);
            }
            if (b.isDurable() && !restore) {
                this._configSource.getDurableConfigurationStore().bindQueue(exchange, new AMQShortString(bindingKey), queue, FieldTable.convertToFieldTable(arguments));
            }
            queue.addQueueDeleteTask(b);
            exchange.addCloseTask(b);
            queue.addBinding(b);
            exchange.addBinding(b);
            this.getConfigStore().addConfiguredObject(b);
            b.logCreation();
            if (exchange.getName().equalsIgnoreCase("amq.topic")) {
                CassandraTopicPublisher cassandraTopicPublisher = new CassandraTopicPublisher(b, queue, exchange, this.getVirtualHost());
                try {
                    this.handleTask(cassandraTopicPublisher);
                }
                catch (AMQException e) {
                    throw new AMQInternalException("Error in creating publisher for queue" + queue.getName(), e);
                }
            }
            return true;
        }
        return false;
    }

    public void handleTask(CassandraTopicPublisher topicPublisher) throws AMQException {
        ClusterResourceHolder.getInstance().getCassandraTopicPublisherManager().addWork(topicPublisher.getQueueId(), topicPublisher);
    }

    private ConfigStore getConfigStore() {
        return this.getVirtualHost().getConfigStore();
    }

    public void restoreBinding(String bindingKey, AMQQueue queue, Exchange exchange, Map<String, Object> argumentMap) throws AMQSecurityException, AMQInternalException {
        this.makeBinding(bindingKey, queue, exchange, argumentMap, true, false);
    }

    public void removeBinding(Binding b) throws AMQSecurityException, AMQInternalException {
        this.removeBinding(b.getBindingKey(), b.getQueue(), b.getExchange(), b.getArguments());
        ClusterResourceHolder.getInstance().getCassandraTopicPublisherManager().markSubscriptionForRemoval(b.getQueue().getName());
        CassandraMessageStore messageStore = ClusterResourceHolder.getInstance().getCassandraMessageStore();
        messageStore.unRegisterQueueFromTopic(b.getBindingKey(), b.getQueue().getName());
    }

    public Binding removeBinding(String bindingKey, AMQQueue queue, Exchange exchange, Map<String, Object> arguments) throws AMQSecurityException, AMQInternalException {
        assert (queue != null);
        if (bindingKey == null) {
            bindingKey = "";
        }
        if (exchange == null) {
            exchange = this._defaultExchange;
        }
        if (arguments == null) {
            arguments = Collections.emptyMap();
        }
        if (!this.getVirtualHost().getSecurityManager().authoriseUnbind(exchange, new AMQShortString(bindingKey), queue)) {
            throw new AMQSecurityException("Permission denied: binding " + bindingKey);
        }
        BindingImpl b = this._bindings.remove(new BindingImpl(bindingKey, queue, exchange, arguments));
        if (b != null) {
            exchange.removeBinding(b);
            queue.removeBinding(b);
            exchange.removeCloseTask(b);
            queue.removeQueueDeleteTask(b);
            if (b.isDurable()) {
                this._configSource.getDurableConfigurationStore().unbindQueue(exchange, new AMQShortString(bindingKey), queue, FieldTable.convertToFieldTable(arguments));
            }
            b.logDestruction();
            this.getConfigStore().removeConfiguredObject(b);
        }
        return b;
    }

    public Binding getBinding(String bindingKey, AMQQueue queue, Exchange exchange, Map<String, Object> arguments) {
        assert (queue != null);
        if (bindingKey == null) {
            bindingKey = "";
        }
        if (exchange == null) {
            exchange = this._defaultExchange;
        }
        if (arguments == null) {
            arguments = Collections.emptyMap();
        }
        BindingImpl b = new BindingImpl(bindingKey, queue, exchange, arguments);
        return this._bindings.get(b);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class BindingImpl
    extends Binding
    implements AMQQueue.Task,
    Exchange.Task,
    BindingConfig {
        private final BindingLogSubject _logSubject;
        private long _createTime;

        private BindingImpl(String bindingKey, AMQQueue queue, Exchange exchange, Map<String, Object> arguments) {
            super(queue.getVirtualHost().getConfigStore().createId(), bindingKey, queue, exchange, arguments);
            this._createTime = System.currentTimeMillis();
            this._logSubject = new BindingLogSubject(bindingKey, exchange, queue);
        }

        @Override
        public void doTask(AMQQueue queue) throws AMQException {
            BindingFactory.this.removeBinding(this);
        }

        @Override
        public void onClose(Exchange exchange) throws AMQSecurityException, AMQInternalException {
            BindingFactory.this.removeBinding(this);
        }

        void logCreation() {
            CurrentActor.get().message(this._logSubject, BindingMessages.CREATED(String.valueOf(this.getArguments()), this.getArguments() != null && !this.getArguments().isEmpty()));
        }

        void logDestruction() {
            CurrentActor.get().message(this._logSubject, BindingMessages.DELETED());
        }

        @Override
        public String getOrigin() {
            return (String)this.getArguments().get("qpid.fed.origin");
        }

        @Override
        public long getCreateTime() {
            return this._createTime;
        }

        @Override
        public BindingConfigType getConfigType() {
            return BindingConfigType.getInstance();
        }

        @Override
        public ConfiguredObject getParent() {
            return BindingFactory.this._virtualHost;
        }

        @Override
        public boolean isDurable() {
            return this.getQueue().isDurable() && this.getExchange().isDurable();
        }
    }
}

