/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.Logger;
import org.wso2.andes.AMQException;
import org.wso2.andes.AMQSecurityException;
import org.wso2.andes.framing.AMQShortString;
import org.wso2.andes.framing.BasicContentHeaderProperties;
import org.wso2.andes.framing.ChannelFlowBody;
import org.wso2.andes.framing.ContentBody;
import org.wso2.andes.framing.ContentHeaderBody;
import org.wso2.andes.framing.FieldTable;
import org.wso2.andes.framing.MethodRegistry;
import org.wso2.andes.framing.abstraction.ContentChunk;
import org.wso2.andes.framing.abstraction.MessagePublishInfo;
import org.wso2.andes.protocol.AMQConstant;
import org.wso2.andes.server.ClusterResourceHolder;
import org.wso2.andes.server.ExtractResendAndRequeue;
import org.wso2.andes.server.ack.UnacknowledgedMessageMap;
import org.wso2.andes.server.ack.UnacknowledgedMessageMapImpl;
import org.wso2.andes.server.cassandra.CassandraSubscription;
import org.wso2.andes.server.cassandra.ClusteringEnabledSubscriptionManager;
import org.wso2.andes.server.cassandra.QueueSubscriptionAcknowledgementHandler;
import org.wso2.andes.server.configuration.ConfigStore;
import org.wso2.andes.server.configuration.ConfiguredObject;
import org.wso2.andes.server.configuration.ConnectionConfig;
import org.wso2.andes.server.configuration.SessionConfig;
import org.wso2.andes.server.configuration.SessionConfigType;
import org.wso2.andes.server.exchange.Exchange;
import org.wso2.andes.server.flow.FlowCreditManager;
import org.wso2.andes.server.flow.Pre0_10CreditManager;
import org.wso2.andes.server.logging.LogActor;
import org.wso2.andes.server.logging.LogSubject;
import org.wso2.andes.server.logging.actors.AMQPChannelActor;
import org.wso2.andes.server.logging.actors.CurrentActor;
import org.wso2.andes.server.logging.messages.ChannelMessages;
import org.wso2.andes.server.logging.subjects.ChannelLogSubject;
import org.wso2.andes.server.message.AMQMessage;
import org.wso2.andes.server.message.EnqueableMessage;
import org.wso2.andes.server.message.MessageMetaData;
import org.wso2.andes.server.message.MessageReference;
import org.wso2.andes.server.message.ServerMessage;
import org.wso2.andes.server.output.ProtocolOutputConverter;
import org.wso2.andes.server.protocol.AMQConnectionModel;
import org.wso2.andes.server.protocol.AMQProtocolEngine;
import org.wso2.andes.server.protocol.AMQProtocolSession;
import org.wso2.andes.server.protocol.AMQSessionModel;
import org.wso2.andes.server.queue.AMQQueue;
import org.wso2.andes.server.queue.BaseQueue;
import org.wso2.andes.server.queue.IncomingMessage;
import org.wso2.andes.server.queue.QueueEntry;
import org.wso2.andes.server.registry.ApplicationRegistry;
import org.wso2.andes.server.store.CassandraQueue;
import org.wso2.andes.server.store.MessageQueue;
import org.wso2.andes.server.store.MessageStore;
import org.wso2.andes.server.store.StoredMessage;
import org.wso2.andes.server.subscription.ClientDeliveryMethod;
import org.wso2.andes.server.subscription.RecordDeliveryMethod;
import org.wso2.andes.server.subscription.Subscription;
import org.wso2.andes.server.subscription.SubscriptionFactoryImpl;
import org.wso2.andes.server.txn.AutoCommitTransaction;
import org.wso2.andes.server.txn.LocalTransaction;
import org.wso2.andes.server.txn.ServerTransaction;
import org.wso2.andes.server.virtualhost.VirtualHost;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AMQChannel
implements SessionConfig,
AMQSessionModel {
    public static final int DEFAULT_PREFETCH = 5000;
    private static final Logger _logger = Logger.getLogger(AMQChannel.class);
    private static final boolean MSG_AUTH = ApplicationRegistry.getInstance().getConfiguration().getMsgAuth();
    private final int _channelId;
    private final Pre0_10CreditManager _creditManager = new Pre0_10CreditManager(0L, 0L);
    private AtomicLong _deliveryTag = new AtomicLong(0L);
    private AMQQueue _defaultQueue;
    private AtomicInteger _consumerTag = new AtomicInteger(0);
    private IncomingMessage _currentMessage;
    protected final Map<AMQShortString, Subscription> _tag2SubscriptionMap = new HashMap<AMQShortString, Subscription>();
    private final MessageStore _messageStore;
    private UnacknowledgedMessageMap _unacknowledgedMessageMap = new UnacknowledgedMessageMapImpl(5000);
    private SortedSet<QueueEntry> _acknowledgedMessages = new TreeSet<QueueEntry>();
    private final AtomicBoolean _suspended = new AtomicBoolean(false);
    private ServerTransaction _transaction;
    private final AtomicLong _txnStarts = new AtomicLong(0L);
    private final AtomicLong _txnCommits = new AtomicLong(0L);
    private final AtomicLong _txnRejects = new AtomicLong(0L);
    private final AtomicLong _txnCount = new AtomicLong(0L);
    private final AtomicLong _txnUpdateTime = new AtomicLong(0L);
    private final AMQProtocolSession _session;
    private AtomicBoolean _closing = new AtomicBoolean(false);
    private final ConcurrentMap<AMQQueue, Boolean> _blockingQueues = new ConcurrentHashMap<AMQQueue, Boolean>();
    private final AtomicBoolean _blocking = new AtomicBoolean(false);
    private LogActor _actor;
    private LogSubject _logSubject;
    private volatile boolean _rollingBack;
    private static final Runnable NULL_TASK = new Runnable(){

        public void run() {
        }
    };
    private List<QueueEntry> _resendList = new ArrayList<QueueEntry>();
    private static final AMQShortString IMMEDIATE_DELIVERY_REPLY_TEXT = new AMQShortString("Immediate delivery is not possible.");
    private final UUID _id;
    private long _createTime = System.currentTimeMillis();
    private MessageQueue _messageQueue;
    private MessageStore cassandraMessageStore;
    private final String id = "(" + System.identityHashCode(this) + ")";
    private final ClientDeliveryMethod _clientDeliveryMethod = new ClientDeliveryMethod(){

        public void deliverToClient(Subscription sub, QueueEntry entry, long deliveryTag) throws AMQException {
            AMQChannel.this.getProtocolSession().getProtocolOutputConverter().writeDeliver(entry, AMQChannel.this.getChannelId(), deliveryTag, sub.getConsumerTag());
            AMQChannel.this._session.registerMessageDelivered(entry.getMessage().getSize());
        }
    };
    private final RecordDeliveryMethod _recordDeliveryMethod = new RecordDeliveryMethod(){

        public void recordMessageDelivery(Subscription sub, QueueEntry entry, long deliveryTag) {
            AMQChannel.this.addUnacknowledgedMessage(entry, deliveryTag, sub);
        }
    };

    public AMQChannel(AMQProtocolSession session, int channelId, MessageStore messageStore) throws AMQException {
        this._session = session;
        this._channelId = channelId;
        this._actor = new AMQPChannelActor(this, session.getLogActor().getRootMessageLogger());
        this._logSubject = new ChannelLogSubject(this);
        this._id = this.getConfigStore().createId();
        this._actor.message(ChannelMessages.CREATE());
        this.getConfigStore().addConfiguredObject(this);
        this._messageStore = messageStore;
        this._transaction = new AutoCommitTransaction(this._messageStore);
        this.cassandraMessageStore = ClusterResourceHolder.getInstance().getCassandraMessageStore();
        this._messageQueue = new CassandraQueue();
    }

    public ConfigStore getConfigStore() {
        return this.getVirtualHost().getConfigStore();
    }

    public void setLocalTransactional() {
        this._transaction = new LocalTransaction(this._messageStore);
        this._txnStarts.incrementAndGet();
    }

    @Override
    public boolean isTransactional() {
        return !(this._transaction instanceof AutoCommitTransaction);
    }

    public boolean inTransaction() {
        return this.isTransactional() && this._txnUpdateTime.get() > 0L && this._transaction.getTransactionStartTime() > 0L;
    }

    private void incrementOutstandingTxnsIfNecessary() {
        if (this.isTransactional()) {
            this._txnCount.compareAndSet(0L, 1L);
        }
    }

    private void decrementOutstandingTxnsIfNecessary() {
        if (this.isTransactional()) {
            this._txnCount.compareAndSet(1L, 0L);
        }
    }

    @Override
    public Long getTxnStarts() {
        return this._txnStarts.get();
    }

    @Override
    public Long getTxnCommits() {
        return this._txnCommits.get();
    }

    @Override
    public Long getTxnRejects() {
        return this._txnRejects.get();
    }

    @Override
    public Long getTxnCount() {
        return this._txnCount.get();
    }

    public int getChannelId() {
        return this._channelId;
    }

    public void setPublishFrame(MessagePublishInfo info, Exchange e) throws AMQSecurityException {
        if (!this.getVirtualHost().getSecurityManager().authorisePublish(info.isImmediate(), info.getRoutingKey().asString(), e.getName())) {
            throw new AMQSecurityException("Permission denied: " + e.getName());
        }
        this._currentMessage = new IncomingMessage(info);
        this._currentMessage.setExchange(e);
    }

    public void publishContentHeader(ContentHeaderBody contentHeaderBody) throws AMQException {
        if (this._currentMessage == null) {
            throw new AMQException("Received content header without previously receiving a BasicPublish frame");
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Content header received on channel " + this._channelId));
        }
        this._currentMessage.setContentHeaderBody(contentHeaderBody);
        this._currentMessage.setExpiration();
        MessageMetaData mmd = this._currentMessage.headersReceived();
        mmd.set_clientIP(this._session.toString().substring(0, this._session.toString().indexOf(":")));
        final StoredMessage<MessageMetaData> handle = this._messageStore.addMessage(mmd);
        this._currentMessage.setStoredMessage(handle);
        this.routeCurrentMessage();
        this._transaction.addPostTransactionAction(new ServerTransaction.Action(){

            public void postCommit() {
            }

            public void onRollback() {
                handle.remove();
            }
        });
        this.deliverCurrentMessageIfComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deliverCurrentMessageIfComplete() throws AMQException {
        if (this._currentMessage.allContentReceived()) {
            try {
                this._currentMessage.getStoredMessage().flushToStore();
                ArrayList<? extends BaseQueue> destinationQueues = this._currentMessage.getDestinationQueues();
                if (!this.checkMessageUserId(this._currentMessage.getContentHeader())) {
                    this._transaction.addPostTransactionAction(new WriteReturnAction(AMQConstant.ACCESS_REFUSED, "Access Refused", this._currentMessage));
                } else if (destinationQueues == null || this._currentMessage.getDestinationQueues().isEmpty()) {
                    if (this._currentMessage.isMandatory() || this._currentMessage.isImmediate()) {
                        this._transaction.addPostTransactionAction(new WriteReturnAction(AMQConstant.NO_ROUTE, "No Route for message", this._currentMessage));
                    } else {
                        _logger.warn((Object)("MESSAGE DISCARDED: No routes for message - " + this.createAMQMessage(this._currentMessage)));
                    }
                } else {
                    this._transaction.enqueue(destinationQueues, (EnqueableMessage)this._currentMessage, (ServerTransaction.Action)new MessageDeliveryAction(this._currentMessage, destinationQueues, this.isTransactional()));
                    this.incrementOutstandingTxnsIfNecessary();
                    this.updateTransactionalActivity();
                    this._messageQueue.enqueueMessage(this._currentMessage, destinationQueues);
                }
            }
            finally {
                long bodySize = this._currentMessage.getSize();
                long timestamp = ((BasicContentHeaderProperties)this._currentMessage.getContentHeader().getProperties()).getTimestamp();
                this._session.registerMessageReceived(bodySize, timestamp);
                this._currentMessage = null;
            }
        }
    }

    public void publishContentBody(ContentBody contentBody) throws AMQException {
        if (this._currentMessage == null) {
            throw new AMQException("Received content body without previously receiving a JmsPublishBody");
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)(this.debugIdentity() + "Content body received on channel " + this._channelId));
        }
        try {
            ContentChunk contentChunk = this._session.getMethodRegistry().getProtocolVersionMethodConverter().convertToContentChunk(contentBody);
            this._currentMessage.addContentBodyFrame(contentChunk);
            this.deliverCurrentMessageIfComplete();
        }
        catch (AMQException e) {
            this._currentMessage = null;
            throw e;
        }
    }

    protected void routeCurrentMessage() throws AMQException {
        this._currentMessage.route();
    }

    public long getNextDeliveryTag() {
        return this._deliveryTag.incrementAndGet();
    }

    public long getCurrentDeliveryTag() {
        return this._deliveryTag.get();
    }

    public int getNextConsumerTag() {
        return this._consumerTag.incrementAndGet();
    }

    public Subscription getSubscription(AMQShortString subscription) {
        return this._tag2SubscriptionMap.get(subscription);
    }

    public AMQShortString subscribeToQueue(AMQShortString tag, AMQQueue queue, boolean acks, FieldTable filters, boolean noLocal, boolean exclusive) throws AMQException {
        if (tag == null) {
            tag = new AMQShortString("sgen_" + this.getNextConsumerTag());
        }
        if (this._tag2SubscriptionMap.containsKey(tag)) {
            throw new AMQException("Consumer already exists with same tag: " + tag);
        }
        Subscription subscription = SubscriptionFactoryImpl.INSTANCE.createSubscription(this._channelId, this._session, tag, acks, filters, noLocal, this._creditManager);
        this._tag2SubscriptionMap.put(tag, subscription);
        ClusteringEnabledSubscriptionManager subscriptionManager = ClusterResourceHolder.getInstance().getSubscriptionManager();
        try {
            queue.registerSubscription(subscription, exclusive);
            CassandraSubscription cs = new CassandraSubscription(subscription, this._session, queue.getResourceName());
            subscriptionManager.addSubscription(queue, cs);
        }
        catch (AMQException e) {
            this._tag2SubscriptionMap.remove(tag);
            throw e;
        }
        return tag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unsubscribeConsumer(AMQShortString consumerTag) throws AMQException {
        Subscription sub = this._tag2SubscriptionMap.remove(consumerTag);
        if (sub != null) {
            try {
                sub.getSendLock();
                sub.getQueue().unregisterSubscription(sub);
            }
            finally {
                sub.releaseSendLock();
            }
            return true;
        }
        _logger.warn((Object)("Attempt to unsubscribe consumer with tag '" + consumerTag + "' which is not registered."));
        return false;
    }

    @Override
    public void close() throws AMQException {
        if (!this._closing.compareAndSet(false, true)) {
            return;
        }
        CurrentActor.get().message(this._logSubject, ChannelMessages.CLOSE());
        this.unsubscribeAllConsumers();
        this._transaction.rollback();
        try {
            this.requeue();
        }
        catch (AMQException e) {
            _logger.error((Object)("Caught AMQException whilst attempting to reque:" + e));
        }
        this.getConfigStore().removeConfiguredObject(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unsubscribeAllConsumers() throws AMQException {
        if (_logger.isInfoEnabled()) {
            if (!this._tag2SubscriptionMap.isEmpty()) {
                _logger.info((Object)("Unsubscribing all consumers on channel " + this.toString()));
            } else {
                _logger.info((Object)("No consumers to unsubscribe on channel " + this.toString()));
            }
        }
        for (Map.Entry<AMQShortString, Subscription> me : this._tag2SubscriptionMap.entrySet()) {
            if (_logger.isInfoEnabled()) {
                _logger.info((Object)("Unsubscribing consumer '" + me.getKey() + "' on channel " + this.toString()));
            }
            Subscription sub = me.getValue();
            try {
                sub.getSendLock();
                sub.getQueue().unregisterSubscription(sub);
            }
            finally {
                sub.releaseSendLock();
            }
        }
        this._tag2SubscriptionMap.clear();
    }

    public void addUnacknowledgedMessage(QueueEntry entry, long deliveryTag, Subscription subscription) {
        if (_logger.isDebugEnabled()) {
            if (entry.getQueue() == null) {
                _logger.debug((Object)("Adding unacked message with a null queue:" + entry));
            } else if (_logger.isDebugEnabled()) {
                _logger.debug((Object)(this.debugIdentity() + " Adding unacked message(" + entry.getMessage().toString() + " DT:" + deliveryTag + ") with a queue(" + entry.getQueue() + ") for " + subscription));
            }
        }
        this._unacknowledgedMessageMap.add(deliveryTag, entry);
    }

    public String debugIdentity() {
        return this._channelId + this.id;
    }

    public void requeue() throws AMQException {
        Collection<QueueEntry> messagesToBeDelivered = this._unacknowledgedMessageMap.cancelAllMessages();
        if (!messagesToBeDelivered.isEmpty() && _logger.isInfoEnabled()) {
            _logger.info((Object)("Requeuing " + messagesToBeDelivered.size() + " unacked messages. for " + this.toString()));
        }
        for (QueueEntry unacked : messagesToBeDelivered) {
            if (!unacked.isQueueDeleted()) {
                unacked.setRedelivered();
                unacked.release();
                continue;
            }
            unacked.discard();
        }
    }

    public void requeue(long deliveryTag) throws AMQException {
        QueueEntry unacked = this._unacknowledgedMessageMap.remove(deliveryTag);
        if (unacked != null) {
            unacked.setRedelivered();
            if (!unacked.isQueueDeleted()) {
                unacked.release();
            } else {
                _logger.warn((Object)(System.identityHashCode(this) + " Requested requeue of message(" + unacked + "):" + deliveryTag + " but no queue defined and no DeadLetter queue so DROPPING message."));
                unacked.discard();
            }
        } else {
            _logger.warn((Object)("Requested requeue of message:" + deliveryTag + " but no such delivery tag exists." + this._unacknowledgedMessageMap.size()));
        }
    }

    public void resend(boolean requeue) throws AMQException {
        long deliveryTag;
        QueueEntry message;
        LinkedHashMap<Long, QueueEntry> msgToRequeue = new LinkedHashMap<Long, QueueEntry>();
        LinkedHashMap<Long, QueueEntry> msgToResend = new LinkedHashMap<Long, QueueEntry>();
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("unacked map Size:" + this._unacknowledgedMessageMap.size()));
        }
        this._unacknowledgedMessageMap.visit(new ExtractResendAndRequeue(this._unacknowledgedMessageMap, msgToRequeue, msgToResend, requeue, this._messageStore));
        if (_logger.isDebugEnabled()) {
            if (!msgToResend.isEmpty()) {
                _logger.debug((Object)("Preparing (" + msgToResend.size() + ") message to resend."));
            } else {
                _logger.debug((Object)"No message to resend.");
            }
        }
        for (Map.Entry entry : msgToResend.entrySet()) {
            message = (QueueEntry)entry.getValue();
            deliveryTag = (Long)entry.getKey();
            ServerMessage msg = message.getMessage();
            AMQQueue queue = message.getQueue();
            message.setRedelivered();
            Subscription sub = message.getDeliveredSubscription();
            if (sub != null) {
                if (queue.resend(message, sub)) continue;
                msgToRequeue.put(deliveryTag, message);
                continue;
            }
            if (_logger.isInfoEnabled()) {
                _logger.info((Object)("DeliveredSubscription not recorded so just requeueing(" + message.toString() + ")to prevent loss"));
            }
            msgToRequeue.put(deliveryTag, message);
        }
        if (_logger.isInfoEnabled() && !msgToRequeue.isEmpty()) {
            _logger.info((Object)("Preparing (" + msgToRequeue.size() + ") message to requeue to."));
        }
        for (Map.Entry entry : msgToRequeue.entrySet()) {
            message = (QueueEntry)entry.getValue();
            deliveryTag = (Long)entry.getKey();
            this._unacknowledgedMessageMap.remove(deliveryTag);
            message.setRedelivered();
            message.release();
        }
    }

    public void acknowledgeMessage(long deliveryTag, boolean multiple) throws AMQException {
        Collection<QueueEntry> ackedMessages = this.getAckedMessages(deliveryTag, multiple);
        this._transaction.dequeue(ackedMessages, new MessageAcknowledgeAction(ackedMessages));
        try {
            if (ClusterResourceHolder.getInstance().getClusterConfiguration().isOnceInOrderSupportEnabled()) {
                Map<Long, Semaphore> locks;
                if (ClusterResourceHolder.getInstance().getSubscriptionManager().getUnAcknowledgedMessageLocks().containsKey(this) && (locks = ClusterResourceHolder.getInstance().getSubscriptionManager().getUnAcknowledgedMessageLocks().get(this)).containsKey(deliveryTag)) {
                    locks.get(deliveryTag).release();
                    locks.remove(deliveryTag);
                }
            } else {
                QueueSubscriptionAcknowledgementHandler acknowledgementHandler = ClusterResourceHolder.getInstance().getSubscriptionManager().getAcknowledgementHandlerMap().get(this);
                acknowledgementHandler.handleAcknowledgement(deliveryTag);
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            throw new AMQException(e.getMessage());
        }
        this.updateTransactionalActivity();
    }

    private Collection<QueueEntry> getAckedMessages(long deliveryTag, boolean multiple) {
        LinkedHashMap<Long, QueueEntry> ackedMessageMap = new LinkedHashMap<Long, QueueEntry>();
        this._unacknowledgedMessageMap.collect(deliveryTag, multiple, ackedMessageMap);
        this._unacknowledgedMessageMap.remove(ackedMessageMap);
        return ackedMessageMap.values();
    }

    public UnacknowledgedMessageMap getUnacknowledgedMessageMap() {
        return this._unacknowledgedMessageMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSuspended(boolean suspended) {
        boolean wasSuspended = this._suspended.getAndSet(suspended);
        if (wasSuspended != suspended) {
            if (!suspended) {
                this._actor.message(this._logSubject, ChannelMessages.FLOW("Started"));
            }
            if (wasSuspended) {
                for (Subscription s : this._tag2SubscriptionMap.values()) {
                    s.getQueue().deliverAsync(s);
                }
            }
            if (!wasSuspended) {
                for (Subscription s : this._tag2SubscriptionMap.values()) {
                    try {
                        s.getSendLock();
                    }
                    finally {
                        s.releaseSendLock();
                    }
                }
            }
            if (suspended) {
                this._actor.message(this._logSubject, ChannelMessages.FLOW("Stopped"));
            }
        }
    }

    public boolean isSuspended() {
        return this._suspended.get() || this._closing.get() || this._session.isClosing();
    }

    public void commit() throws AMQException {
        if (!this.isTransactional()) {
            throw new AMQException("Fatal error: commit called on non-transactional channel");
        }
        this._transaction.commit();
        this._txnCommits.incrementAndGet();
        this._txnStarts.incrementAndGet();
        this.decrementOutstandingTxnsIfNecessary();
    }

    public void rollback() throws AMQException {
        this.rollback(NULL_TASK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(Runnable postRollbackTask) throws AMQException {
        if (!this.isTransactional()) {
            throw new AMQException("Fatal error: commit called on non-transactional channel");
        }
        this._rollingBack = true;
        boolean requiresSuspend = this._suspended.compareAndSet(false, true);
        for (Subscription sub : this._tag2SubscriptionMap.values()) {
            sub.getSendLock();
            sub.releaseSendLock();
        }
        try {
            this._transaction.rollback();
        }
        finally {
            this._rollingBack = false;
            this._txnRejects.incrementAndGet();
            this._txnStarts.incrementAndGet();
            this.decrementOutstandingTxnsIfNecessary();
        }
        postRollbackTask.run();
        for (QueueEntry entry : this._resendList) {
            Subscription sub = entry.getDeliveredSubscription();
            if (sub == null || sub.isClosed()) {
                entry.release();
                continue;
            }
            sub.getQueue().resend(entry, sub);
        }
        this._resendList.clear();
        if (requiresSuspend) {
            this._suspended.set(false);
            for (Subscription sub : this._tag2SubscriptionMap.values()) {
                sub.getQueue().deliverAsync(sub);
            }
        }
    }

    private void updateTransactionalActivity() {
        if (this.isTransactional()) {
            this._txnUpdateTime.set(System.currentTimeMillis());
        }
    }

    public String toString() {
        return "[" + this._session.toString() + ":" + this._channelId + "]";
    }

    public void setDefaultQueue(AMQQueue queue) {
        this._defaultQueue = queue;
    }

    public AMQQueue getDefaultQueue() {
        return this._defaultQueue;
    }

    public boolean isClosing() {
        return this._closing.get();
    }

    public AMQProtocolSession getProtocolSession() {
        return this._session;
    }

    public FlowCreditManager getCreditManager() {
        return this._creditManager;
    }

    public void setCredit(long prefetchSize, int prefetchCount) {
        this._actor.message(ChannelMessages.PREFETCH_SIZE(prefetchSize, prefetchCount));
        this._creditManager.setCreditLimits(prefetchSize, prefetchCount);
    }

    public MessageStore getMessageStore() {
        return this._messageStore;
    }

    public ClientDeliveryMethod getClientDeliveryMethod() {
        return this._clientDeliveryMethod;
    }

    public RecordDeliveryMethod getRecordDeliveryMethod() {
        return this._recordDeliveryMethod;
    }

    private AMQMessage createAMQMessage(IncomingMessage incomingMessage) throws AMQException {
        AMQMessage message = new AMQMessage(incomingMessage.getStoredMessage());
        message.setExpiration(incomingMessage.getExpiration());
        message.setClientIdentifier(this._session);
        return message;
    }

    private boolean checkMessageUserId(ContentHeaderBody header) {
        AMQShortString userID;
        AMQShortString aMQShortString = userID = header.getProperties() instanceof BasicContentHeaderProperties ? ((BasicContentHeaderProperties)header.getProperties()).getUserId() : null;
        return !MSG_AUTH || this._session.getAuthorizedPrincipal().getName().equals(userID == null ? "" : userID.toString());
    }

    @Override
    public Object getID() {
        return this._channelId;
    }

    @Override
    public AMQConnectionModel getConnectionModel() {
        return this._session;
    }

    @Override
    public String getClientID() {
        return String.valueOf(this._session.getContextKey());
    }

    @Override
    public LogSubject getLogSubject() {
        return this._logSubject;
    }

    public LogActor getLogActor() {
        return this._actor;
    }

    public void block(AMQQueue queue) {
        if (this._blockingQueues.putIfAbsent(queue, Boolean.TRUE) == null && this._blocking.compareAndSet(false, true)) {
            this._actor.message(this._logSubject, ChannelMessages.FLOW_ENFORCED(queue.getNameShortString().toString()));
            this.flow(false);
        }
    }

    public void unblock(AMQQueue queue) {
        if (((Boolean)this._blockingQueues.remove(queue)).booleanValue() && this._blocking.compareAndSet(true, false)) {
            this._actor.message(this._logSubject, ChannelMessages.FLOW_REMOVED());
            this.flow(true);
        }
    }

    private void flow(boolean flow) {
        MethodRegistry methodRegistry = this._session.getMethodRegistry();
        ChannelFlowBody responseBody = methodRegistry.createChannelFlowBody(flow);
        this._session.writeFrame(responseBody.generateFrame(this._channelId));
    }

    public boolean getBlocking() {
        return this._blocking.get();
    }

    @Override
    public VirtualHost getVirtualHost() {
        return this.getProtocolSession().getVirtualHost();
    }

    @Override
    public ConfiguredObject getParent() {
        return this.getVirtualHost();
    }

    @Override
    public SessionConfigType getConfigType() {
        return SessionConfigType.getInstance();
    }

    @Override
    public int getChannel() {
        return this.getChannelId();
    }

    @Override
    public boolean isAttached() {
        return true;
    }

    @Override
    public long getDetachedLifespan() {
        return 0L;
    }

    @Override
    public ConnectionConfig getConnectionConfig() {
        return (AMQProtocolEngine)this.getProtocolSession();
    }

    @Override
    public Long getExpiryTime() {
        return null;
    }

    @Override
    public Long getMaxClientRate() {
        return null;
    }

    @Override
    public boolean isDurable() {
        return false;
    }

    @Override
    public UUID getId() {
        return this._id;
    }

    @Override
    public String getSessionName() {
        return this.getConnectionConfig().getAddress() + "/" + this.getChannelId();
    }

    @Override
    public long getCreateTime() {
        return this._createTime;
    }

    @Override
    public void mgmtClose() throws AMQException {
        this._session.mgmtCloseChannel(this._channelId);
    }

    @Override
    public void checkTransactionStatus(long openWarn, long openClose, long idleWarn, long idleClose) throws AMQException {
        if (this.inTransaction()) {
            long currentTime = System.currentTimeMillis();
            long openTime = currentTime - this._transaction.getTransactionStartTime();
            long idleTime = currentTime - this._txnUpdateTime.get();
            if (idleWarn > 0L && idleTime > idleWarn) {
                CurrentActor.get().message(this._logSubject, ChannelMessages.IDLE_TXN(idleTime));
                _logger.warn((Object)("IDLE TRANSACTION ALERT " + this._logSubject.toString() + " " + idleTime + " ms"));
            } else if (openWarn > 0L && openTime > openWarn) {
                CurrentActor.get().message(this._logSubject, ChannelMessages.OPEN_TXN(openTime));
                _logger.warn((Object)("OPEN TRANSACTION ALERT " + this._logSubject.toString() + " " + openTime + " ms"));
            }
            if (idleClose > 0L && idleTime > idleClose) {
                this.getConnectionModel().closeSession(this, AMQConstant.RESOURCE_ERROR, "Idle transaction timed out");
            } else if (openClose > 0L && openTime > openClose) {
                this.getConnectionModel().closeSession(this, AMQConstant.RESOURCE_ERROR, "Open transaction timed out");
            }
        }
    }

    private class WriteReturnAction
    implements ServerTransaction.Action {
        private final AMQConstant _errorCode;
        private final IncomingMessage _message;
        private final String _description;

        public WriteReturnAction(AMQConstant errorCode, String description, IncomingMessage message) {
            this._errorCode = errorCode;
            this._message = message;
            this._description = description;
        }

        public void postCommit() {
            try {
                AMQChannel.this._session.getProtocolOutputConverter().writeReturn(this._message.getMessagePublishInfo(), this._message.getContentHeader(), this._message, AMQChannel.this._channelId, this._errorCode.getCode(), new AMQShortString(this._description));
            }
            catch (AMQException e) {
                throw new RuntimeException(e);
            }
        }

        public void onRollback() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MessageAcknowledgeAction
    implements ServerTransaction.Action {
        private final Collection<QueueEntry> _ackedMessages;

        public MessageAcknowledgeAction(Collection<QueueEntry> ackedMessages) {
            this._ackedMessages = ackedMessages;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void postCommit() {
            try {
                for (QueueEntry entry : this._ackedMessages) {
                    entry.discard();
                }
            }
            finally {
                AMQChannel.this._acknowledgedMessages.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRollback() {
            if (AMQChannel.this._rollingBack) {
                AMQChannel.this._resendList.addAll(this._ackedMessages);
            } else {
                try {
                    for (QueueEntry entry : this._ackedMessages) {
                        entry.release();
                    }
                }
                finally {
                    AMQChannel.this._acknowledgedMessages.clear();
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MessageDeliveryAction
    implements ServerTransaction.Action {
        private IncomingMessage _incommingMessage;
        private ArrayList<? extends BaseQueue> _destinationQueues;

        public MessageDeliveryAction(IncomingMessage currentMessage, ArrayList<? extends BaseQueue> destinationQueues, boolean transactional) {
            this._incommingMessage = currentMessage;
            this._destinationQueues = destinationQueues;
        }

        @Override
        public void postCommit() {
            try {
                boolean immediate = this._incommingMessage.isImmediate();
                AMQMessage amqMessage = AMQChannel.this.createAMQMessage(this._incommingMessage);
                MessageReference ref = amqMessage.newReference();
                for (BaseQueue baseQueue : this._destinationQueues) {
                    ImmediateAction action = immediate ? new ImmediateAction(baseQueue) : null;
                    baseQueue.enqueue(amqMessage, action);
                    if (!(baseQueue instanceof AMQQueue)) continue;
                    ((AMQQueue)baseQueue).checkCapacity(AMQChannel.this);
                }
                ref.release();
            }
            catch (AMQException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void onRollback() {
        }

        private class ImmediateAction
        implements BaseQueue.PostEnqueueAction {
            private final BaseQueue _queue;

            public ImmediateAction(BaseQueue queue) {
                this._queue = queue;
            }

            public void onEnqueue(QueueEntry entry) {
                if (!entry.getDeliveredToConsumer() && entry.acquire()) {
                    LocalTransaction txn = new LocalTransaction(AMQChannel.this._messageStore);
                    ArrayList<QueueEntry> entries = new ArrayList<QueueEntry>(1);
                    entries.add(entry);
                    final AMQMessage message = (AMQMessage)entry.getMessage();
                    txn.dequeue(this._queue, entry.getMessage(), new MessageAcknowledgeAction(entries){

                        public void postCommit() {
                            try {
                                ProtocolOutputConverter outputConverter = AMQChannel.this._session.getProtocolOutputConverter();
                                outputConverter.writeReturn(message.getMessagePublishInfo(), message.getContentHeaderBody(), message, AMQChannel.this._channelId, AMQConstant.NO_CONSUMERS.getCode(), IMMEDIATE_DELIVERY_REPLY_TEXT);
                            }
                            catch (AMQException e) {
                                throw new RuntimeException(e);
                            }
                            super.postCommit();
                        }
                    });
                    txn.commit();
                }
            }
        }
    }
}

