/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.management.common.sasl;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

public class UserPasswordCallbackHandler
implements CallbackHandler {
    private String user;
    private char[] pwchars;

    public UserPasswordCallbackHandler(String user, String password) {
        this.user = user;
        this.pwchars = password.toCharArray();
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            if (callbacks[i] instanceof NameCallback) {
                NameCallback ncb = (NameCallback)callbacks[i];
                ncb.setName(this.user);
                continue;
            }
            if (callbacks[i] instanceof PasswordCallback) {
                PasswordCallback pcb = (PasswordCallback)callbacks[i];
                pcb.setPassword(this.pwchars);
                continue;
            }
            throw new UnsupportedCallbackException(callbacks[i]);
        }
    }

    private void clearPassword() {
        if (this.pwchars != null) {
            for (int i = 0; i < this.pwchars.length; ++i) {
                this.pwchars[i] = '\u0000';
            }
            this.pwchars = null;
        }
    }

    protected void finalize() {
        this.clearPassword();
    }
}

