/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.framing.amqp_8_0;

import org.apache.mina.common.ByteBuffer;
import org.wso2.andes.AMQException;
import org.wso2.andes.framing.AMQFrameDecodingException;
import org.wso2.andes.framing.AMQMethodBody;
import org.wso2.andes.framing.AMQMethodBodyInstanceFactory;
import org.wso2.andes.framing.AMQShortString;
import org.wso2.andes.framing.ChannelAlertBody;
import org.wso2.andes.framing.FieldTable;
import org.wso2.andes.framing.MethodDispatcher;
import org.wso2.andes.framing.amqp_8_0.AMQMethodBody_8_0;
import org.wso2.andes.framing.amqp_8_0.MethodDispatcher_8_0;

public class ChannelAlertBodyImpl
extends AMQMethodBody_8_0
implements ChannelAlertBody {
    private static final AMQMethodBodyInstanceFactory FACTORY_INSTANCE = new AMQMethodBodyInstanceFactory(){

        public AMQMethodBody newInstance(ByteBuffer in, long size) throws AMQFrameDecodingException {
            return new ChannelAlertBodyImpl(in);
        }
    };
    public static final int CLASS_ID = 20;
    public static final int METHOD_ID = 30;
    private final int _replyCode;
    private final AMQShortString _replyText;
    private final FieldTable _details;

    public static AMQMethodBodyInstanceFactory getFactory() {
        return FACTORY_INSTANCE;
    }

    public ChannelAlertBodyImpl(ByteBuffer buffer) throws AMQFrameDecodingException {
        this._replyCode = this.readUnsignedShort(buffer);
        this._replyText = this.readAMQShortString(buffer);
        this._details = this.readFieldTable(buffer);
    }

    public ChannelAlertBodyImpl(int replyCode, AMQShortString replyText, FieldTable details) {
        this._replyCode = replyCode;
        this._replyText = replyText;
        this._details = details;
    }

    public int getClazz() {
        return 20;
    }

    public int getMethod() {
        return 30;
    }

    public final int getReplyCode() {
        return this._replyCode;
    }

    public final AMQShortString getReplyText() {
        return this._replyText;
    }

    public final FieldTable getDetails() {
        return this._details;
    }

    protected int getBodySize() {
        int size = 2;
        size += this.getSizeOf(this._replyText);
        return size += this.getSizeOf(this._details);
    }

    public void writeMethodPayload(ByteBuffer buffer) {
        this.writeUnsignedShort(buffer, this._replyCode);
        this.writeAMQShortString(buffer, this._replyText);
        this.writeFieldTable(buffer, this._details);
    }

    public boolean execute(MethodDispatcher dispatcher, int channelId) throws AMQException {
        return ((MethodDispatcher_8_0)dispatcher).dispatchChannelAlert(this, channelId);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("[ChannelAlertBodyImpl: ");
        buf.append("replyCode=");
        buf.append(this.getReplyCode());
        buf.append(", ");
        buf.append("replyText=");
        buf.append(this.getReplyText());
        buf.append(", ");
        buf.append("details=");
        buf.append(this.getDetails());
        buf.append("]");
        return buf.toString();
    }
}

