/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CountDownLatch;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.XASession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.andes.AMQException;
import org.wso2.andes.client.AMQConnection;
import org.wso2.andes.client.AMQConnectionDelegate;
import org.wso2.andes.client.AMQSession;
import org.wso2.andes.client.AMQSession_0_10;
import org.wso2.andes.client.JMSAMQException;
import org.wso2.andes.client.XASessionImpl;
import org.wso2.andes.client.failover.FailoverException;
import org.wso2.andes.client.failover.FailoverProtectedOperation;
import org.wso2.andes.client.security.DynamicSaslRegistrar;
import org.wso2.andes.framing.ProtocolVersion;
import org.wso2.andes.jms.BrokerDetails;
import org.wso2.andes.jms.ChannelLimitReachedException;
import org.wso2.andes.protocol.AMQConstant;
import org.wso2.andes.transport.Connection;
import org.wso2.andes.transport.ConnectionClose;
import org.wso2.andes.transport.ConnectionException;
import org.wso2.andes.transport.ConnectionListener;
import org.wso2.andes.transport.ConnectionSettings;
import org.wso2.andes.transport.ProtocolVersionException;
import org.wso2.andes.transport.Session;
import org.wso2.andes.transport.SessionDetachCode;
import org.wso2.andes.transport.TransportException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AMQConnectionDelegate_0_10
implements AMQConnectionDelegate,
ConnectionListener {
    private static final Logger _logger = LoggerFactory.getLogger(AMQConnectionDelegate_0_10.class);
    private AMQConnection _conn;
    Connection _qpidConnection;
    private ConnectionException exception = null;

    public AMQConnectionDelegate_0_10(AMQConnection conn) {
        this._conn = conn;
        this._qpidConnection = new Connection();
        this._qpidConnection.addConnectionListener(this);
    }

    @Override
    public org.wso2.andes.jms.Session createSession(boolean transacted, int acknowledgeMode, int prefetchHigh, int prefetchLow) throws JMSException {
        return this.createSession(transacted, acknowledgeMode, prefetchHigh, prefetchLow, null);
    }

    public org.wso2.andes.jms.Session createSession(boolean transacted, int acknowledgeMode, int prefetchHigh, int prefetchLow, String name) throws JMSException {
        AMQSession_0_10 session;
        this._conn.checkNotClosed();
        if (this._conn.channelLimitReached()) {
            throw new ChannelLimitReachedException(this._conn.getMaximumChannelCount());
        }
        int channelId = this._conn.getNextChannelID();
        try {
            session = new AMQSession_0_10(this._qpidConnection, this._conn, channelId, transacted, acknowledgeMode, prefetchHigh, prefetchLow, name);
            this._conn.registerSession(channelId, session);
            if (this._conn._started) {
                session.start();
            }
        }
        catch (Exception e) {
            _logger.error("exception creating session:", (Throwable)e);
            throw new JMSAMQException("cannot create session", e);
        }
        return session;
    }

    @Override
    public XASession createXASession() throws JMSException {
        return this.createXASession((int)this._conn.getMaxPrefetch(), (int)this._conn.getMaxPrefetch() / 2);
    }

    @Override
    public XASession createXASession(int prefetchHigh, int prefetchLow) throws JMSException {
        XASessionImpl session;
        this._conn.checkNotClosed();
        if (this._conn.channelLimitReached()) {
            throw new ChannelLimitReachedException(this._conn.getMaximumChannelCount());
        }
        int channelId = this._conn.getNextChannelID();
        try {
            session = new XASessionImpl(this._qpidConnection, this._conn, channelId, prefetchHigh, prefetchLow);
            this._conn.registerSession(channelId, session);
            if (this._conn._started) {
                session.start();
            }
        }
        catch (Exception e) {
            throw new JMSAMQException("cannot create session", e);
        }
        return session;
    }

    @Override
    public ProtocolVersion makeBrokerConnection(BrokerDetails brokerDetail) throws IOException, AMQException {
        try {
            if (_logger.isDebugEnabled()) {
                _logger.debug("connecting to host: " + brokerDetail.getHost() + " port: " + brokerDetail.getPort() + " vhost: " + this._conn.getVirtualHost() + " username: " + this._conn.getUsername() + " password: " + this._conn.getPassword());
            }
            ConnectionSettings conSettings = new ConnectionSettings();
            this.retriveConnectionSettings(conSettings, brokerDetail);
            this._qpidConnection.connect(conSettings);
            this._conn._connected = true;
            this._conn.setUsername(this._qpidConnection.getUserID());
            this._conn.setMaximumChannelCount(this._qpidConnection.getChannelMax());
            this._conn._failoverPolicy.attainedConnection();
        }
        catch (ProtocolVersionException pe) {
            return new ProtocolVersion(pe.getMajor(), pe.getMinor());
        }
        catch (ConnectionException ce) {
            AMQConstant code = AMQConstant.REPLY_SUCCESS;
            if (ce.getClose() != null && ce.getClose().getReplyCode() != null) {
                code = AMQConstant.getConstant(ce.getClose().getReplyCode().getValue());
            }
            String msg = "Cannot connect to broker: " + ce.getMessage();
            throw new AMQException(code, msg, ce);
        }
        return null;
    }

    @Override
    public void failoverPrep() {
        ArrayList<AMQSession> sessions = new ArrayList<AMQSession>(this._conn.getSessions().values());
        for (AMQSession s : sessions) {
            s.failoverPrep();
        }
    }

    @Override
    public void resubscribeSessions() throws JMSException, AMQException, FailoverException {
        _logger.info("Resuming connection");
        this.getQpidConnection().resume();
        ArrayList<AMQSession> sessions = new ArrayList<AMQSession>(this._conn.getSessions().values());
        _logger.info(String.format("Resubscribing sessions = %s sessions.size=%d", sessions, sessions.size()));
        for (AMQSession s : sessions) {
            s.resubscribe();
        }
    }

    @Override
    public void closeConnection(long timeout) throws JMSException, AMQException {
        try {
            this._qpidConnection.close();
        }
        catch (TransportException e) {
            throw new AMQException(e.getMessage(), e);
        }
    }

    @Override
    public void opened(Connection conn) {
    }

    @Override
    public void exception(Connection conn, ConnectionException exc) {
        if (this.exception != null) {
            _logger.error("previous exception", (Throwable)this.exception);
        }
        this.exception = exc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closed(Connection conn) {
        ExceptionListener listener;
        ConnectionException exc = this.exception;
        this.exception = null;
        if (exc == null) {
            return;
        }
        ConnectionClose close = exc.getClose();
        if (close == null) {
            this._conn.getProtocolHandler().setFailoverLatch(new CountDownLatch(1));
            try {
                if (this._conn.firePreFailover(false) && this._conn.attemptReconnection()) {
                    this._conn.failoverPrep();
                    this._conn.resubscribeSessions();
                    this._conn.fireFailoverComplete();
                    return;
                }
            }
            catch (Exception e) {
                _logger.error("error during failover", (Throwable)e);
            }
            finally {
                this._conn.getProtocolHandler().getFailoverLatch().countDown();
                this._conn.getProtocolHandler().setFailoverLatch(null);
            }
        }
        if ((listener = this._conn._exceptionListener) == null) {
            _logger.error("connection exception: " + conn, (Throwable)exc);
        } else {
            String code = null;
            if (close != null) {
                code = close.getReplyCode().toString();
            }
            JMSException ex = new JMSException(exc.getMessage(), code);
            ex.setLinkedException((Exception)exc);
            ex.initCause((Throwable)exc);
            listener.onException(ex);
        }
    }

    @Override
    public <T, E extends Exception> T executeRetrySupport(FailoverProtectedOperation<T, E> operation) throws E {
        try {
            return operation.execute();
        }
        catch (FailoverException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int getMaxChannelID() {
        return this._qpidConnection.getChannelMax() - 1;
    }

    @Override
    public int getMinChannelID() {
        return 0;
    }

    @Override
    public ProtocolVersion getProtocolVersion() {
        return ProtocolVersion.v0_10;
    }

    private void retriveConnectionSettings(ConnectionSettings conSettings, BrokerDetails brokerDetail) {
        conSettings.setHost(brokerDetail.getHost());
        conSettings.setPort(brokerDetail.getPort());
        conSettings.setVhost(this._conn.getVirtualHost());
        conSettings.setUsername(this._conn.getUsername());
        conSettings.setPassword(this._conn.getPassword());
        if (brokerDetail.getProperty("sasl_mechs") != null) {
            conSettings.setSaslMechs(brokerDetail.getProperty("sasl_mechs"));
        }
        if (brokerDetail.getProperty("sasl_protocol") != null) {
            conSettings.setSaslProtocol(brokerDetail.getProperty("sasl_protocol"));
        }
        if (brokerDetail.getProperty("sasl_server") != null) {
            conSettings.setSaslServerName(brokerDetail.getProperty("sasl_server"));
        }
        conSettings.setUseSASLEncryption(brokerDetail.getBooleanProperty("sasl_encryption"));
        conSettings.setUseSSL(brokerDetail.getBooleanProperty("ssl"));
        if (brokerDetail.getProperty("trust_store") != null) {
            conSettings.setTrustStorePath(brokerDetail.getProperty("trust_store"));
        }
        if (brokerDetail.getProperty("trust_store_password") != null) {
            conSettings.setTrustStorePassword(brokerDetail.getProperty("trust_store_password"));
        }
        if (brokerDetail.getProperty("key_store") != null) {
            conSettings.setKeyStorePath(brokerDetail.getProperty("key_store"));
        }
        if (brokerDetail.getProperty("key_store_password") != null) {
            conSettings.setKeyStorePassword(brokerDetail.getProperty("key_store_password"));
        }
        if (brokerDetail.getProperty("ssl_cert_alias") != null) {
            conSettings.setCertAlias(brokerDetail.getProperty("ssl_cert_alias"));
        }
        conSettings.setVerifyHostname(brokerDetail.getBooleanProperty("ssl_verify_hostname"));
        HashMap<String, Object> clientProps = new HashMap<String, Object>();
        try {
            clientProps.put("clientName", this._conn.getClientID());
            conSettings.setClientProperties(clientProps);
        }
        catch (JMSException e) {
            // empty catch block
        }
        if (brokerDetail.getProperty("tcp_nodelay") != null) {
            conSettings.setTcpNodelay(brokerDetail.getBooleanProperty("tcp_nodelay"));
        }
        conSettings.setHeartbeatInterval(this.getHeartbeatInterval(brokerDetail));
    }

    private int getHeartbeatInterval(BrokerDetails brokerDetail) {
        int heartbeat = 0;
        if (brokerDetail.getProperty("idle_timeout") != null) {
            _logger.warn("Broker property idle_timeout=<mili_secs> is deprecated, please use heartbeat=<secs>");
            heartbeat = Integer.parseInt(brokerDetail.getProperty("idle_timeout")) / 1000;
        } else if (brokerDetail.getProperty("heartbeat") != null) {
            heartbeat = Integer.parseInt(brokerDetail.getProperty("heartbeat"));
        } else if (Integer.getInteger("idle_timeout") != null) {
            heartbeat = Integer.getInteger("idle_timeout") / 1000;
            _logger.warn("JVM arg -Didle_timeout=<mili_secs> is deprecated, please use -Dqpid.heartbeat=<secs>");
        } else {
            heartbeat = Integer.getInteger("qpid.heartbeat", 120);
        }
        return heartbeat;
    }

    protected Connection getQpidConnection() {
        return this._qpidConnection;
    }

    @Override
    public void verifyClientID() throws JMSException {
        block2: {
            int prefetch = (int)this._conn.getMaxPrefetch();
            AMQSession_0_10 ssn = (AMQSession_0_10)this.createSession(false, 1, prefetch, prefetch, this._conn.getClientID());
            Session ssn_0_10 = ssn.getQpidSession();
            try {
                ssn_0_10.awaitOpen();
            }
            catch (Exception e) {
                if (ssn_0_10.getDetachCode() == null || ssn_0_10.getDetachCode() != SessionDetachCode.SESSION_BUSY) break block2;
                throw new JMSException("ClientID must be unique");
            }
        }
    }

    static {
        DynamicSaslRegistrar.registerSaslProviders();
    }
}

