/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.andes.service;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.SocketException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.andes.commons.QueueDetails;
import org.wso2.carbon.andes.commons.SubscriptionDetails;
import org.wso2.carbon.andes.commons.registry.RegistryClient;
import org.wso2.carbon.andes.commons.registry.RegistryClientException;
import org.wso2.carbon.andes.internal.QpidServiceDataHolder;
import org.wso2.carbon.andes.service.QpidService;
import org.wso2.carbon.base.api.ServerConfigurationService;
import org.wso2.carbon.utils.NetworkUtils;

public class QpidServiceImpl
implements QpidService {
    private static final Log log = LogFactory.getLog(QpidServiceImpl.class);
    private static String CARBON_CLIENT_ID = "carbon";
    private static String CARBON_VIRTUAL_HOST_NAME = "carbon";
    private static String CARBON_DEFAULT_HOSTNAME = "localhost";
    private static String CARBON_DEFAULT_PORT = "5672";
    private static String CARBON_DEFAULT_SSL_PORT = "8672";
    private static int CARBON_DEFAULT_PORT_OFFSET = 0;
    private static final String QPID_CONF_DIR = "/repository/conf/advanced/";
    private static final String QPID_CONF_FILE = "qpid-config.xml";
    private static final String QPID_VIRTUALHOST_CONF_FILE = "qpid-virtualhosts.xml";
    private static final String QPID_CONF_CONNECTOR_NODE = "connector";
    private static final String QPID_CONF_PORT_NODE = "port";
    private static final String QPID_CONF_SSL_PORT_NODE = "sslport";
    private static final String QPID_CONF_CLUSTER_NODE = "clustering";
    private static final String QPID_CONF_CLUSTER_ENABLE_NODE = "enabled";
    private static final String QPID_CONF_CLUSTER_COORDINATION_NODE = "coordination";
    private static final String QPID_CONF_CLUSTER_ZK_CONNECTION_NODE = "ZooKeeperConnection";
    private static final String QPID_CONF_EXTERNAL_CASSANDRA_SERVER = "externalCassandraServerRequired";
    private static final String QPID_CONF_EXTERNAL_ZOOKEEPER_SERVER = "externalZookeeperServerRequired";
    private static String CARBON_CONFIG_QPID_PORT_NODE = "Ports.EmbeddedQpid.BrokerPort";
    private static String CARBON_CONFIG_QPID_SSL_PORT_NODE = "Ports.EmbeddedQpid.BrokerSSLPort";
    private static String CARBON_CONFIG_PORT_OFFSET_NODE = "Ports.Offset";
    private static final String QPID_VIRTUALHOST_NODE = "virtualhost";
    private static final String QPID_VIRTUALHOST_CARBON_NODE = "carbon";
    private static final String QPID_VIRTUALHOST_STORE_NODE = "store";
    private static final String QPID_VIRTUALHOST_STORE_CONNECTION_STRING_NODE = "connectionString";
    private static final String DOMAIN_NAME_SEPARATOR = "@";
    private static final String DOMAIN_NAME_SEPARATOR_INTERNAL = "!";
    private String accessKey = "";
    private String hostname = "";
    private String port = "";
    private String sslPort = "";
    private int portOffset = 0;
    private String cassandraConnection;
    private String zkConnection;
    private Boolean clsuterEnabled;
    private Boolean externalCassandraRequired;
    private Boolean externalZookeeperRequired;

    public QpidServiceImpl(String accessKey) {
        this.accessKey = accessKey;
        try {
            this.hostname = NetworkUtils.getLocalHostname();
        }
        catch (SocketException e) {
            this.hostname = CARBON_DEFAULT_HOSTNAME;
        }
        this.portOffset = this.readPortOffset();
        this.port = this.readPortFromConfig();
        this.sslPort = this.readSSLPortFromConfig();
    }

    @Override
    public String getAccessKey() {
        return this.accessKey;
    }

    @Override
    public String getClientID() {
        return CARBON_CLIENT_ID;
    }

    @Override
    public String getVirtualHostName() {
        return CARBON_VIRTUAL_HOST_NAME;
    }

    @Override
    public String getHostname() {
        return this.hostname;
    }

    @Override
    public String getPort() {
        return this.port;
    }

    @Override
    public String getInVMConnectionURL(String username) {
        username = this.getInternalTenantUsername(username);
        return new StringBuffer().append("amqp://").append(username).append(":").append(this.accessKey).append(DOMAIN_NAME_SEPARATOR).append(CARBON_CLIENT_ID).append("/").append(CARBON_VIRTUAL_HOST_NAME).append("?brokerlist='vm://:1'").toString();
    }

    @Override
    public String getTCPConnectionURL(String username, String password) {
        return new StringBuffer().append("amqp://").append(username).append(":").append(password).append(DOMAIN_NAME_SEPARATOR).append(CARBON_CLIENT_ID).append("/").append(CARBON_VIRTUAL_HOST_NAME).append("?brokerlist='tcp://").append(this.hostname).append(":").append(this.port).append("'").toString();
    }

    @Override
    public String getTCPConnectionURL(String username, String password, String clientID) {
        return new StringBuffer().append("amqp://").append(username).append(":").append(password).append(DOMAIN_NAME_SEPARATOR).append(clientID).append("/").append(CARBON_VIRTUAL_HOST_NAME).append("?brokerlist='tcp://").append(this.hostname).append(":").append(this.port).append("'").toString();
    }

    @Override
    public String getInternalTCPConnectionURL(String username, String password) {
        username = this.getInternalTenantUsername(username);
        return new StringBuffer().append("amqp://").append(username).append(":").append(password).append(DOMAIN_NAME_SEPARATOR).append(CARBON_CLIENT_ID).append("/").append(CARBON_VIRTUAL_HOST_NAME).append("?brokerlist='tcp://").append(this.hostname).append(":").append(this.port).append("'").toString();
    }

    @Override
    public String getInternalTCPConnectionURL(String username, String password, String clientID) {
        username = this.getInternalTenantUsername(username);
        return new StringBuffer().append("amqp://").append(username).append(":").append(password).append(DOMAIN_NAME_SEPARATOR).append(clientID).append("/").append(CARBON_VIRTUAL_HOST_NAME).append("?brokerlist='tcp://").append(this.hostname).append(":").append(this.port).append("'").toString();
    }

    @Override
    public String getQpidHome() {
        return System.getProperty("carbon.home") + QPID_CONF_DIR;
    }

    @Override
    public QueueDetails[] getQueues(boolean isDurable) {
        QueueDetails[] queueDetails = null;
        try {
            queueDetails = RegistryClient.getQueues();
        }
        catch (RegistryClientException e) {
            log.warn((Object)("Erro while retrieving queue details : " + e.getMessage()));
        }
        return queueDetails;
    }

    @Override
    public SubscriptionDetails[] getSubscriptions(String topic, boolean isDurable) {
        SubscriptionDetails[] subsDetails = null;
        try {
            subsDetails = RegistryClient.getSubscriptions((String)topic);
        }
        catch (RegistryClientException e) {
            log.warn((Object)("Erro while retrieving subscription details : " + e.getMessage()));
        }
        return subsDetails;
    }

    @Override
    public String getSSLPort() {
        return this.sslPort;
    }

    @Override
    public boolean isClusterEnabled() {
        if (this.clsuterEnabled == null) {
            this.clsuterEnabled = this.readClusterEnabledDisabledStatusFromQpidConfig();
            return this.clsuterEnabled;
        }
        return this.clsuterEnabled;
    }

    @Override
    public boolean isExternalCassandraServerRequired() {
        if (this.externalCassandraRequired == null) {
            this.externalCassandraRequired = this.readClusterEnabledDisabledStatusFromQpidConfig();
        }
        return this.externalCassandraRequired;
    }

    @Override
    public boolean isExternalZookeeperServerRequired() {
        if (this.externalZookeeperRequired == null) {
            this.externalZookeeperRequired = this.readExternalZookeeperServerRequiredStatusFromQpidConfig();
        }
        return this.externalZookeeperRequired;
    }

    private int readPortOffset() {
        ServerConfigurationService carbonConfig = QpidServiceDataHolder.getInstance().getCarbonConfiguration();
        String portOffset = carbonConfig.getFirstProperty(CARBON_CONFIG_PORT_OFFSET_NODE);
        try {
            return portOffset != null ? Integer.parseInt(portOffset.trim()) : CARBON_DEFAULT_PORT_OFFSET;
        }
        catch (NumberFormatException e) {
            return CARBON_DEFAULT_PORT_OFFSET;
        }
    }

    private String readPortFromConfig() {
        String port = CARBON_DEFAULT_PORT;
        String portInCarbonConfig = this.readPortFromCarbonConfig();
        if (!portInCarbonConfig.isEmpty()) {
            port = portInCarbonConfig;
        } else {
            String portInQpidConfig = this.readPortFromQpidConfig();
            if (!portInQpidConfig.isEmpty()) {
                port = portInQpidConfig;
            }
        }
        try {
            port = Integer.toString(Integer.parseInt(port) + this.portOffset);
        }
        catch (NumberFormatException e) {
            port = CARBON_DEFAULT_PORT;
        }
        return port;
    }

    private String readPortFromCarbonConfig() {
        ServerConfigurationService carbonConfig = QpidServiceDataHolder.getInstance().getCarbonConfiguration();
        String port = carbonConfig.getFirstProperty(CARBON_CONFIG_QPID_PORT_NODE);
        return port != null ? port.trim() : "";
    }

    private String readPortFromQpidConfig() {
        String port = "";
        try {
            File confFile = new File(this.getQpidHome() + QPID_CONF_FILE);
            OMElement docRootNode = new StAXOMBuilder((InputStream)new FileInputStream(confFile)).getDocumentElement();
            OMElement connectorNode = docRootNode.getFirstChildWithName(new QName(QPID_CONF_CONNECTOR_NODE));
            OMElement portNode = connectorNode.getFirstChildWithName(new QName(QPID_CONF_PORT_NODE));
            port = portNode.getText();
        }
        catch (FileNotFoundException e) {
            log.error((Object)(this.getQpidHome() + QPID_CONF_FILE + " not found"));
        }
        catch (XMLStreamException e) {
            log.error((Object)("Error while reading " + this.getQpidHome() + QPID_CONF_FILE + " : " + e.getMessage()));
        }
        catch (NullPointerException e) {
            log.error((Object)("Invalid configuration : " + this.getQpidHome() + QPID_CONF_FILE));
        }
        return port != null ? port.trim() : "";
    }

    private boolean readExternalZookeeperServerRequiredStatusFromQpidConfig() {
        String required = "";
        try {
            File confFile = new File(this.getQpidHome() + QPID_CONF_FILE);
            OMElement docRootNode = new StAXOMBuilder((InputStream)new FileInputStream(confFile)).getDocumentElement();
            OMElement clusteringNode = docRootNode.getFirstChildWithName(new QName(QPID_CONF_CLUSTER_NODE));
            OMElement statusNode = clusteringNode.getFirstChildWithName(new QName(QPID_CONF_EXTERNAL_ZOOKEEPER_SERVER));
            if (statusNode == null) {
                return false;
            }
            required = statusNode.getText();
        }
        catch (FileNotFoundException e) {
            log.error((Object)(this.getQpidHome() + QPID_CONF_FILE + " not found"));
        }
        catch (XMLStreamException e) {
            log.error((Object)("Error while reading " + this.getQpidHome() + QPID_CONF_FILE + " : " + e.getMessage()));
        }
        catch (NullPointerException e) {
            log.error((Object)("Invalid configuration : " + this.getQpidHome() + QPID_CONF_FILE));
        }
        return "true".equals(required);
    }

    private boolean readClusterEnabledDisabledStatusFromQpidConfig() {
        String required = "";
        try {
            File confFile = new File(this.getQpidHome() + QPID_CONF_FILE);
            OMElement docRootNode = new StAXOMBuilder((InputStream)new FileInputStream(confFile)).getDocumentElement();
            OMElement clusteringNode = docRootNode.getFirstChildWithName(new QName(QPID_CONF_CLUSTER_NODE));
            OMElement statusNode = clusteringNode.getFirstChildWithName(new QName(QPID_CONF_EXTERNAL_CASSANDRA_SERVER));
            if (statusNode == null) {
                return false;
            }
            required = statusNode.getText();
        }
        catch (FileNotFoundException e) {
            log.error((Object)(this.getQpidHome() + QPID_CONF_FILE + " not found"));
        }
        catch (XMLStreamException e) {
            log.error((Object)("Error while reading " + this.getQpidHome() + QPID_CONF_FILE + " : " + e.getMessage()));
        }
        catch (NullPointerException e) {
            log.error((Object)("Invalid configuration : " + this.getQpidHome() + QPID_CONF_FILE));
        }
        return "true".equals(required);
    }

    private boolean readCassandraServerRequirementStatusFromQpidConfig() {
        String enabled = "";
        try {
            File confFile = new File(this.getQpidHome() + QPID_CONF_FILE);
            OMElement docRootNode = new StAXOMBuilder((InputStream)new FileInputStream(confFile)).getDocumentElement();
            OMElement clusteringNode = docRootNode.getFirstChildWithName(new QName(QPID_CONF_CLUSTER_NODE));
            OMElement enabledNode = clusteringNode.getFirstChildWithName(new QName(QPID_CONF_CLUSTER_ENABLE_NODE));
            if (enabledNode == null) {
                return false;
            }
            enabled = enabledNode.getText();
        }
        catch (FileNotFoundException e) {
            log.error((Object)(this.getQpidHome() + QPID_CONF_FILE + " not found"));
        }
        catch (XMLStreamException e) {
            log.error((Object)("Error while reading " + this.getQpidHome() + QPID_CONF_FILE + " : " + e.getMessage()));
        }
        catch (NullPointerException e) {
            log.error((Object)("Invalid configuration : " + this.getQpidHome() + QPID_CONF_FILE));
        }
        return "true".equals(enabled);
    }

    private String readSSLPortFromConfig() {
        String port = CARBON_DEFAULT_SSL_PORT;
        String portInCarbonConfig = this.readSSLPortFromCarbonConfig();
        if (!portInCarbonConfig.isEmpty()) {
            port = portInCarbonConfig;
        } else {
            String portInQpidConfig = this.readSSLPortFromQpidConfig();
            if (!portInQpidConfig.isEmpty()) {
                port = portInQpidConfig;
            }
        }
        try {
            port = Integer.toString(Integer.parseInt(port) + this.portOffset);
        }
        catch (NumberFormatException e) {
            port = CARBON_DEFAULT_SSL_PORT;
        }
        return port;
    }

    private String readSSLPortFromCarbonConfig() {
        ServerConfigurationService carbonConfig = QpidServiceDataHolder.getInstance().getCarbonConfiguration();
        String port = carbonConfig.getFirstProperty(CARBON_CONFIG_QPID_SSL_PORT_NODE);
        return port != null ? port.trim() : "";
    }

    private String readSSLPortFromQpidConfig() {
        String port = "";
        try {
            File confFile = new File(this.getQpidHome() + QPID_CONF_FILE);
            OMElement docRootNode = new StAXOMBuilder((InputStream)new FileInputStream(confFile)).getDocumentElement();
            OMElement connectorNode = docRootNode.getFirstChildWithName(new QName(QPID_CONF_CONNECTOR_NODE));
            OMElement portNode = connectorNode.getFirstChildWithName(new QName(QPID_CONF_SSL_PORT_NODE));
            port = portNode.getText();
        }
        catch (FileNotFoundException e) {
            log.error((Object)(this.getQpidHome() + QPID_CONF_FILE + " not found"));
        }
        catch (XMLStreamException e) {
            log.error((Object)("Error while reading " + this.getQpidHome() + QPID_CONF_FILE + " : " + e.getMessage()));
        }
        catch (NullPointerException e) {
            log.error((Object)("Invalid configuration : " + this.getQpidHome() + QPID_CONF_FILE));
        }
        return port != null ? port.trim() : "";
    }

    private String getInternalTenantUsername(String username) {
        return username.replace(DOMAIN_NAME_SEPARATOR, DOMAIN_NAME_SEPARATOR_INTERNAL);
    }

    @Override
    public String getCassandraConnectionString() {
        if (this.cassandraConnection != null) {
            return this.cassandraConnection.trim();
        }
        try {
            File confFile = new File(this.getQpidHome() + QPID_VIRTUALHOST_CONF_FILE);
            OMElement docRootNode = new StAXOMBuilder((InputStream)new FileInputStream(confFile)).getDocumentElement();
            OMElement virtualHostNode = docRootNode.getFirstChildWithName(new QName(QPID_VIRTUALHOST_NODE));
            OMElement carbonVirtualHost = virtualHostNode.getFirstChildWithName(new QName(QPID_VIRTUALHOST_CARBON_NODE));
            OMElement storeElem = carbonVirtualHost.getFirstChildWithName(new QName(QPID_VIRTUALHOST_STORE_NODE));
            OMElement connectionStr = storeElem.getFirstChildWithName(new QName(QPID_VIRTUALHOST_STORE_CONNECTION_STRING_NODE));
            this.cassandraConnection = connectionStr.getText();
        }
        catch (FileNotFoundException e) {
            log.error((Object)(this.getQpidHome() + QPID_CONF_FILE + " not found"));
        }
        catch (XMLStreamException e) {
            log.error((Object)("Error while reading " + this.getQpidHome() + QPID_CONF_FILE + " : " + e.getMessage()));
        }
        catch (NullPointerException e) {
            log.error((Object)("Invalid configuration : " + this.getQpidHome() + QPID_CONF_FILE));
        }
        return this.cassandraConnection != null ? this.cassandraConnection.trim() : "";
    }

    @Override
    public String getZookeeperConnectionString() {
        if (this.zkConnection != null) {
            return this.zkConnection.trim();
        }
        try {
            File confFile = new File(this.getQpidHome() + QPID_CONF_FILE);
            OMElement docRootNode = new StAXOMBuilder((InputStream)new FileInputStream(confFile)).getDocumentElement();
            OMElement clusteringNode = docRootNode.getFirstChildWithName(new QName(QPID_CONF_CLUSTER_NODE));
            OMElement coordinationNode = clusteringNode.getFirstChildWithName(new QName(QPID_CONF_CLUSTER_COORDINATION_NODE));
            OMElement zkConnectionNode = coordinationNode.getFirstChildWithName(new QName(QPID_CONF_CLUSTER_ZK_CONNECTION_NODE));
            this.zkConnection = zkConnectionNode.getText();
        }
        catch (FileNotFoundException e) {
            log.error((Object)(this.getQpidHome() + QPID_CONF_FILE + " not found"));
        }
        catch (XMLStreamException e) {
            log.error((Object)("Error while reading " + this.getQpidHome() + QPID_CONF_FILE + " : " + e.getMessage()));
        }
        catch (NullPointerException e) {
            log.error((Object)("Invalid configuration : " + this.getQpidHome() + QPID_CONF_FILE));
        }
        return this.zkConnection != null ? this.zkConnection.trim() : "";
    }
}

