/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.andes.internal;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.wso2.andes.server.Main;
import org.wso2.andes.server.registry.ApplicationRegistry;
import org.wso2.andes.wso2.service.QpidNotificationService;
import org.wso2.carbon.andes.authentication.service.AuthenticationService;
import org.wso2.carbon.andes.internal.QpidServiceDataHolder;
import org.wso2.carbon.andes.service.QpidService;
import org.wso2.carbon.andes.service.QpidServiceImpl;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.base.api.ServerConfigurationService;
import org.wso2.carbon.cassandra.server.service.CassandraServerService;
import org.wso2.carbon.coordination.server.service.CoordinationServerService;
import org.wso2.carbon.event.core.EventBundleNotificationService;
import org.wso2.carbon.event.core.qpid.QpidServerDetails;

public class QpidServiceComponent {
    private static final Log log = LogFactory.getLog(QpidServiceComponent.class);
    private static final String VM_BROKER_AUTO_CREATE = "amqj.AutoCreateVMBroker";
    private static final String DERBY_LOG_FILE = "derby.stream.error.file";
    private static final String QPID_DERBY_LOG_FILE = "/repository/logs/qpid-derby-store.log";
    private static final int CASSANDRA_THRIFT_PORT = 9160;
    private static String CARBON_CONFIG_PORT_OFFSET = "Ports.Offset";
    private static String CARBON_CONFIG_HOST_NAME = "HostName";
    private static int CARBON_DEFAULT_PORT_OFFSET = 0;
    private ServiceRegistration qpidService = null;
    private boolean activated = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void activate(ComponentContext ctx) {
        int count;
        if (ctx.getBundleContext().getServiceReference(QpidService.class.getName()) != null) {
            return;
        }
        System.setProperty(VM_BROKER_AUTO_CREATE, "true");
        System.setProperty(DERBY_LOG_FILE, System.getProperty("carbon.home") + QPID_DERBY_LOG_FILE);
        QpidServiceImpl qpidServiceImpl = new QpidServiceImpl(QpidServiceDataHolder.getInstance().getAccessKey());
        CassandraServerService cassandraServerService = QpidServiceDataHolder.getInstance().getCassandraServerService();
        CoordinationServerService coordinationServerService = QpidServiceDataHolder.getInstance().getCoordinationServerService();
        if (coordinationServerService != null) {
            if (qpidServiceImpl.isClusterEnabled() && !qpidServiceImpl.isExternalZookeeperServerRequired()) {
                coordinationServerService.startServer();
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                count = 0;
                while (!this.isCoordinationServerStarted() && ++count <= 60) {
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException e) {}
                }
            }
        } else {
            log.error((Object)"Coordination Server service not set properly server will not start properly");
            throw new RuntimeException("Coordination Server service not set properly server will not start properly");
        }
        if (cassandraServerService != null) {
            if (!qpidServiceImpl.isExternalCassandraServerRequired()) {
                cassandraServerService.startServer();
                count = 0;
                while (!this.isCassandraStarted() && ++count <= 10) {
                    try {
                        Thread.sleep(30000L);
                    }
                    catch (InterruptedException e) {}
                }
            }
        } else {
            log.error((Object)"Cassandra Server service not set properly server will not start properly");
            throw new RuntimeException("Cassandra Server service not set properly server will not start properly");
        }
        try {
            log.debug((Object)"Starting andes server");
            System.setProperty("QPID_HOME", qpidServiceImpl.getQpidHome());
            String[] args = new String[]{"-p" + qpidServiceImpl.getPort(), "-s" + qpidServiceImpl.getSSLPort()};
            Main.main((String[])args);
            Runtime.getRuntime().removeShutdownHook(ApplicationRegistry.getShutdownHook());
            while (!this.isBrokerRunning()) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {}
            }
            boolean isServerStarted = false;
            int port = Integer.parseInt(qpidServiceImpl.getPort());
            while (!isServerStarted) {
                Socket socket = null;
                try {
                    InetAddress address = InetAddress.getByName(this.getCarbonHostName());
                    socket = new Socket(address, port);
                    isServerStarted = socket.isConnected();
                    if (!isServerStarted) continue;
                    log.info((Object)("Successfully connected to the server on port " + qpidServiceImpl.getPort()));
                }
                catch (IOException e) {
                    log.info((Object)("Wait until Qpid server starts on port " + qpidServiceImpl.getPort()));
                    Thread.sleep(500L);
                }
                finally {
                    try {
                        if (socket == null || !socket.isConnected()) continue;
                        socket.close();
                    }
                    catch (IOException e) {
                        log.error((Object)"Can not close the socket with is used to check the server status ");
                    }
                }
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to start Qpid broker : " + e.getMessage()));
        }
        finally {
            this.qpidService = ctx.getBundleContext().registerService(QpidService.class.getName(), (Object)qpidServiceImpl, null);
            QpidServerDetails qpidServerDetails = new QpidServerDetails(qpidServiceImpl.getAccessKey(), qpidServiceImpl.getClientID(), qpidServiceImpl.getVirtualHostName(), qpidServiceImpl.getHostname(), qpidServiceImpl.getPort());
            QpidServiceDataHolder.getInstance().getEventBundleNotificationService().notifyStart(qpidServerDetails);
            this.activated = true;
        }
    }

    protected void deactivate(ComponentContext ctx) {
        try {
            if (null != this.qpidService) {
                this.qpidService.unregister();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        ApplicationRegistry.remove();
    }

    protected void setAccessKey(AuthenticationService authenticationService) {
        QpidServiceDataHolder.getInstance().setAccessKey(authenticationService.getAccessKey());
    }

    protected void unsetAccessKey(AuthenticationService authenticationService) {
        QpidServiceDataHolder.getInstance().setAccessKey(null);
    }

    protected void setQpidNotificationService(QpidNotificationService qpidNotificationService) {
    }

    protected void unsetQpidNotificationService(QpidNotificationService qpidNotificationService) {
    }

    protected void setServerConfiguration(ServerConfigurationService serverConfiguration) {
        QpidServiceDataHolder.getInstance().setCarbonConfiguration(serverConfiguration);
    }

    protected void unsetServerConfiguration(ServerConfigurationService serverConfiguration) {
        QpidServiceDataHolder.getInstance().setCarbonConfiguration(null);
    }

    protected void setEventBundleNotificationService(EventBundleNotificationService eventBundleNotificationService) {
        QpidServiceDataHolder.getInstance().registerEventBundleNotificationService(eventBundleNotificationService);
    }

    protected void unsetEventBundleNotificationService(EventBundleNotificationService eventBundleNotificationService) {
    }

    protected void setCassandraServerService(CassandraServerService cassandraServerService) {
        if (QpidServiceDataHolder.getInstance().getCassandraServerService() == null) {
            QpidServiceDataHolder.getInstance().registerCassandraServerService(cassandraServerService);
        }
    }

    protected void unsetCassandraServerService(CassandraServerService cassandraServerService) {
    }

    protected void setCoordinationServerService(CoordinationServerService coordinationServerService) {
        if (QpidServiceDataHolder.getInstance().getCoordinationServerService() == null) {
            QpidServiceDataHolder.getInstance().setCoordinationServerService(coordinationServerService);
        }
    }

    protected void unsetCoordinationServerService(CoordinationServerService coordinationServerService) {
    }

    private boolean isBrokerRunning() {
        boolean response = false;
        try {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            Set<ObjectName> set = mBeanServer.queryNames(new ObjectName("org.wso2.andes:type=VirtualHost.VirtualHostManager,*"), null);
            if (set.size() > 0) {
                response = true;
            }
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            // empty catch block
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isCassandraStarted() {
        Socket socket = null;
        boolean status = false;
        try {
            int listenPort = 9160 + this.readPortOffset();
            socket = new Socket(InetAddress.getByName(this.getCarbonHostName()), listenPort);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("Unexpected Error while Checking for Cassandra Startup", e);
        }
        catch (IOException e) {
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
                status = true;
            }
        }
        log.debug((Object)("Checking for Cassandra server started status - status :" + status));
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isCoordinationServerStarted() {
        Socket socket = null;
        boolean status = false;
        try {
            CoordinationServerService coordinationServerService = QpidServiceDataHolder.getInstance().getCoordinationServerService();
            String clientPortStr = coordinationServerService.getZKServerConfigurationProperties().getProperty("clientPort");
            int listenPort = clientPortStr != null ? Integer.parseInt(clientPortStr) : 2181 + this.readPortOffset();
            socket = new Socket(InetAddress.getByName(this.getCarbonHostName()), listenPort);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("Unexpected Error while Checking for Cassandra Startup", e);
        }
        catch (IOException e) {
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
                status = true;
            }
        }
        log.debug((Object)("Checking for Cassandra server started status - status :" + status));
        return status;
    }

    private int readPortOffset() {
        ServerConfiguration carbonConfig = ServerConfiguration.getInstance();
        String portOffset = carbonConfig.getFirstProperty(CARBON_CONFIG_PORT_OFFSET);
        try {
            return portOffset != null ? Integer.parseInt(portOffset.trim()) : CARBON_DEFAULT_PORT_OFFSET;
        }
        catch (NumberFormatException e) {
            return CARBON_DEFAULT_PORT_OFFSET;
        }
    }

    private String getCarbonHostName() {
        ServerConfiguration carbonConfig = ServerConfiguration.getInstance();
        String hostName = carbonConfig.getFirstProperty(CARBON_CONFIG_HOST_NAME);
        return hostName != null ? hostName : "localhost";
    }
}

