/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.util;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import org.wso2.andes.server.util.CircularBuffer;

public class LoggingProxy
implements InvocationHandler {
    private final Object _target;
    private final CircularBuffer _log;

    public LoggingProxy(Object target, int size) {
        this._target = target;
        this._log = new CircularBuffer(size);
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            this.entered(method, args);
            Object result = method.invoke(this._target, args);
            this.returned(method, result);
            return result;
        }
        catch (InvocationTargetException e) {
            this.dump();
            throw e.getTargetException();
        }
    }

    void dump() {
        this._log.dump();
    }

    CircularBuffer getBuffer() {
        return this._log;
    }

    private synchronized void entered(Method method, Object[] args) {
        if (args == null) {
            this._log.add(Thread.currentThread() + ": " + method.getName() + "() entered");
        } else {
            this._log.add(Thread.currentThread() + ": " + method.getName() + "(" + Arrays.toString(args) + ") entered");
        }
    }

    private synchronized void returned(Method method, Object result) {
        if (method.getReturnType() == Void.TYPE) {
            this._log.add(Thread.currentThread() + ": " + method.getName() + "() returned");
        } else {
            this._log.add(Thread.currentThread() + ": " + method.getName() + "() returned " + result);
        }
    }

    public Object getProxy(Class ... c) {
        return Proxy.newProxyInstance(this._target.getClass().getClassLoader(), c, (InvocationHandler)this);
    }

    public int getBufferSize() {
        return this._log.size();
    }
}

