/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.store.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import me.prettyprint.cassandra.serializers.ByteBufferSerializer;
import me.prettyprint.cassandra.serializers.BytesArraySerializer;
import me.prettyprint.cassandra.serializers.IntegerSerializer;
import me.prettyprint.cassandra.serializers.LongSerializer;
import me.prettyprint.cassandra.serializers.StringSerializer;
import me.prettyprint.cassandra.service.CassandraHostConfigurator;
import me.prettyprint.cassandra.service.ThriftCfDef;
import me.prettyprint.cassandra.service.ThriftKsDef;
import me.prettyprint.hector.api.Cluster;
import me.prettyprint.hector.api.ConsistencyLevelPolicy;
import me.prettyprint.hector.api.Keyspace;
import me.prettyprint.hector.api.Serializer;
import me.prettyprint.hector.api.beans.ColumnSlice;
import me.prettyprint.hector.api.beans.HColumn;
import me.prettyprint.hector.api.ddl.ColumnFamilyDefinition;
import me.prettyprint.hector.api.ddl.ComparatorType;
import me.prettyprint.hector.api.ddl.KeyspaceDefinition;
import me.prettyprint.hector.api.factory.HFactory;
import me.prettyprint.hector.api.mutation.Mutator;
import me.prettyprint.hector.api.query.ColumnQuery;
import me.prettyprint.hector.api.query.QueryResult;
import me.prettyprint.hector.api.query.SliceQuery;
import org.wso2.andes.server.store.CassandraConsistencyLevelPolicy;
import org.wso2.andes.server.store.util.CassandraDataAccessException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CassandraDataAccessHelper {
    private static final String USERNAME_KEY = "username";
    private static final String PASSWORD_KEY = "password";
    private static StringSerializer stringSerializer = StringSerializer.get();
    private static LongSerializer longSerializer = LongSerializer.get();
    private static BytesArraySerializer bytesArraySerializer = BytesArraySerializer.get();
    private static IntegerSerializer integerSerializer = IntegerSerializer.get();
    private static ByteBufferSerializer byteBufferSerializer = ByteBufferSerializer.get();

    public static Cluster createCluster(String userName, String password, String clusterName, String connectionString) throws CassandraDataAccessException {
        if (userName == null || password == null) {
            throw new CassandraDataAccessException("Can't create cluster with empty userName or Password");
        }
        if (clusterName == null) {
            throw new CassandraDataAccessException("Can't create cluster with empty cluster name");
        }
        if (connectionString == null) {
            throw new CassandraDataAccessException("Can't create cluster with empty connection string");
        }
        HashMap<String, String> credentials = new HashMap<String, String>();
        credentials.put(USERNAME_KEY, userName);
        credentials.put(PASSWORD_KEY, password);
        CassandraHostConfigurator hostConfigurator = new CassandraHostConfigurator(connectionString);
        hostConfigurator.setMaxActive(2000);
        Cluster cluster = HFactory.getCluster((String)clusterName);
        if (cluster == null) {
            cluster = HFactory.createCluster((String)clusterName, (CassandraHostConfigurator)hostConfigurator, credentials);
        }
        return cluster;
    }

    public static void createColumnFamily(String name, String keySpace, Cluster cluster, String comparatorType) throws CassandraDataAccessException {
        KeyspaceDefinition ksDef = cluster.describeKeyspace(keySpace);
        if (ksDef == null) {
            throw new CassandraDataAccessException("Can't create Column family, keyspace " + keySpace + " does not exist");
        }
        ThriftCfDef cfDef = new ThriftCfDef(keySpace, name, ComparatorType.getByClassName((String)comparatorType));
        List cfDefsList = ksDef.getCfDefs();
        HashSet<String> cfNames = new HashSet<String>();
        for (ColumnFamilyDefinition columnFamilyDefinition : cfDefsList) {
            cfNames.add(columnFamilyDefinition.getName());
        }
        if (!cfNames.contains(name)) {
            cluster.addColumnFamily((ColumnFamilyDefinition)cfDef, true);
        }
    }

    public static Keyspace createKeySpace(Cluster cluster, String keySpace) {
        ThriftKsDef definition = new ThriftKsDef(keySpace);
        KeyspaceDefinition def = cluster.describeKeyspace(keySpace);
        if (def == null) {
            cluster.addKeyspace((KeyspaceDefinition)definition, true);
        }
        Keyspace keyspace = HFactory.createKeyspace((String)keySpace, (Cluster)cluster);
        CassandraConsistencyLevelPolicy policy = new CassandraConsistencyLevelPolicy();
        keyspace.setConsistencyLevelPolicy((ConsistencyLevelPolicy)policy);
        return keyspace;
    }

    public static List<String> getRowList(String columnFamilyName, String rowName, Keyspace keyspace) throws CassandraDataAccessException {
        ArrayList<String> rowList = new ArrayList<String>();
        if (keyspace == null) {
            throw new CassandraDataAccessException("Can't access Data , no keyspace provided ");
        }
        if (columnFamilyName == null || rowName == null) {
            throw new CassandraDataAccessException("Can't access data with columnFamily =" + columnFamilyName + " and rowName=" + rowName);
        }
        try {
            SliceQuery sliceQuery = HFactory.createSliceQuery((Keyspace)keyspace, (Serializer)stringSerializer, (Serializer)stringSerializer, (Serializer)stringSerializer);
            sliceQuery.setKey((Object)rowName);
            sliceQuery.setColumnFamily(columnFamilyName);
            sliceQuery.setRange((Object)"", (Object)"", false, 10000);
            QueryResult result = sliceQuery.execute();
            ColumnSlice columnSlice = (ColumnSlice)result.get();
            for (HColumn column : columnSlice.getColumns()) {
                rowList.add((String)column.getName());
            }
        }
        catch (Exception e) {
            throw new CassandraDataAccessException("Error while accessing data from :" + columnFamilyName, e);
        }
        return rowList;
    }

    public static ColumnSlice<Long, byte[]> getMessagesFromQueue(String queueName, String columnFamilyName, Keyspace keyspace, long lastProcessedId, int count) throws CassandraDataAccessException {
        if (keyspace == null) {
            throw new CassandraDataAccessException("Can't access Data , no keyspace provided ");
        }
        if (columnFamilyName == null || queueName == null) {
            throw new CassandraDataAccessException("Can't access data with columnFamily = " + columnFamilyName + " and queueName=" + queueName);
        }
        try {
            SliceQuery sliceQuery = HFactory.createSliceQuery((Keyspace)keyspace, (Serializer)stringSerializer, (Serializer)longSerializer, (Serializer)bytesArraySerializer);
            sliceQuery.setKey((Object)queueName);
            sliceQuery.setRange((Object)(lastProcessedId + 1L), (Object)Long.MAX_VALUE, false, count);
            sliceQuery.setColumnFamily(columnFamilyName);
            QueryResult result = sliceQuery.execute();
            ColumnSlice columnSlice = (ColumnSlice)result.get();
            return columnSlice;
        }
        catch (Exception e) {
            throw new CassandraDataAccessException("Error while getting data from " + columnFamilyName);
        }
    }

    public static ColumnSlice<Long, byte[]> getMessagesFromQueue(String queueName, String columnFamilyName, Keyspace keyspace, int count) throws CassandraDataAccessException {
        if (keyspace == null) {
            throw new CassandraDataAccessException("Can't access Data , no keyspace provided ");
        }
        if (columnFamilyName == null || queueName == null) {
            throw new CassandraDataAccessException("Can't access data with columnFamily = " + columnFamilyName + " and queueName=" + queueName);
        }
        try {
            SliceQuery sliceQuery = HFactory.createSliceQuery((Keyspace)keyspace, (Serializer)stringSerializer, (Serializer)longSerializer, (Serializer)bytesArraySerializer);
            sliceQuery.setKey((Object)queueName);
            sliceQuery.setRange((Object)0L, (Object)Long.MAX_VALUE, false, count);
            sliceQuery.setColumnFamily(columnFamilyName);
            QueryResult result = sliceQuery.execute();
            ColumnSlice columnSlice = (ColumnSlice)result.get();
            return columnSlice;
        }
        catch (Exception e) {
            throw new CassandraDataAccessException("Error while getting data from " + columnFamilyName);
        }
    }

    public static ColumnSlice<String, String> getStringTypeColumnsInARow(String rowName, String columnFamilyName, Keyspace keyspace, int count) throws CassandraDataAccessException {
        if (keyspace == null) {
            throw new CassandraDataAccessException("Can't access Data , no keyspace provided ");
        }
        if (columnFamilyName == null || rowName == null) {
            throw new CassandraDataAccessException("Can't access data with columnFamily = " + columnFamilyName + " and rowName=" + rowName);
        }
        try {
            SliceQuery sliceQuery = HFactory.createSliceQuery((Keyspace)keyspace, (Serializer)stringSerializer, (Serializer)stringSerializer, (Serializer)stringSerializer);
            sliceQuery.setKey((Object)rowName);
            sliceQuery.setColumnFamily(columnFamilyName);
            sliceQuery.setRange((Object)"", (Object)"", false, count);
            QueryResult result = sliceQuery.execute();
            ColumnSlice columnSlice = (ColumnSlice)result.get();
            return columnSlice;
        }
        catch (Exception e) {
            throw new CassandraDataAccessException("Error while getting data from : " + columnFamilyName);
        }
    }

    public static HColumn<Long, byte[]> getLongByteArrayColumnInARow(String rowName, String columnFamily, long key, Keyspace keyspace) throws CassandraDataAccessException {
        if (keyspace == null) {
            throw new CassandraDataAccessException("Can't access Data , no keyspace provided ");
        }
        if (columnFamily == null || rowName == null) {
            throw new CassandraDataAccessException("Can't access data with columnFamily = " + columnFamily + " and rowName=" + rowName);
        }
        try {
            ColumnQuery columnQuery = HFactory.createColumnQuery((Keyspace)keyspace, (Serializer)stringSerializer, (Serializer)longSerializer, (Serializer)bytesArraySerializer);
            columnQuery.setColumnFamily(columnFamily);
            columnQuery.setKey((Object)rowName);
            columnQuery.setName((Object)key);
            QueryResult result = columnQuery.execute();
            HColumn column = (HColumn)result.get();
            return column;
        }
        catch (Exception e) {
            throw new CassandraDataAccessException("Error while executing quary for HColumn<Long, byte[]> with key =" + key + " in column Family = " + columnFamily);
        }
    }

    public static void addMessageToQueue(String columnFamily, String queue, String messageId, byte[] message, Keyspace keyspace) throws CassandraDataAccessException {
        if (keyspace == null) {
            throw new CassandraDataAccessException("Can't add Data , no mutator provided ");
        }
        if (columnFamily == null || queue == null || messageId == null || message == null) {
            throw new CassandraDataAccessException("Can't add data with columnFamily = " + columnFamily + " and queue=" + queue + " message id  = " + messageId + " message = " + message);
        }
        try {
            Mutator mutator = HFactory.createMutator((Keyspace)keyspace, (Serializer)stringSerializer);
            mutator.addInsertion((Object)queue.trim(), columnFamily, HFactory.createColumn((Object)messageId, (Object)message, (Serializer)stringSerializer, (Serializer)bytesArraySerializer));
            mutator.execute();
        }
        catch (Exception e) {
            throw new CassandraDataAccessException("Error while adding message to Queue", e);
        }
    }

    public static void addMessageToQueue(String columnFamily, String queue, long messageId, byte[] message, Keyspace keyspace) throws CassandraDataAccessException {
        if (keyspace == null) {
            throw new CassandraDataAccessException("Can't add Data , no mutator provided ");
        }
        if (columnFamily == null || queue == null || message == null) {
            throw new CassandraDataAccessException("Can't add data with columnFamily = " + columnFamily + " and queue=" + queue + " message id  = " + messageId + " message = " + message);
        }
        try {
            Mutator mutator = HFactory.createMutator((Keyspace)keyspace, (Serializer)stringSerializer);
            mutator.addInsertion((Object)queue.trim(), columnFamily, HFactory.createColumn((Object)messageId, (Object)message, (Serializer)longSerializer, (Serializer)bytesArraySerializer));
            mutator.execute();
        }
        catch (Exception e) {
            throw new CassandraDataAccessException("Error while adding message to Queue", e);
        }
    }

    public static void addMessageToQueue(String columnFamily, String queue, long messageId, byte[] message, Mutator<String> mutator, boolean execute) throws CassandraDataAccessException {
        if (mutator == null) {
            throw new CassandraDataAccessException("Can't add Data , no mutator provided ");
        }
        if (columnFamily == null || queue == null || message == null) {
            throw new CassandraDataAccessException("Can't add data with columnFamily = " + columnFamily + " and queue=" + queue + " message id  = " + messageId + " message = " + message);
        }
        try {
            mutator.addInsertion((Object)queue.trim(), columnFamily, HFactory.createColumn((Object)messageId, (Object)message, (Serializer)longSerializer, (Serializer)bytesArraySerializer));
            if (execute) {
                mutator.execute();
            }
        }
        catch (Exception e) {
            throw new CassandraDataAccessException("Error while adding message to Queue", e);
        }
    }

    public static void addIntegerByteArrayContentToRaw(String columnFamily, String row, int key, byte[] value, Keyspace keyspace) throws CassandraDataAccessException {
        if (keyspace == null) {
            throw new CassandraDataAccessException("Can't add Data , no keySpace provided ");
        }
        if (columnFamily == null || row == null || value == null) {
            throw new CassandraDataAccessException("Can't add data with columnFamily = " + columnFamily + " and row=" + row + " key  = " + key + " value = " + value);
        }
        try {
            Mutator messageContentMutator = HFactory.createMutator((Keyspace)keyspace, (Serializer)stringSerializer);
            messageContentMutator.addInsertion((Object)row, columnFamily, HFactory.createColumn((Object)key, (Object)value, (Serializer)integerSerializer, (Serializer)bytesArraySerializer));
            messageContentMutator.execute();
        }
        catch (Exception e) {
            throw new CassandraDataAccessException("Error while adding new Column <int,byte[]> to cassandra store", e);
        }
    }

    public static void addLongContentToRow(String columnFamily, String row, long key, long value, Keyspace keyspace) throws CassandraDataAccessException {
        if (keyspace == null) {
            throw new CassandraDataAccessException("Can't add Data , no keySpace provided ");
        }
        if (columnFamily == null || row == null) {
            throw new CassandraDataAccessException("Can't add data with columnFamily = " + columnFamily + " and rowName=" + row + " key = " + key);
        }
        try {
            Mutator mutator = HFactory.createMutator((Keyspace)keyspace, (Serializer)stringSerializer);
            mutator.insert((Object)row, columnFamily, HFactory.createColumn((Object)key, (Object)value, (Serializer)longSerializer, (Serializer)longSerializer));
            mutator.execute();
        }
        catch (Exception e) {
            throw new CassandraDataAccessException("Error while adding long content to a row", e);
        }
    }

    public static void addLongByteArrayColumnToRow(String columnFamily, String row, long key, byte[] value, Keyspace keyspace) throws CassandraDataAccessException {
        if (keyspace == null) {
            throw new CassandraDataAccessException("Can't add Data , no keySpace provided ");
        }
        if (columnFamily == null || row == null || value == null) {
            throw new CassandraDataAccessException("Can't add data with columnFamily = " + columnFamily + " and row=" + row + " key  = " + key + " value = " + value);
        }
        try {
            Mutator messageContentMutator = HFactory.createMutator((Keyspace)keyspace, (Serializer)stringSerializer);
            messageContentMutator.addInsertion((Object)row, columnFamily, HFactory.createColumn((Object)key, (Object)value, (Serializer)longSerializer, (Serializer)bytesArraySerializer));
            messageContentMutator.execute();
        }
        catch (Exception e) {
            throw new CassandraDataAccessException("Error while adding new Column <int,byte[]> to cassandra store", e);
        }
    }

    public static void addMappingToRaw(String columnFamily, String row, String cKey, String cValue, Keyspace keyspace) throws CassandraDataAccessException {
        if (keyspace == null) {
            throw new CassandraDataAccessException("Can't add Data , no KeySpace provided ");
        }
        if (columnFamily == null || row == null || cKey == null) {
            throw new CassandraDataAccessException("Can't add data with columnFamily = " + columnFamily + " and rowName=" + row + " key = " + cKey);
        }
        try {
            Mutator mutator = HFactory.createMutator((Keyspace)keyspace, (Serializer)stringSerializer);
            mutator.addInsertion((Object)row, columnFamily, HFactory.createColumn((Object)cKey, (Object)cValue.trim(), (Serializer)stringSerializer, (Serializer)stringSerializer));
            mutator.execute();
        }
        catch (Exception e) {
            throw new CassandraDataAccessException("Error while adding a Mapping to row ", e);
        }
    }

    public static void addMappingToRaw(String columnFamily, String row, String cKey, String cValue, Mutator<String> mutator, boolean execute) throws CassandraDataAccessException {
        if (mutator == null) {
            throw new CassandraDataAccessException("Can't add Data , no mutator provided ");
        }
        if (columnFamily == null || row == null || cKey == null) {
            throw new CassandraDataAccessException("Can't add data with columnFamily = " + columnFamily + " and rowName=" + row + " key = " + cKey);
        }
        try {
            mutator.addInsertion((Object)row, columnFamily, HFactory.createColumn((Object)cKey, (Object)cValue.trim(), (Serializer)stringSerializer, (Serializer)stringSerializer));
            if (execute) {
                mutator.execute();
            }
        }
        catch (Exception e) {
            throw new CassandraDataAccessException("Error while adding a Mapping to row ", e);
        }
    }

    public static void deleteStringColumnFromRaw(String columnFamily, String row, String key, Keyspace keyspace) throws CassandraDataAccessException {
        if (keyspace == null) {
            throw new CassandraDataAccessException("Can't delete Data , no keyspace provided ");
        }
        if (columnFamily == null || row == null || key == null) {
            throw new CassandraDataAccessException("Can't delete data in columnFamily = " + columnFamily + " and rowName=" + row + " key = " + key);
        }
        try {
            Mutator mutator = HFactory.createMutator((Keyspace)keyspace, (Serializer)stringSerializer);
            mutator.addDeletion((Object)row, columnFamily, (Object)key, (Serializer)stringSerializer);
            mutator.execute();
        }
        catch (Exception e) {
            throw new CassandraDataAccessException("Error while deleting " + key + " from " + columnFamily);
        }
    }

    public static void deleteLongColumnFromRaw(String columnFamily, String row, long key, Keyspace keyspace) throws CassandraDataAccessException {
        if (keyspace == null) {
            throw new CassandraDataAccessException("Can't delete Data , no keyspace provided ");
        }
        if (columnFamily == null || row == null) {
            throw new CassandraDataAccessException("Can't delete data in columnFamily = " + columnFamily + " and rowName=" + row + " key = " + key);
        }
        try {
            Mutator mutator = HFactory.createMutator((Keyspace)keyspace, (Serializer)stringSerializer);
            mutator.addDeletion((Object)row, columnFamily, (Object)key, (Serializer)longSerializer);
            mutator.execute();
        }
        catch (Exception e) {
            throw new CassandraDataAccessException("Error while deleting " + key + " from " + columnFamily);
        }
    }

    public static void deleteLongColumnFromRaw(String columnFamily, String row, long key, Mutator<String> mutator, boolean execute) throws CassandraDataAccessException {
        if (mutator == null) {
            throw new CassandraDataAccessException("Can't delete Data , no mutator provided ");
        }
        if (columnFamily == null || row == null) {
            throw new CassandraDataAccessException("Can't delete data in columnFamily = " + columnFamily + " and rowName=" + row + " key = " + key);
        }
        try {
            mutator.addDeletion((Object)row, columnFamily, (Object)key, (Serializer)longSerializer);
            if (execute) {
                mutator.execute();
            }
        }
        catch (Exception e) {
            throw new CassandraDataAccessException("Error while deleting " + key + " from " + columnFamily);
        }
    }

    public static void deleteStringColumnFromRaw(String columnFamily, String row, String key, Mutator<String> mutator, boolean execute) throws CassandraDataAccessException {
        if (mutator == null) {
            throw new CassandraDataAccessException("Can't delete Data , no mutator provided ");
        }
        if (columnFamily == null || row == null || key == null) {
            throw new CassandraDataAccessException("Can't delete data in columnFamily = " + columnFamily + " and rowName=" + row + " key = " + key);
        }
        try {
            mutator.addDeletion((Object)row, columnFamily, (Object)key, (Serializer)stringSerializer);
            if (execute) {
                mutator.execute();
            }
        }
        catch (Exception e) {
            throw new CassandraDataAccessException("Error while deleting " + key + " from " + columnFamily);
        }
    }

    public static void deleteIntegerColumnFromRow(String columnFamily, String row, int key, Mutator<String> mutator, boolean execute) throws CassandraDataAccessException {
        if (mutator == null) {
            throw new CassandraDataAccessException("Can't delete Data , no mutator provided ");
        }
        if (columnFamily == null || row == null) {
            throw new CassandraDataAccessException("Can't delete data in columnFamily = " + columnFamily + " and rowName=" + row + " key = " + key);
        }
        try {
            mutator.addDeletion((Object)row, columnFamily, (Object)key, (Serializer)integerSerializer);
            if (execute) {
                mutator.execute();
            }
        }
        catch (Exception e) {
            throw new CassandraDataAccessException("Error while deleting " + key + " from " + columnFamily);
        }
    }

    public static void deleteIntegerColumnFromRow(String columnFamily, String row, Integer key, Keyspace keyspace) throws CassandraDataAccessException {
        if (keyspace == null) {
            throw new CassandraDataAccessException("Can't delete Data , no keyspace provided ");
        }
        if (columnFamily == null || row == null) {
            throw new CassandraDataAccessException("Can't delete data in columnFamily = " + columnFamily + " and rowName=" + row + " key = " + key);
        }
        try {
            Mutator mutator = HFactory.createMutator((Keyspace)keyspace, (Serializer)stringSerializer);
            mutator.addDeletion((Object)row, columnFamily, (Object)key, (Serializer)integerSerializer);
            mutator.execute();
        }
        catch (Exception e) {
            throw new CassandraDataAccessException("Error while deleting data", e);
        }
    }
}

