/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.store;

import java.io.ByteArrayOutputStream;
import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicLong;
import me.prettyprint.cassandra.serializers.ByteBufferSerializer;
import me.prettyprint.cassandra.serializers.BytesArraySerializer;
import me.prettyprint.cassandra.serializers.IntegerSerializer;
import me.prettyprint.cassandra.serializers.LongSerializer;
import me.prettyprint.cassandra.serializers.StringSerializer;
import me.prettyprint.hector.api.Cluster;
import me.prettyprint.hector.api.ConsistencyLevelPolicy;
import me.prettyprint.hector.api.Keyspace;
import me.prettyprint.hector.api.Serializer;
import me.prettyprint.hector.api.beans.ColumnSlice;
import me.prettyprint.hector.api.beans.HColumn;
import me.prettyprint.hector.api.beans.OrderedRows;
import me.prettyprint.hector.api.beans.Row;
import me.prettyprint.hector.api.factory.HFactory;
import me.prettyprint.hector.api.mutation.Mutator;
import me.prettyprint.hector.api.query.ColumnQuery;
import me.prettyprint.hector.api.query.QueryResult;
import me.prettyprint.hector.api.query.RangeSlicesQuery;
import me.prettyprint.hector.api.query.SliceQuery;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.AMQException;
import org.wso2.andes.AMQStoreException;
import org.wso2.andes.framing.AMQShortString;
import org.wso2.andes.framing.FieldTable;
import org.wso2.andes.server.ClusterResourceHolder;
import org.wso2.andes.server.cassandra.AndesConsistantLevelPolicy;
import org.wso2.andes.server.cassandra.CassandraQueueMessage;
import org.wso2.andes.server.cassandra.CassandraTopicPublisherManager;
import org.wso2.andes.server.cassandra.DefaultClusteringEnabledSubscriptionManager;
import org.wso2.andes.server.cassandra.OnceInOrderEnabledSubscriptionManager;
import org.wso2.andes.server.cluster.ClusterManagementInformationMBean;
import org.wso2.andes.server.cluster.ClusterManager;
import org.wso2.andes.server.cluster.coordination.MessageIdGenerator;
import org.wso2.andes.server.cluster.coordination.SubscriptionCoordinationManagerImpl;
import org.wso2.andes.server.cluster.coordination.TimeStampBasedMessageIdGenerator;
import org.wso2.andes.server.configuration.ClusterConfiguration;
import org.wso2.andes.server.exchange.Exchange;
import org.wso2.andes.server.information.management.QueueManagementInformationMBean;
import org.wso2.andes.server.logging.LogSubject;
import org.wso2.andes.server.message.AMQMessage;
import org.wso2.andes.server.message.MessageMetaData;
import org.wso2.andes.server.message.MessageTransferMessage;
import org.wso2.andes.server.protocol.AMQProtocolSession;
import org.wso2.andes.server.queue.AMQQueue;
import org.wso2.andes.server.queue.BaseQueue;
import org.wso2.andes.server.queue.IncomingMessage;
import org.wso2.andes.server.queue.QueueEntry;
import org.wso2.andes.server.queue.SimpleQueueEntryList;
import org.wso2.andes.server.store.ConfigurationRecoveryHandler;
import org.wso2.andes.server.store.MessageMetaDataType;
import org.wso2.andes.server.store.MessageStore;
import org.wso2.andes.server.store.MessageStoreRecoveryHandler;
import org.wso2.andes.server.store.StorableMessageMetaData;
import org.wso2.andes.server.store.StoredMessage;
import org.wso2.andes.server.store.TransactionLog;
import org.wso2.andes.server.store.TransactionLogRecoveryHandler;
import org.wso2.andes.server.store.TransactionLogResource;
import org.wso2.andes.server.store.util.CassandraDataAccessException;
import org.wso2.andes.server.store.util.CassandraDataAccessHelper;
import org.wso2.andes.server.virtualhost.VirtualHostConfigSynchronizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CassandraMessageStore
implements MessageStore {
    private Cluster cluster;
    private final String USERNAME_KEY = "username";
    private final String PASSWORD_KEY = "password";
    private final String CONNECTION_STRING = "connectionString";
    private final String CLUSTER_KEY = "cluster";
    private final String ID_GENENRATOR = "idGenerator";
    private Keyspace keyspace;
    private static final String KEYSPACE = "QpidKeySpace";
    private static final String LONG_TYPE = "LongType";
    private static final String UTF8_TYPE = "UTF8Type";
    private static final String INTEGER_TYPE = "IntegerType";
    private static final String QUEUE_COLUMN_FAMILY = "Queue";
    private static final String QUEUE_DETAILS_COLUMN_FAMILY = "QueueDetails";
    private static final String QUEUE_DETAILS_ROW = "QUEUE_DETAILS";
    private static final String QUEUE_ENTRY_COLUMN_FAMILY = "QueueEntries";
    private static final String QUEUE_ENTRY_ROW = "QueueEntriesRow";
    private static final String EXCHANGE_COLUMN_FAMILY = "ExchangeColumnFamily";
    private static final String EXCHANGE_ROW = "ExchangesRow";
    private static final String BINDING_COLUMN_FAMILY = "Binding";
    private static final String MESSAGE_CONTENT_COLUMN_FAMILY = "MessageContent";
    private static final String MESSAGE_CONTENT_ID_COLUMN_FAMILY = "MessageContentIDs";
    private static final String MESSAGE_QUEUE_MAPPING_COLUMN_FAMILY = "MessageQueueMappingColumnFamily";
    private static final String MESSAGE_QUEUE_MAPPING_ROW = "MessageQueueMappingRow";
    private static final String SQ_COLUMN_FAMILY = "SubscriptionQueues";
    private static final String GLOBAL_QUEUE_TO_USER_QUEUE_COLUMN_FAMILY = "QpidQueues";
    private static final String USER_QUEUES_COLUMN_FAMILY = "UserQueues";
    private static final String GLOBAL_QUEUES_COLUMN_FAMILY = "GlobalQueue";
    private static final String GLOBAL_QUEUE_LIST_COLUMN_FAMILY = "GlobalQueueList";
    private static final String GLOBAL_QUEUE_LIST_ROW = "GlobalQueueListRow";
    private static final String QMD_COLUMN_FAMILY = "MetaData";
    private static final String QMD_ROW_NAME = "qpidMetaData";
    private static final String MSG_CONTENT_IDS_ROW = "messageContentIds";
    private static final String TOPIC_EXCHANGE_MESSAGE_IDS = "TopicExchangeMessageIds";
    private static final String PUB_SUB_MESSAGE_IDS = "pubSubMessages";
    private static final String TOPIC_SUBSCRIBERS = "topicSubscribers";
    private static final String TOPICS_COLUMN_FAMILY = "topics";
    private static final String TOPICS_ROW = "TOPICS";
    private static final String ACKED_MESSAGE_IDS_COLUMN_FAMILY = "acknowledgedMessageIds";
    private static final String ACKED_MESSAGE_IDS_ROW = "acknowledgedMessageIdsRow";
    private static final String BROWSER_QUEUE_COLUMN_FAMILY = "BrowserQueues";
    private static final String NODE_DETAIL_COLUMN_FAMILY = "CusterNodeDetails";
    private static final String NODE_DETAIL_ROW = "NodeDetailsRow";
    private final AtomicLong _messageId = new AtomicLong(0L);
    private MessageIdGenerator messageIdGenerator = null;
    private SortedMap<Long, Long> contentDeletionTasks = new ConcurrentSkipListMap<Long, Long>();
    private ConcurrentHashMap<Long, Long> pubSubMessageContentDeletionTasks;
    private ContentRemoverTask messageContentRemovalTask = null;
    private PubSubMessageContentRemoverTask pubSubMessageContentRemoverTask = null;
    private ClusterManagementInformationMBean clusterManagementMBean;
    private QueueManagementInformationMBean queueManagementMBean;
    private boolean configured = false;
    private static StringSerializer stringSerializer = StringSerializer.get();
    private static LongSerializer longSerializer = LongSerializer.get();
    private static BytesArraySerializer bytesArraySerializer = BytesArraySerializer.get();
    private static IntegerSerializer integerSerializer = IntegerSerializer.get();
    private static ByteBufferSerializer byteBufferSerializer = ByteBufferSerializer.get();
    private static Log log = LogFactory.getLog(CassandraMessageStore.class);

    public CassandraMessageStore() {
        ClusterResourceHolder.getInstance().setCassandraMessageStore(this);
    }

    public void addMessage(IncomingMessage message) {
        long messageId = message.getMessageNumber();
        MessageMetaData metaData = message.headersReceived();
        for (BaseQueue baseQueue : message.getDestinationQueues()) {
            try {
                int bodySize = 1 + metaData.getStorableSize();
                byte[] underlying = new byte[bodySize];
                underlying[0] = (byte)metaData.getType().ordinal();
                ByteBuffer buf = ByteBuffer.wrap(underlying);
                buf.position(1);
                buf = buf.slice();
                metaData.writeToBuffer(0, buf);
                this.addMessageToGlobalQueue(baseQueue.getResourceName(), messageId, underlying);
            }
            catch (Exception e) {
                throw new RuntimeException("Error while adding messages to queues  ", e);
            }
        }
    }

    public List<QueueEntry> getMessagesFromUserQueue(AMQQueue queue, int messageCount) throws AMQStoreException {
        ArrayList<QueueEntry> messages = null;
        SimpleQueueEntryList list = new SimpleQueueEntryList(queue);
        ClusterManager clusterManager = ClusterResourceHolder.getInstance().getClusterManager();
        String key = queue.getResourceName() + "_" + clusterManager.getNodeId();
        try {
            messages = new ArrayList<QueueEntry>();
            ColumnSlice<Long, byte[]> columnSlice = CassandraDataAccessHelper.getMessagesFromQueue(key, USER_QUEUES_COLUMN_FAMILY, this.keyspace, messageCount);
            for (HColumn column : columnSlice.getColumns()) {
                byte[] value;
                if (!(column instanceof HColumn)) continue;
                long messageId = (Long)column.getName();
                byte[] dataAsBytes = value = (byte[])column.getValue();
                ByteBuffer buf = ByteBuffer.wrap(dataAsBytes);
                buf.position(1);
                buf = buf.slice();
                MessageMetaDataType type = MessageMetaDataType.values()[dataAsBytes[0]];
                StorableMessageMetaData metaData = type.getFactory().createMetaData(buf);
                StoredCassandraMessage message = new StoredCassandraMessage(messageId, metaData);
                AMQMessage amqMessage = new AMQMessage(message);
                messages.add(list.add(amqMessage));
            }
        }
        catch (NumberFormatException e) {
            throw new AMQStoreException("Error while accessing user queue" + key, e);
        }
        catch (Exception e) {
            throw new AMQStoreException("Error while accessing user queue" + key, e);
        }
        return messages;
    }

    public List<QueueEntry> getMessagesFromUserQueue(AMQQueue queue, int messageCount, long lastMessageId) throws AMQStoreException {
        ArrayList<QueueEntry> messages = null;
        SimpleQueueEntryList list = new SimpleQueueEntryList(queue);
        ClusterManager clusterManager = ClusterResourceHolder.getInstance().getClusterManager();
        String key = queue.getResourceName() + "_" + clusterManager.getNodeId();
        try {
            messages = new ArrayList<QueueEntry>();
            ColumnSlice<Long, byte[]> columnSlice = CassandraDataAccessHelper.getMessagesFromQueue(key, USER_QUEUES_COLUMN_FAMILY, this.keyspace, lastMessageId, messageCount);
            for (HColumn column : columnSlice.getColumns()) {
                byte[] value;
                if (!(column instanceof HColumn)) continue;
                long messageId = (Long)column.getName();
                byte[] dataAsBytes = value = (byte[])column.getValue();
                ByteBuffer buf = ByteBuffer.wrap(dataAsBytes);
                buf.position(1);
                buf = buf.slice();
                MessageMetaDataType type = MessageMetaDataType.values()[dataAsBytes[0]];
                StorableMessageMetaData metaData = type.getFactory().createMetaData(buf);
                StoredCassandraMessage message = new StoredCassandraMessage(messageId, metaData);
                AMQMessage amqMessage = new AMQMessage(message);
                messages.add(list.add(amqMessage));
            }
        }
        catch (NumberFormatException e) {
            throw new AMQStoreException("Error while accessing user queue" + key, e);
        }
        catch (Exception e) {
            throw new AMQStoreException("Error while accessing user queue" + key, e);
        }
        return messages;
    }

    public List<CassandraQueueMessage> getMessagesFromUserQueue(String userQueue, String globalQueue, int messageCount) {
        ArrayList<CassandraQueueMessage> messages = new ArrayList<CassandraQueueMessage>();
        ClusterManager clusterManager = ClusterResourceHolder.getInstance().getClusterManager();
        try {
            ColumnSlice<Long, byte[]> columnSlice = CassandraDataAccessHelper.getMessagesFromQueue(userQueue.trim(), USER_QUEUES_COLUMN_FAMILY, this.keyspace, messageCount);
            for (HColumn column : columnSlice.getColumns()) {
                byte[] value;
                if (!(column instanceof HColumn)) continue;
                long messageId = (Long)column.getName();
                byte[] dataAsBytes = value = (byte[])column.getValue();
                ByteBuffer buf = ByteBuffer.wrap(dataAsBytes);
                buf.position(1);
                buf = buf.slice();
                CassandraQueueMessage cqm = new CassandraQueueMessage(messageId, globalQueue, dataAsBytes);
                messages.add(cqm);
            }
        }
        catch (NumberFormatException e) {
            log.error((Object)e);
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        return messages;
    }

    public int getMessageCountOfUserQueues(String queueName) {
        int messageCount = 0;
        try {
            List<String> userQueues = this.getUserQueues(queueName);
            for (String userQueue : userQueues) {
                ColumnSlice<Long, byte[]> columnSlice = CassandraDataAccessHelper.getMessagesFromQueue(userQueue.trim(), USER_QUEUES_COLUMN_FAMILY, this.keyspace, Integer.MAX_VALUE);
                messageCount = columnSlice.getColumns().size();
            }
        }
        catch (NumberFormatException e) {
            log.error((Object)("Number format error in getting messages from global queue : " + queueName), (Throwable)e);
        }
        catch (Exception e) {
            log.error((Object)("Error in getting messages from global queue: " + queueName), (Throwable)e);
        }
        return messageCount;
    }

    public int getMessageCountOfGlobalQueue(String queueName) {
        int messageCount = 0;
        try {
            ColumnSlice<Long, byte[]> columnSlice = CassandraDataAccessHelper.getMessagesFromQueue(queueName.trim(), GLOBAL_QUEUES_COLUMN_FAMILY, this.keyspace, Integer.MAX_VALUE);
            messageCount = columnSlice.getColumns().size();
        }
        catch (NumberFormatException e) {
            log.error((Object)("Number format error in getting messages from global queue : " + queueName), (Throwable)e);
        }
        catch (Exception e) {
            log.error((Object)("Error in getting messages from global queue: " + queueName), (Throwable)e);
        }
        return messageCount;
    }

    public Queue<CassandraQueueMessage> getMessagesFromGlobalQueue(String queueName, int messageCount) throws AMQStoreException {
        LinkedList<CassandraQueueMessage> messages = null;
        try {
            messages = new LinkedList<CassandraQueueMessage>();
            ColumnSlice<Long, byte[]> columnSlice = CassandraDataAccessHelper.getMessagesFromQueue(queueName.trim(), GLOBAL_QUEUES_COLUMN_FAMILY, this.keyspace, messageCount);
            for (HColumn column : columnSlice.getColumns()) {
                if (!(column instanceof HColumn)) continue;
                long messageId = (Long)column.getName();
                byte[] value = (byte[])column.getValue();
                CassandraQueueMessage msg = new CassandraQueueMessage(messageId, queueName, value);
                messages.add(msg);
            }
        }
        catch (NumberFormatException e) {
            throw new AMQStoreException("Number format error in getting messages from global queue : " + queueName, e);
        }
        catch (Exception e) {
            throw new AMQStoreException("Error in getting messages from global queue: " + queueName, e);
        }
        return messages;
    }

    public List<QueueEntry> getMessagesFromGlobalQueue(AMQQueue queue, AMQProtocolSession session, int messageCount) throws AMQStoreException {
        ArrayList<QueueEntry> messages = null;
        SimpleQueueEntryList list = new SimpleQueueEntryList(queue);
        try {
            messages = new ArrayList<QueueEntry>();
            ColumnSlice<Long, byte[]> columnSlice = CassandraDataAccessHelper.getMessagesFromQueue(queue.getName().trim(), GLOBAL_QUEUES_COLUMN_FAMILY, this.keyspace, messageCount);
            for (HColumn column : columnSlice.getColumns()) {
                byte[] value;
                if (!(column instanceof HColumn)) continue;
                long messageId = (Long)column.getName();
                byte[] dataAsBytes = value = (byte[])column.getValue();
                ByteBuffer buf = ByteBuffer.wrap(dataAsBytes);
                buf.position(1);
                buf = buf.slice();
                MessageMetaDataType type = MessageMetaDataType.values()[dataAsBytes[0]];
                StorableMessageMetaData metaData = type.getFactory().createMetaData(buf);
                StoredCassandraMessage message = new StoredCassandraMessage(messageId, metaData);
                AMQMessage amqMessage = new AMQMessage(message);
                amqMessage.setClientIdentifier(session);
                messages.add(list.add(amqMessage));
            }
        }
        catch (Exception e) {
            throw new AMQStoreException("Error while getting messages from queue : " + queue, e);
        }
        return messages;
    }

    public void dequeueMessages(AMQQueue queue, List<QueueEntry> messagesToDelete) {
        try {
            List<QueueEntry> messages = messagesToDelete;
            ClusterManager clusterManager = ClusterResourceHolder.getInstance().getClusterManager();
            String key = queue.getResourceName() + "_" + clusterManager.getNodeId();
            for (QueueEntry queueEntry : messages) {
                this.removeMessageFromUserQueue(key, queueEntry.getMessage().getMessageNumber());
            }
        }
        catch (Exception e) {
            log.error((Object)("Error in dequeuing messages from " + queue.getName()), (Throwable)e);
        }
    }

    public void removeMessageFromUserQueue(String queueName, long messageId) throws AMQStoreException {
        try {
            CassandraDataAccessHelper.deleteLongColumnFromRaw(USER_QUEUES_COLUMN_FAMILY, queueName, messageId, this.keyspace);
        }
        catch (CassandraDataAccessException e) {
            throw new AMQStoreException("Error while removing message from User queue", e);
        }
    }

    public void removeMessageBatchFromUserQueue(String queueName, List<CassandraQueueMessage> msgList) throws AMQStoreException {
        Mutator mutator = HFactory.createMutator((Keyspace)this.keyspace, (Serializer)stringSerializer);
        try {
            for (CassandraQueueMessage msg : msgList) {
                CassandraDataAccessHelper.deleteLongColumnFromRaw(USER_QUEUES_COLUMN_FAMILY, queueName, msg.getMessageId(), (Mutator<String>)mutator, false);
            }
        }
        catch (CassandraDataAccessException e) {
            throw new AMQStoreException("Error while removing messages from User queue", e);
        }
        finally {
            mutator.execute();
        }
    }

    public void removeMessageFromGlobalQueue(String queueName, long messageId) {
        try {
            CassandraDataAccessHelper.deleteLongColumnFromRaw(GLOBAL_QUEUES_COLUMN_FAMILY, queueName, messageId, this.keyspace);
        }
        catch (CassandraDataAccessException e) {
            log.error((Object)("Error while removing messages from global queue " + queueName), (Throwable)e);
        }
    }

    public void removeMessageFromGlobalQueue(String queueName, long messageId, Mutator<String> mutator) {
        try {
            CassandraDataAccessHelper.deleteLongColumnFromRaw(GLOBAL_QUEUES_COLUMN_FAMILY, queueName, messageId, mutator, false);
        }
        catch (CassandraDataAccessException e) {
            log.error((Object)("Error while removing messages from global queue " + queueName), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transferMessageBatchFromGlobalQueueToUserQueue(CassandraQueueMessage[] list, String globalQueueName) {
        Mutator mutator = HFactory.createMutator((Keyspace)this.keyspace, (Serializer)stringSerializer);
        try {
            for (CassandraQueueMessage msg : list) {
                this.addMessageToUserQueue(msg.getQueue(), msg.getMessageId(), msg.getMessage(), (Mutator<String>)mutator);
                this.removeMessageFromGlobalQueue(globalQueueName, msg.getMessageId(), (Mutator<String>)mutator);
            }
        }
        catch (CassandraDataAccessException e) {
            e.printStackTrace();
            log.error((Object)"Error while transferring messages from Global Queue to User Queues");
        }
        finally {
            mutator.execute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMessageBatchFromGlobalQueue(List<CassandraQueueMessage> list, String globalQUeueName) {
        Mutator mutator = HFactory.createMutator((Keyspace)this.keyspace, (Serializer)stringSerializer);
        try {
            for (CassandraQueueMessage msg : list) {
                this.removeMessageFromGlobalQueue(globalQUeueName, msg.getMessageId(), (Mutator<String>)mutator);
            }
        }
        finally {
            mutator.execute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recover(ConfigurationRecoveryHandler recoveryHandler) throws AMQException {
        boolean readyOrTimeOut = false;
        boolean error = false;
        int initTimeOut = 10;
        int count = 0;
        int maxTries = 10;
        while (!readyOrTimeOut) {
            try {
                ConfigurationRecoveryHandler.QueueRecoveryHandler qrh = recoveryHandler.begin(this);
                this.loadQueues(qrh);
                ConfigurationRecoveryHandler.ExchangeRecoveryHandler erh = qrh.completeQueueRecovery();
                List<String> exchanges = this.loadExchanges(erh);
                ConfigurationRecoveryHandler.BindingRecoveryHandler brh = erh.completeExchangeRecovery();
                this.recoverBindings(brh, exchanges);
                brh.completeBindingRecovery();
            }
            catch (Exception e) {
                error = true;
                log.error((Object)("Error recovering persistent state: " + e.getMessage()), (Throwable)e);
            }
            finally {
                if (!error) {
                    readyOrTimeOut = true;
                    continue;
                }
                long waitTime = (long)(initTimeOut * 1000) * (long)Math.pow(2.0, count);
                log.warn((Object)("Waiting for Cluster data to be synced Please ,start the other nodes soon, wait time: " + waitTime + "ms"));
                try {
                    Thread.sleep(waitTime);
                }
                catch (InterruptedException e) {}
                if (count > maxTries) {
                    readyOrTimeOut = true;
                    throw new AMQStoreException("Max Backoff attempts expired for data recovery");
                }
                ++count;
            }
        }
    }

    private Keyspace createKeySpace() throws CassandraDataAccessException {
        this.keyspace = CassandraDataAccessHelper.createKeySpace(this.cluster, KEYSPACE);
        CassandraDataAccessHelper.createColumnFamily(QUEUE_COLUMN_FAMILY, KEYSPACE, this.cluster, LONG_TYPE);
        CassandraDataAccessHelper.createColumnFamily(BINDING_COLUMN_FAMILY, KEYSPACE, this.cluster, UTF8_TYPE);
        CassandraDataAccessHelper.createColumnFamily(MESSAGE_CONTENT_COLUMN_FAMILY, KEYSPACE, this.cluster, INTEGER_TYPE);
        CassandraDataAccessHelper.createColumnFamily(MESSAGE_CONTENT_ID_COLUMN_FAMILY, KEYSPACE, this.cluster, LONG_TYPE);
        CassandraDataAccessHelper.createColumnFamily(SQ_COLUMN_FAMILY, KEYSPACE, this.cluster, UTF8_TYPE);
        CassandraDataAccessHelper.createColumnFamily(GLOBAL_QUEUE_TO_USER_QUEUE_COLUMN_FAMILY, KEYSPACE, this.cluster, UTF8_TYPE);
        CassandraDataAccessHelper.createColumnFamily(QMD_COLUMN_FAMILY, KEYSPACE, this.cluster, LONG_TYPE);
        CassandraDataAccessHelper.createColumnFamily(QUEUE_DETAILS_COLUMN_FAMILY, KEYSPACE, this.cluster, UTF8_TYPE);
        CassandraDataAccessHelper.createColumnFamily(QUEUE_ENTRY_COLUMN_FAMILY, KEYSPACE, this.cluster, UTF8_TYPE);
        CassandraDataAccessHelper.createColumnFamily(EXCHANGE_COLUMN_FAMILY, KEYSPACE, this.cluster, UTF8_TYPE);
        CassandraDataAccessHelper.createColumnFamily(USER_QUEUES_COLUMN_FAMILY, KEYSPACE, this.cluster, LONG_TYPE);
        CassandraDataAccessHelper.createColumnFamily(MESSAGE_QUEUE_MAPPING_COLUMN_FAMILY, KEYSPACE, this.cluster, UTF8_TYPE);
        CassandraDataAccessHelper.createColumnFamily(GLOBAL_QUEUES_COLUMN_FAMILY, KEYSPACE, this.cluster, LONG_TYPE);
        CassandraDataAccessHelper.createColumnFamily(GLOBAL_QUEUE_LIST_COLUMN_FAMILY, KEYSPACE, this.cluster, UTF8_TYPE);
        CassandraDataAccessHelper.createColumnFamily(TOPIC_EXCHANGE_MESSAGE_IDS, KEYSPACE, this.cluster, LONG_TYPE);
        CassandraDataAccessHelper.createColumnFamily(PUB_SUB_MESSAGE_IDS, KEYSPACE, this.cluster, LONG_TYPE);
        CassandraDataAccessHelper.createColumnFamily(TOPIC_SUBSCRIBERS, KEYSPACE, this.cluster, UTF8_TYPE);
        CassandraDataAccessHelper.createColumnFamily(TOPICS_COLUMN_FAMILY, KEYSPACE, this.cluster, UTF8_TYPE);
        CassandraDataAccessHelper.createColumnFamily(ACKED_MESSAGE_IDS_COLUMN_FAMILY, KEYSPACE, this.cluster, LONG_TYPE);
        CassandraDataAccessHelper.createColumnFamily(BROWSER_QUEUE_COLUMN_FAMILY, KEYSPACE, this.cluster, LONG_TYPE);
        CassandraDataAccessHelper.createColumnFamily(NODE_DETAIL_COLUMN_FAMILY, KEYSPACE, this.cluster, UTF8_TYPE);
        return this.keyspace;
    }

    private int getUserQueueCount(String qpidQueueName) throws AMQStoreException {
        int queueCount = 0;
        try {
            ColumnSlice<String, String> columnSlice = CassandraDataAccessHelper.getStringTypeColumnsInARow(qpidQueueName, GLOBAL_QUEUE_TO_USER_QUEUE_COLUMN_FAMILY, this.keyspace, Integer.MAX_VALUE);
            queueCount = columnSlice.getColumns().size();
        }
        catch (Exception e) {
            throw new AMQStoreException("Error in getting user queue count", e);
        }
        return queueCount;
    }

    public void addMessageToUserQueue(String userQueue, long messageId, byte[] message, Mutator<String> mutator) throws CassandraDataAccessException {
        try {
            CassandraDataAccessHelper.addMessageToQueue(USER_QUEUES_COLUMN_FAMILY, userQueue, messageId, message, mutator, false);
            CassandraDataAccessHelper.addMappingToRaw(MESSAGE_QUEUE_MAPPING_COLUMN_FAMILY, MESSAGE_QUEUE_MAPPING_ROW, "" + messageId, userQueue, mutator, false);
        }
        catch (Exception e) {
            throw new CassandraDataAccessException("Error in adding message :" + messageId + " to user queue :" + userQueue, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessageBatchToUserQueues(CassandraQueueMessage[] messages) throws CassandraDataAccessException {
        try {
            Mutator mutator = HFactory.createMutator((Keyspace)this.keyspace, (Serializer)stringSerializer);
            try {
                for (CassandraQueueMessage message : messages) {
                    this.addMessageToUserQueue(message.getQueue(), message.getMessageId(), message.getMessage(), (Mutator<String>)mutator);
                }
            }
            finally {
                mutator.execute();
            }
        }
        catch (CassandraDataAccessException e) {
            throw new CassandraDataAccessException("Error in adding message batch to Queues ", e);
        }
    }

    public void addMessageToBrowserQueue(String queue, List<CassandraQueueMessage> messages) throws Exception {
        try {
            for (CassandraQueueMessage message : messages) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Adding message with id " + message.getMessageId() + " to browser queue " + queue));
                }
                CassandraDataAccessHelper.addMessageToQueue(BROWSER_QUEUE_COLUMN_FAMILY, queue, message.getMessageId(), message.getMessage(), this.keyspace);
            }
        }
        catch (CassandraDataAccessException e) {
            log.error((Object)("Error in adding message to browser queue " + queue), (Throwable)e);
            throw new Exception("Error in adding message to browser queue " + queue, e);
        }
    }

    public List<QueueEntry> getMessagesFromBrowserQueue(AMQQueue queue, AMQProtocolSession session, int messageCount) throws AMQStoreException {
        ArrayList<QueueEntry> messages = null;
        SimpleQueueEntryList list = new SimpleQueueEntryList(queue);
        try {
            messages = new ArrayList<QueueEntry>();
            ColumnSlice<Long, byte[]> columnSlice = CassandraDataAccessHelper.getMessagesFromQueue(queue.getName().trim(), BROWSER_QUEUE_COLUMN_FAMILY, this.keyspace, messageCount);
            for (HColumn column : columnSlice.getColumns()) {
                byte[] value;
                if (!(column instanceof HColumn)) continue;
                long messageId = (Long)column.getName();
                byte[] dataAsBytes = value = (byte[])column.getValue();
                ByteBuffer buf = ByteBuffer.wrap(dataAsBytes);
                buf.position(1);
                buf = buf.slice();
                MessageMetaDataType type = MessageMetaDataType.values()[dataAsBytes[0]];
                StorableMessageMetaData metaData = type.getFactory().createMetaData(buf);
                StoredCassandraMessage message = new StoredCassandraMessage(messageId, metaData);
                AMQMessage amqMessage = new AMQMessage(message);
                amqMessage.setClientIdentifier(session);
                messages.add(list.add(amqMessage));
            }
        }
        catch (Exception e) {
            throw new AMQStoreException("Error while getting messages from queue : " + queue, e);
        }
        return messages;
    }

    public void clearBrowserQueue(List<QueueEntry> messages, String queueName) throws CassandraDataAccessException {
        for (QueueEntry message : messages) {
            CassandraDataAccessHelper.deleteLongColumnFromRaw(BROWSER_QUEUE_COLUMN_FAMILY, queueName, message.getMessage().getMessageNumber(), this.keyspace);
        }
    }

    public void addMessageToGlobalQueue(String queue, long messageId, byte[] message) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Adding Message with id " + messageId + " to Queue " + queue));
        }
        ClusterManager clusterManager = ClusterResourceHolder.getInstance().getClusterManager();
        try {
            CassandraDataAccessHelper.addMessageToQueue(GLOBAL_QUEUES_COLUMN_FAMILY, queue, messageId, message, this.keyspace);
            CassandraDataAccessHelper.addMappingToRaw(GLOBAL_QUEUE_LIST_COLUMN_FAMILY, GLOBAL_QUEUE_LIST_ROW, queue, queue, this.keyspace);
            clusterManager.handleQueueAddition(queue);
        }
        catch (Exception e) {
            log.error((Object)"Error in adding message to global queue", (Throwable)e);
            throw new Exception("Error in adding message to global queue", e);
        }
    }

    public void addMessageContent(String messageId, int offset, ByteBuffer src) throws AMQStoreException {
        try {
            String rowKey = "mid" + messageId;
            src = src.slice();
            byte[] chunkData = new byte[src.limit()];
            src.duplicate().get(chunkData);
            CassandraDataAccessHelper.addIntegerByteArrayContentToRaw(MESSAGE_CONTENT_COLUMN_FAMILY, rowKey.trim(), offset, chunkData, this.keyspace);
        }
        catch (Exception e) {
            throw new AMQStoreException("Error in adding message content", e);
        }
    }

    public void removeMessageContent(String messageId) throws AMQStoreException {
        try {
            String rowKey = "mid" + messageId;
            CassandraDataAccessHelper.deleteIntegerColumnFromRow(MESSAGE_CONTENT_COLUMN_FAMILY, rowKey.trim(), null, this.keyspace);
        }
        catch (Exception e) {
            throw new AMQStoreException("Error in removing message content", e);
        }
    }

    private int getContent(String messageId, int offsetValue, ByteBuffer dst) {
        int written = 0;
        int chunkSize = 65534;
        try {
            int posInArray;
            String rowKey = "mid" + messageId;
            if (offsetValue == 0) {
                ColumnQuery columnQuery = HFactory.createColumnQuery((Keyspace)this.keyspace, (Serializer)stringSerializer, (Serializer)integerSerializer, (Serializer)byteBufferSerializer);
                columnQuery.setColumnFamily(MESSAGE_CONTENT_COLUMN_FAMILY);
                columnQuery.setKey((Object)rowKey.trim());
                columnQuery.setName((Object)offsetValue);
                QueryResult result = columnQuery.execute();
                HColumn column = (HColumn)result.get();
                if (column != null) {
                    int posInArray2;
                    int offset = (Integer)column.getName();
                    byte[] content = bytesArraySerializer.fromByteBuffer((ByteBuffer)column.getValue());
                    int size = content.length;
                    int count = size - (posInArray2 = offset + written - offset);
                    if (count > dst.remaining()) {
                        count = dst.remaining();
                    }
                    dst.put(content, 0, count);
                    return count;
                }
                throw new RuntimeException("Unexpected Error , content already deleted");
            }
            ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
            int k = offsetValue / chunkSize;
            SliceQuery query = HFactory.createSliceQuery((Keyspace)this.keyspace, (Serializer)stringSerializer, (Serializer)integerSerializer, (Serializer)byteBufferSerializer);
            query.setColumnFamily(MESSAGE_CONTENT_COLUMN_FAMILY);
            query.setKey((Object)rowKey.trim());
            query.setRange((Object)(k * chunkSize), (Object)((k + 1) * chunkSize + 1), false, 10);
            QueryResult result = query.execute();
            ColumnSlice columnSlice = (ColumnSlice)result.get();
            boolean added = false;
            for (HColumn column : columnSlice.getColumns()) {
                added = true;
                byteOutputStream.write(bytesArraySerializer.fromByteBuffer((ByteBuffer)column.getValue()));
            }
            byte[] content = byteOutputStream.toByteArray();
            int size = content.length;
            int count = size - (posInArray = offsetValue - k * chunkSize);
            if (count > dst.remaining()) {
                count = dst.remaining();
            }
            dst.put(content, posInArray, count);
            return written += count;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)"Error in reading content", (Throwable)e);
            return written;
        }
    }

    public void storeMetaData(long messageId, StorableMessageMetaData metaData) {
        try {
            int bodySize = 1 + metaData.getStorableSize();
            byte[] underlying = new byte[bodySize];
            underlying[0] = (byte)metaData.getType().ordinal();
            ByteBuffer buf = ByteBuffer.wrap(underlying);
            buf.position(1);
            buf = buf.slice();
            metaData.writeToBuffer(0, buf);
            Mutator mutator = HFactory.createMutator((Keyspace)this.keyspace, (Serializer)stringSerializer);
            mutator.addInsertion((Object)QMD_ROW_NAME, QMD_COLUMN_FAMILY, HFactory.createColumn((Object)messageId, (Object)underlying, (Serializer)longSerializer, (Serializer)bytesArraySerializer));
            mutator.execute();
        }
        catch (Exception e) {
            log.error((Object)"Error in storing meta data", (Throwable)e);
        }
    }

    private StorableMessageMetaData getMetaData(long messageId) {
        StorableMessageMetaData metaData = null;
        try {
            HColumn<Long, byte[]> column = CassandraDataAccessHelper.getLongByteArrayColumnInARow(QMD_ROW_NAME, QMD_COLUMN_FAMILY, messageId, this.keyspace);
            byte[] dataAsBytes = (byte[])column.getValue();
            ByteBuffer buf = ByteBuffer.wrap(dataAsBytes);
            buf.position(1);
            buf = buf.slice();
            MessageMetaDataType type = MessageMetaDataType.values()[dataAsBytes[0]];
            metaData = type.getFactory().createMetaData(buf);
        }
        catch (Exception e) {
            log.error((Object)"Error in getting meta data of provided message id", (Throwable)e);
        }
        return metaData;
    }

    private void removeMetaData(long messageId) throws AMQStoreException {
        try {
            Mutator mutator = HFactory.createMutator((Keyspace)this.keyspace, (Serializer)stringSerializer);
            CassandraDataAccessHelper.deleteLongColumnFromRaw(QMD_COLUMN_FAMILY, QMD_ROW_NAME, messageId, (Mutator<String>)mutator, true);
        }
        catch (Exception e) {
            throw new AMQStoreException("Error in removing metadata", e);
        }
    }

    public void addAckedMessage(long messageId) {
        try {
            this.pubSubMessageContentDeletionTasks.put(messageId, messageId);
            Mutator mutator = HFactory.createMutator((Keyspace)this.keyspace, (Serializer)stringSerializer);
            long ackTime = System.currentTimeMillis();
            mutator.addInsertion((Object)ACKED_MESSAGE_IDS_ROW, ACKED_MESSAGE_IDS_COLUMN_FAMILY, HFactory.createColumn((Object)messageId, (Object)ackTime, (Serializer)longSerializer, (Serializer)longSerializer));
            mutator.execute();
        }
        catch (Exception e) {
            log.error((Object)"Error in storing meta data", (Throwable)e);
        }
    }

    private void removeAckedMessage(long messageId) throws AMQStoreException {
        try {
            Mutator mutator = HFactory.createMutator((Keyspace)this.keyspace, (Serializer)stringSerializer);
            CassandraDataAccessHelper.deleteLongColumnFromRaw(ACKED_MESSAGE_IDS_COLUMN_FAMILY, ACKED_MESSAGE_IDS_ROW, messageId, (Mutator<String>)mutator, true);
        }
        catch (Exception e) {
            throw new AMQStoreException("Error in storing meta data", e);
        }
    }

    public boolean isReadyAndRemovedMessageContent(long messageId) {
        long currentSystemTime = System.currentTimeMillis();
        try {
            ColumnQuery columnQuery = HFactory.createColumnQuery((Keyspace)this.keyspace, (Serializer)stringSerializer, (Serializer)longSerializer, (Serializer)longSerializer);
            columnQuery.setKey((Object)ACKED_MESSAGE_IDS_ROW);
            columnQuery.setColumnFamily(ACKED_MESSAGE_IDS_COLUMN_FAMILY);
            columnQuery.setName((Object)messageId);
            QueryResult result = columnQuery.execute();
            if (result != null) {
                HColumn column = (HColumn)result.get();
                ClusterConfiguration clusterConfiguration = ClusterResourceHolder.getInstance().getClusterConfiguration();
                if (currentSystemTime - (Long)column.getValue() >= (long)clusterConfiguration.getContentRemovalTimeDifference()) {
                    this.removeMetaData(messageId);
                    this.removeAckedMessage(messageId);
                    return true;
                }
                return false;
            }
            return true;
        }
        catch (Exception e) {
            log.error((Object)"Error while removing Message data", (Throwable)e);
            return false;
        }
    }

    public void addBinding(Exchange exchange, AMQQueue amqQueue, String routingKey) throws CassandraDataAccessException {
        if (this.keyspace == null) {
            return;
        }
        String columnName = routingKey;
        String columnValue = amqQueue.getName();
        CassandraDataAccessHelper.addMappingToRaw(BINDING_COLUMN_FAMILY, exchange.getName(), columnName, columnValue, this.keyspace);
    }

    public void removeBinding(Exchange exchange, AMQQueue amqQueue, String routingKey) throws CassandraDataAccessException {
        if (this.keyspace == null) {
            return;
        }
        CassandraDataAccessHelper.deleteStringColumnFromRaw(BINDING_COLUMN_FAMILY, exchange.getName(), routingKey, this.keyspace);
    }

    public void addTopicExchangeMessageIds(String topic, long messageId) {
        try {
            List<String> registeredSubscribers = this.getRegisteredSubscribersForTopic(topic);
            for (String subscriber : registeredSubscribers) {
                try {
                    this.addMessageIdToSubscriberQueue(subscriber, messageId);
                }
                catch (AMQStoreException e) {
                    log.error((Object)("Error adding message id " + messageId + "To subscriber " + subscriber));
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Error while adding Message Id to Subscriber queue", (Throwable)e);
        }
    }

    public List<MessageTransferMessage> getSubscriberMessages(AMQQueue queue, long lastDeliveredMid) {
        ArrayList<MessageTransferMessage> messages = null;
        List<Long> messageIds = this.getPendingMessageIds(queue.getName(), lastDeliveredMid);
        if (messageIds.size() > 0) {
            messages = new ArrayList<MessageTransferMessage>();
            for (long messageId : messageIds) {
                StorableMessageMetaData messageMetaData = this.getMetaData(messageId);
                StoredCassandraMessage storedCassandraMessage = new StoredCassandraMessage(messageId, messageMetaData, true);
                MessageTransferMessage message = new MessageTransferMessage(storedCassandraMessage, null);
                messages.add(message);
            }
        }
        return messages;
    }

    private void registerTopic(String topic) {
        try {
            CassandraDataAccessHelper.addMappingToRaw(TOPICS_COLUMN_FAMILY, TOPICS_ROW, topic, topic, this.keyspace);
        }
        catch (Exception e) {
            log.error((Object)"Error in registering queue for the topic", (Throwable)e);
        }
    }

    public List<String> getTopics() throws Exception {
        try {
            List<String> topicList = CassandraDataAccessHelper.getRowList(TOPICS_COLUMN_FAMILY, TOPICS_ROW, this.keyspace);
            return topicList;
        }
        catch (Exception e) {
            log.error((Object)"Error in getting the topic list", (Throwable)e);
            throw e;
        }
    }

    public List<String> getUserQueues(String qpidQueueName) throws Exception {
        if (this.keyspace == null) {
            return new ArrayList<String>();
        }
        try {
            List<String> userQueues = CassandraDataAccessHelper.getRowList(GLOBAL_QUEUE_TO_USER_QUEUE_COLUMN_FAMILY, qpidQueueName, this.keyspace);
            return userQueues;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)("Error in getting user queues for qpid queue :" + qpidQueueName), (Throwable)e);
            throw e;
        }
    }

    public List<String> getGlobalQueues() throws Exception {
        if (this.keyspace == null) {
            return new ArrayList<String>();
        }
        try {
            List<String> globalQueues = CassandraDataAccessHelper.getRowList(GLOBAL_QUEUE_LIST_COLUMN_FAMILY, GLOBAL_QUEUE_LIST_ROW, this.keyspace);
            return globalQueues;
        }
        catch (Exception e) {
            log.error((Object)"Error in getting global queues", (Throwable)e);
            throw e;
        }
    }

    private void unRegisterTopic(String topic) throws AMQStoreException {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)(" removing topic : " + topic));
            }
            CassandraDataAccessHelper.deleteStringColumnFromRaw(TOPICS_COLUMN_FAMILY, TOPICS_ROW, topic, this.keyspace);
        }
        catch (Exception e) {
            throw new AMQStoreException("Error in un registering topic", e);
        }
    }

    public void registerSubscriberForTopic(String topic, String queueName) {
        if (this.keyspace == null) {
            return;
        }
        try {
            this.registerTopic(topic);
            CassandraDataAccessHelper.addMappingToRaw(TOPIC_SUBSCRIBERS, topic, queueName, queueName, this.keyspace);
        }
        catch (Exception e) {
            log.error((Object)"Error in registering queue for the topic", (Throwable)e);
        }
    }

    public List<String> getRegisteredSubscribersForTopic(String topic) throws Exception {
        try {
            List<String> queueList = CassandraDataAccessHelper.getRowList(TOPIC_SUBSCRIBERS, topic, this.keyspace);
            return queueList;
        }
        catch (Exception e) {
            log.error((Object)"Error in getting registered subscribers for the topic", (Throwable)e);
            throw e;
        }
    }

    public void unRegisterQueueFromTopic(String topic, String queueName) {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)(" removing queue = " + queueName + " from topic =" + topic));
            }
            CassandraDataAccessHelper.deleteStringColumnFromRaw(TOPIC_SUBSCRIBERS, topic, queueName, this.keyspace);
            if (this.getRegisteredSubscribersForTopic(topic).size() == 0) {
                this.unRegisterTopic(topic);
            }
        }
        catch (Exception e) {
            log.error((Object)"Error in un registering queue from the topic", (Throwable)e);
        }
    }

    private void addMessageIdToSubscriberQueue(String queueName, long messageId) throws AMQStoreException {
        try {
            long columnName = messageId;
            long columnValue = messageId;
            CassandraDataAccessHelper.addLongContentToRow(PUB_SUB_MESSAGE_IDS, queueName, columnName, columnValue, this.keyspace);
        }
        catch (Exception e) {
            throw new AMQStoreException("Error in adding message Id to subscriber queue", e);
        }
    }

    private List<Long> getPendingMessageIds(String queueName, long lastDeliveredMid) {
        ArrayList<Long> queueList = new ArrayList<Long>();
        try {
            SliceQuery sliceQuery = HFactory.createSliceQuery((Keyspace)this.keyspace, (Serializer)stringSerializer, (Serializer)longSerializer, (Serializer)longSerializer);
            sliceQuery.setKey((Object)queueName);
            sliceQuery.setColumnFamily(PUB_SUB_MESSAGE_IDS);
            sliceQuery.setRange((Object)lastDeliveredMid, (Object)Long.MAX_VALUE, false, 1000);
            QueryResult result = sliceQuery.execute();
            ColumnSlice columnSlice = (ColumnSlice)result.get();
            for (HColumn column : columnSlice.getColumns()) {
                queueList.add((Long)column.getValue());
            }
        }
        catch (Exception e) {
            log.error((Object)"Error in retriving message ids of the queue", (Throwable)e);
        }
        return queueList;
    }

    public void removeDeliveredMessageIds(List<Long> messageIdsToBeRemoved, String queueName) throws AMQStoreException {
        try {
            Mutator mutator = HFactory.createMutator((Keyspace)this.keyspace, (Serializer)stringSerializer);
            for (Long mid : messageIdsToBeRemoved) {
                CassandraDataAccessHelper.deleteLongColumnFromRaw(PUB_SUB_MESSAGE_IDS, queueName, mid, (Mutator<String>)mutator, false);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)(" removing mid = " + mid + " from =" + queueName));
            }
            mutator.execute();
        }
        catch (Exception e) {
            throw new AMQStoreException("Error in removing message ids from subscriber queue", e);
        }
    }

    public void synchBindings(VirtualHostConfigSynchronizer vhcs) {
        try {
            Mutator mutator = HFactory.createMutator((Keyspace)this.keyspace, (Serializer)stringSerializer);
            RangeSlicesQuery rangeSliceQuery = HFactory.createRangeSlicesQuery((Keyspace)this.keyspace, (Serializer)stringSerializer, (Serializer)stringSerializer, (Serializer)stringSerializer);
            rangeSliceQuery.setKeys((Object)"", (Object)"");
            rangeSliceQuery.setColumnFamily(BINDING_COLUMN_FAMILY);
            rangeSliceQuery.setRange((Object)"", (Object)"", false, 100);
            QueryResult result = rangeSliceQuery.execute();
            OrderedRows orderedRows = (OrderedRows)result.get();
            List rowArrayList = orderedRows.getList();
            for (Row row : rowArrayList) {
                String exchange = (String)row.getKey();
                ColumnSlice columnSlice = row.getColumnSlice();
                for (HColumn column : columnSlice.getColumns()) {
                    if (!(column instanceof HColumn)) continue;
                    String columnName = (String)column.getName();
                    String value = (String)column.getValue();
                    vhcs.binding(exchange, value, columnName, null);
                }
            }
        }
        catch (NumberFormatException e) {
            log.error((Object)"Error in synchronizing bindings", (Throwable)e);
        }
    }

    public void recoverBindings(ConfigurationRecoveryHandler.BindingRecoveryHandler brh, List<String> exchanges) throws Exception {
        try {
            Mutator mutator = HFactory.createMutator((Keyspace)this.keyspace, (Serializer)stringSerializer);
            RangeSlicesQuery rangeSliceQuery = HFactory.createRangeSlicesQuery((Keyspace)this.keyspace, (Serializer)stringSerializer, (Serializer)stringSerializer, (Serializer)stringSerializer);
            rangeSliceQuery.setKeys((Object)"", (Object)"");
            rangeSliceQuery.setColumnFamily(BINDING_COLUMN_FAMILY);
            rangeSliceQuery.setRange((Object)"", (Object)"", false, 100);
            QueryResult result = rangeSliceQuery.execute();
            OrderedRows orderedRows = (OrderedRows)result.get();
            List rowArrayList = orderedRows.getList();
            for (Row row : rowArrayList) {
                String exchange = (String)row.getKey();
                ColumnSlice columnSlice = row.getColumnSlice();
                for (HColumn column : columnSlice.getColumns()) {
                    if (!(column instanceof HColumn)) continue;
                    String columnName = (String)column.getName();
                    String value = (String)column.getValue();
                    brh.binding(exchange, value, columnName, null);
                }
            }
        }
        catch (NumberFormatException e) {
            log.error((Object)"Number formatting error occured when recovering bindings", (Throwable)e);
        }
    }

    private List<String> getBindings(String routingKey) {
        ArrayList<String> bindings = new ArrayList<String>();
        try {
            Mutator mutator = HFactory.createMutator((Keyspace)this.keyspace, (Serializer)stringSerializer);
            RangeSlicesQuery rangeSlicesQuery = HFactory.createRangeSlicesQuery((Keyspace)this.keyspace, (Serializer)stringSerializer, (Serializer)stringSerializer, (Serializer)stringSerializer);
            rangeSlicesQuery.setKeys((Object)"DirectExchange", (Object)"DirectExchange");
            rangeSlicesQuery.setColumnFamily(BINDING_COLUMN_FAMILY);
            rangeSlicesQuery.setRange((Object)routingKey, (Object)"", false, 10);
            QueryResult result = rangeSlicesQuery.execute();
            OrderedRows columnSlice = (OrderedRows)result.get();
            List rows = columnSlice.getList();
            for (HColumn column : ((Row)columnSlice.getList().get(0)).getColumnSlice().getColumns()) {
                if (!(column instanceof HColumn)) continue;
                String columnName = (String)column.getName();
                String value = (String)column.getValue();
                String stringValue = new String(value);
                bindings.add(stringValue);
            }
        }
        catch (Exception e) {
            log.error((Object)"Error in getting bindings", (Throwable)e);
        }
        return bindings;
    }

    private void recoverMessages(MessageStoreRecoveryHandler recoveryHandler) {
        StorableMessageMetaData metaData = null;
        long maxId = 0L;
        try {
            LongSerializer ls = LongSerializer.get();
            BytesArraySerializer bs = BytesArraySerializer.get();
            SliceQuery sliceQuery = HFactory.createSliceQuery((Keyspace)this.keyspace, (Serializer)stringSerializer, (Serializer)ls, (Serializer)bs);
            sliceQuery.setColumnFamily(QMD_COLUMN_FAMILY);
            sliceQuery.setKey((Object)QMD_ROW_NAME);
            sliceQuery.setRange((Object)Long.parseLong("0"), (Object)Long.MAX_VALUE, false, 10000);
            QueryResult result = sliceQuery.execute();
            ColumnSlice columnSlice = (ColumnSlice)result.get();
            List columnList = columnSlice.getColumns();
            for (HColumn column : columnList) {
                long key = (Long)column.getName();
                if (key > maxId) {
                    maxId = key;
                }
                byte[] dataAsBytes = (byte[])column.getValue();
                ByteBuffer buf = ByteBuffer.wrap(dataAsBytes);
                buf.position(1);
                buf = buf.slice();
                MessageMetaDataType type = MessageMetaDataType.values()[dataAsBytes[0]];
                metaData = type.getFactory().createMetaData(buf);
            }
            this._messageId.set(maxId);
        }
        catch (Exception e) {
            log.error((Object)"Error in recovering bindings", (Throwable)e);
        }
    }

    public AtomicLong currentMessageId() {
        return this._messageId;
    }

    public void synchQueues(VirtualHostConfigSynchronizer vhcs) throws Exception {
        try {
            ColumnSlice<String, String> columnSlice = CassandraDataAccessHelper.getStringTypeColumnsInARow(QUEUE_DETAILS_ROW, QUEUE_DETAILS_COLUMN_FAMILY, this.keyspace, Integer.MAX_VALUE);
            for (HColumn column : columnSlice.getColumns()) {
                if (!(column instanceof HColumn)) continue;
                String columnName = (String)column.getName();
                String value = (String)column.getValue();
                String[] valuesFields = value.split("|");
                String owner = valuesFields[1];
                boolean isExclusive = Boolean.parseBoolean(valuesFields[2]);
                vhcs.queue(columnName, owner, isExclusive, null);
            }
        }
        catch (Exception e) {
            throw new AMQStoreException("Error in queue synchronization", e);
        }
    }

    public void loadQueues(ConfigurationRecoveryHandler.QueueRecoveryHandler qrh) throws Exception {
        try {
            ColumnSlice<String, String> columnSlice = CassandraDataAccessHelper.getStringTypeColumnsInARow(QUEUE_DETAILS_ROW, QUEUE_DETAILS_COLUMN_FAMILY, this.keyspace, Integer.MAX_VALUE);
            for (HColumn column : columnSlice.getColumns()) {
                if (!(column instanceof HColumn)) continue;
                String columnName = (String)column.getName();
                String value = (String)column.getValue();
                String[] valuesFields = value.split("|");
                String owner = valuesFields[1];
                boolean isExclusive = Boolean.parseBoolean(valuesFields[2]);
                qrh.queue(columnName, owner, isExclusive, null);
            }
        }
        catch (Exception e) {
            throw new AMQStoreException("Error in loading queues", e);
        }
    }

    public void addUserQueueToGlobalQueue(String globalQueueName) throws AMQStoreException {
        try {
            ClusterManager clusterManager = ClusterResourceHolder.getInstance().getClusterManager();
            String userQueueName = globalQueueName + "_" + clusterManager.getNodeId();
            Mutator qqMutator = HFactory.createMutator((Keyspace)this.keyspace, (Serializer)stringSerializer);
            CassandraDataAccessHelper.addMappingToRaw(GLOBAL_QUEUE_TO_USER_QUEUE_COLUMN_FAMILY, globalQueueName, userQueueName, userQueueName, (Mutator<String>)qqMutator, false);
            CassandraDataAccessHelper.addMappingToRaw(GLOBAL_QUEUE_LIST_COLUMN_FAMILY, GLOBAL_QUEUE_LIST_ROW, globalQueueName, globalQueueName, (Mutator<String>)qqMutator, true);
        }
        catch (Exception e) {
            throw new AMQStoreException("Error in adding user queue to global queue", e);
        }
    }

    public void removeUserQueueFromQpidQueue(String globalQueueName) {
        try {
            ClusterManager clusterManager = ClusterResourceHolder.getInstance().getClusterManager();
            String userQueueName = globalQueueName + "_" + clusterManager.getNodeId();
            CassandraDataAccessHelper.deleteStringColumnFromRaw(GLOBAL_QUEUE_TO_USER_QUEUE_COLUMN_FAMILY, globalQueueName.trim(), userQueueName, this.keyspace);
        }
        catch (Exception e) {
            log.error((Object)"Error in removing user queue from qpid queue", (Throwable)e);
        }
    }

    @Override
    public void configureMessageStore(String name, MessageStoreRecoveryHandler recoveryHandler, Configuration config, LogSubject logSubject) throws Exception {
        if (!this.configured) {
            this.performCommonConfiguration(config);
            ClusterResourceHolder resourceHolder = ClusterResourceHolder.getInstance();
            CassandraTopicPublisherManager cassandraTopicPublisherManager = resourceHolder.getCassandraTopicPublisherManager();
            if (cassandraTopicPublisherManager == null) {
                cassandraTopicPublisherManager = new CassandraTopicPublisherManager();
                resourceHolder.setCassandraTopicPublisherManager(cassandraTopicPublisherManager);
            }
            cassandraTopicPublisherManager.init();
            cassandraTopicPublisherManager.start();
        }
        this.recoverMessages(recoveryHandler);
    }

    private void performCommonConfiguration(Configuration configuration) throws Exception {
        String userName = (String)configuration.getProperty("username");
        String password = (String)configuration.getProperty("password");
        Object connections = configuration.getProperty("connectionString");
        String connectionString = "";
        if (connections instanceof ArrayList) {
            ArrayList cons = (ArrayList)connections;
            for (String c : cons) {
                connectionString = connectionString + c + ",";
            }
            connectionString = connectionString.substring(0, connectionString.length() - 1);
        } else if (connectionString instanceof String) {
            connectionString = (String)connections;
        }
        String clusterName = (String)configuration.getProperty("cluster");
        String idGeneratorImpl = (String)configuration.getProperty("idGenerator");
        this.cluster = CassandraDataAccessHelper.createCluster(userName, password, clusterName, connectionString);
        this.keyspace = this.createKeySpace();
        if (idGeneratorImpl != null && !"".equals(idGeneratorImpl)) {
            try {
                Class<?> clz = Class.forName(idGeneratorImpl);
                Object o = clz.newInstance();
                this.messageIdGenerator = (MessageIdGenerator)o;
            }
            catch (Exception e) {
                log.error((Object)("Error while loading Message id generator implementation : " + idGeneratorImpl + " adding TimeStamp based implementation as the default"), (Throwable)e);
                this.messageIdGenerator = new TimeStampBasedMessageIdGenerator();
            }
        } else {
            this.messageIdGenerator = new TimeStampBasedMessageIdGenerator();
        }
        this.messageContentRemovalTask = new ContentRemoverTask(ClusterResourceHolder.getInstance().getClusterConfiguration().getContentRemovalTaskInterval());
        this.messageContentRemovalTask.setRunning(true);
        Thread t = new Thread(this.messageContentRemovalTask);
        t.setName(this.messageContentRemovalTask.getClass().getSimpleName() + "-Thread");
        t.start();
        this.pubSubMessageContentDeletionTasks = new ConcurrentHashMap();
        ClusterConfiguration clusterConfiguration = ClusterResourceHolder.getInstance().getClusterConfiguration();
        this.pubSubMessageContentRemoverTask = new PubSubMessageContentRemoverTask(clusterConfiguration.getPubSubMessageRemovalTaskInterval());
        this.pubSubMessageContentRemoverTask.setRunning(true);
        Thread th = new Thread(this.pubSubMessageContentRemoverTask);
        th.start();
        AndesConsistantLevelPolicy consistencyLevel = new AndesConsistantLevelPolicy();
        this.keyspace.setConsistencyLevelPolicy((ConsistencyLevelPolicy)consistencyLevel);
        if (ClusterResourceHolder.getInstance().getSubscriptionCoordinationManager() == null) {
            SubscriptionCoordinationManagerImpl subscriptionCoordinationManager = new SubscriptionCoordinationManagerImpl();
            subscriptionCoordinationManager.init();
            ClusterResourceHolder.getInstance().setSubscriptionCoordinationManager(subscriptionCoordinationManager);
        }
        ClusterManager clusterManager = null;
        clusterManager = clusterConfiguration.isClusteringEnabled() != false ? new ClusterManager(ClusterResourceHolder.getInstance().getCassandraMessageStore(), clusterConfiguration.getZookeeperConnection()) : new ClusterManager(ClusterResourceHolder.getInstance().getCassandraMessageStore());
        ClusterResourceHolder.getInstance().setClusterManager(clusterManager);
        clusterManager.init();
        this.clusterManagementMBean = new ClusterManagementInformationMBean(clusterManager);
        this.clusterManagementMBean.register();
        this.queueManagementMBean = new QueueManagementInformationMBean();
        this.queueManagementMBean.register();
        if (ClusterResourceHolder.getInstance().getClusterConfiguration().isOnceInOrderSupportEnabled()) {
            OnceInOrderEnabledSubscriptionManager subscriptionManager = new OnceInOrderEnabledSubscriptionManager();
            ClusterResourceHolder.getInstance().setSubscriptionManager(subscriptionManager);
            subscriptionManager.init();
        } else {
            DefaultClusteringEnabledSubscriptionManager subscriptionManager = new DefaultClusteringEnabledSubscriptionManager();
            ClusterResourceHolder.getInstance().setSubscriptionManager(subscriptionManager);
            subscriptionManager.init();
        }
        this.configured = true;
    }

    @Override
    public void close() throws Exception {
        List<String> globalQueues = this.getGlobalQueues();
        if (globalQueues != null) {
            for (String globalQueue : globalQueues) {
                this.removeUserQueueFromQpidQueue(globalQueue);
            }
        }
        if (!ClusterResourceHolder.getInstance().getClusterConfiguration().isOnceInOrderSupportEnabled()) {
            DefaultClusteringEnabledSubscriptionManager subscriptionManager = new DefaultClusteringEnabledSubscriptionManager();
            ClusterResourceHolder.getInstance().setSubscriptionManager(subscriptionManager);
            subscriptionManager.stopAllMessageFlushers();
        }
        this.deleteNodeData("" + ClusterResourceHolder.getInstance().getClusterManager().getNodeId());
        if (this.messageContentRemovalTask != null && this.messageContentRemovalTask.isRunning()) {
            this.messageContentRemovalTask.setRunning(false);
        }
        if (this.pubSubMessageContentRemoverTask != null && this.pubSubMessageContentRemoverTask.isRunning()) {
            this.pubSubMessageContentRemoverTask.setRunning(false);
        }
    }

    @Override
    public <T extends StorableMessageMetaData> StoredMessage<T> addMessage(T metaData) {
        long mid = this.messageIdGenerator.getNextId();
        return new StoredCassandraMessage(mid, metaData);
    }

    @Override
    public boolean isPersistent() {
        return false;
    }

    @Override
    public void configureConfigStore(String name, ConfigurationRecoveryHandler recoveryHandler, Configuration config, LogSubject logSubject) throws Exception {
        if (!this.configured) {
            this.performCommonConfiguration(config);
            this.recover(recoveryHandler);
            ClusterResourceHolder resourceHolder = ClusterResourceHolder.getInstance();
            CassandraTopicPublisherManager cassandraTopicPublisherManager = resourceHolder.getCassandraTopicPublisherManager();
            if (cassandraTopicPublisherManager == null) {
                cassandraTopicPublisherManager = new CassandraTopicPublisherManager();
                resourceHolder.setCassandraTopicPublisherManager(cassandraTopicPublisherManager);
            }
            cassandraTopicPublisherManager.init();
            cassandraTopicPublisherManager.start();
        }
    }

    @Override
    public void createExchange(Exchange exchange) throws AMQStoreException {
        try {
            String name = exchange.getName();
            String type = exchange.getTypeShortString().asString();
            Short autoDelete = exchange.isAutoDelete() ? (short)1 : 0;
            String value = name + "|" + type + "|" + autoDelete;
            CassandraDataAccessHelper.addMappingToRaw(EXCHANGE_COLUMN_FAMILY, EXCHANGE_ROW, name, value, this.keyspace);
        }
        catch (Exception e) {
            throw new AMQStoreException("Error in creating exchange " + exchange.getName(), e);
        }
    }

    public List<String> loadExchanges(ConfigurationRecoveryHandler.ExchangeRecoveryHandler erh) throws Exception {
        ArrayList<String> exchangeNames = new ArrayList<String>();
        try {
            ColumnSlice<String, String> columnSlice = CassandraDataAccessHelper.getStringTypeColumnsInARow(EXCHANGE_ROW, EXCHANGE_COLUMN_FAMILY, this.keyspace, Integer.MAX_VALUE);
            for (HColumn column : columnSlice.getColumns()) {
                if (!(column instanceof HColumn)) continue;
                String columnName = (String)column.getName();
                String value = (String)column.getValue();
                String[] valuesFields = value.split("|");
                String type = valuesFields[1];
                short autoDelete = Short.parseShort(valuesFields[2]);
                exchangeNames.add(columnName);
                erh.exchange(columnName, type, autoDelete != 0);
            }
        }
        catch (Exception e) {
            throw new AMQStoreException("Error in loading exchanges", e);
        }
        return exchangeNames;
    }

    public List<String> synchExchanges(VirtualHostConfigSynchronizer vhcs) throws Exception {
        ArrayList<String> exchangeNames = new ArrayList<String>();
        try {
            ColumnSlice<String, String> columnSlice = CassandraDataAccessHelper.getStringTypeColumnsInARow(EXCHANGE_ROW, EXCHANGE_COLUMN_FAMILY, this.keyspace, Integer.MAX_VALUE);
            for (HColumn column : columnSlice.getColumns()) {
                if (!(column instanceof HColumn)) continue;
                String columnName = (String)column.getName();
                String value = (String)column.getValue();
                String[] valuesFields = value.split("|");
                String type = valuesFields[1];
                short autoDelete = Short.parseShort(valuesFields[2]);
                exchangeNames.add(columnName);
                vhcs.exchange(columnName, type, autoDelete != 0);
            }
        }
        catch (Exception e) {
            throw new AMQStoreException("Error in synchronizing exchanges", e);
        }
        return exchangeNames;
    }

    @Override
    public void removeExchange(Exchange exchange) throws AMQStoreException {
        throw new UnsupportedOperationException("removeExchange function is unsupported");
    }

    @Override
    public void bindQueue(Exchange exchange, AMQShortString routingKey, AMQQueue queue, FieldTable args) throws AMQStoreException {
        try {
            this.addBinding(exchange, queue, routingKey.asString());
        }
        catch (CassandraDataAccessException e) {
            throw new AMQStoreException("Error adding Binding details to cassandra store", e);
        }
    }

    @Override
    public void unbindQueue(Exchange exchange, AMQShortString routingKey, AMQQueue queue, FieldTable args) throws AMQStoreException {
        try {
            this.removeBinding(exchange, queue, routingKey.asString());
        }
        catch (CassandraDataAccessException e) {
            throw new AMQStoreException("Error removing binding details from cassandra store", e);
        }
    }

    @Override
    public void createQueue(AMQQueue queue, FieldTable arguments) throws AMQStoreException {
        this.createQueue(queue);
    }

    @Override
    public void createQueue(AMQQueue queue) {
        try {
            String owner = queue.getOwner() == null ? null : queue.getOwner().toString();
            String value = queue.getNameShortString().toString() + "|" + owner + "|" + (queue.isExclusive() ? "true" : "false");
            CassandraDataAccessHelper.addMappingToRaw(QUEUE_DETAILS_COLUMN_FAMILY, QUEUE_DETAILS_ROW, queue.getNameShortString().toString(), value, this.keyspace);
        }
        catch (Exception e) {
            throw new RuntimeException("Error While creating a Queue creating queue", e);
        }
    }

    public void addNodeDetails(String nodeId, String data) {
        try {
            CassandraDataAccessHelper.addMappingToRaw(NODE_DETAIL_COLUMN_FAMILY, NODE_DETAIL_ROW, nodeId, data, this.keyspace);
        }
        catch (CassandraDataAccessException e) {
            throw new RuntimeException("Error writing Node details to cassandra database", e);
        }
    }

    public String getNodeData(String nodeId) {
        try {
            ColumnSlice<String, String> values = CassandraDataAccessHelper.getStringTypeColumnsInARow(NODE_DETAIL_ROW, NODE_DETAIL_COLUMN_FAMILY, this.keyspace, Integer.MAX_VALUE);
            HColumn column = values.getColumnByName((Object)nodeId);
            String columnName = (String)column.getName();
            String value = (String)column.getValue();
            return value;
        }
        catch (CassandraDataAccessException e) {
            throw new RuntimeException("Error accessing Node details to cassandra database");
        }
    }

    public List<String> storedNodeDetails() {
        try {
            ColumnSlice<String, String> values = CassandraDataAccessHelper.getStringTypeColumnsInARow(NODE_DETAIL_ROW, NODE_DETAIL_COLUMN_FAMILY, this.keyspace, Integer.MAX_VALUE);
            List columns = values.getColumns();
            ArrayList<String> nodes = new ArrayList<String>();
            for (HColumn column : columns) {
                nodes.add((String)column.getName());
            }
            return nodes;
        }
        catch (CassandraDataAccessException e) {
            throw new RuntimeException("Error accessing Node details to cassandra database");
        }
    }

    public void deleteNodeData(String nodeId) {
        try {
            CassandraDataAccessHelper.deleteStringColumnFromRaw(NODE_DETAIL_COLUMN_FAMILY, NODE_DETAIL_ROW, nodeId, this.keyspace);
        }
        catch (CassandraDataAccessException e) {
            throw new RuntimeException("Error accessing Node details to cassandra database");
        }
    }

    public void createGlobalQueue(String queueName) throws AMQStoreException {
        try {
            CassandraDataAccessHelper.addMappingToRaw(GLOBAL_QUEUE_LIST_COLUMN_FAMILY, GLOBAL_QUEUE_LIST_ROW, queueName, queueName, this.keyspace);
        }
        catch (CassandraDataAccessException e) {
            throw new AMQStoreException("Error while adding Global Queue to Cassandra message store", e);
        }
    }

    @Override
    public void removeQueue(AMQQueue queue) throws AMQStoreException {
        try {
            String queueName = queue.getNameShortString().toString();
            CassandraDataAccessHelper.deleteStringColumnFromRaw(QUEUE_DETAILS_COLUMN_FAMILY, QUEUE_DETAILS_ROW, queueName, this.keyspace);
        }
        catch (CassandraDataAccessException e) {
            throw new AMQStoreException("Error while deleting queue : " + queue, e);
        }
    }

    public void removeGlobalQueue(String queueName) throws AMQStoreException {
        try {
            List<String> userQueues = this.getUserQueues(queueName);
            for (String userQ : userQueues) {
                CassandraDataAccessHelper.deleteStringColumnFromRaw(GLOBAL_QUEUE_TO_USER_QUEUE_COLUMN_FAMILY, queueName, userQ, this.keyspace);
            }
            CassandraDataAccessHelper.deleteStringColumnFromRaw(GLOBAL_QUEUE_LIST_COLUMN_FAMILY, GLOBAL_QUEUE_LIST_ROW, queueName, this.keyspace);
        }
        catch (Exception e) {
            throw new AMQStoreException("Error while removing Global Queue  : " + queueName, e);
        }
    }

    @Override
    public void updateQueue(AMQQueue queue) throws AMQStoreException {
        try {
            String owner = queue.getOwner() == null ? null : queue.getOwner().toString();
            String value = queue.getNameShortString().toString() + "|" + owner + "|" + (queue.isExclusive() ? "true" : "false");
            CassandraDataAccessHelper.addMappingToRaw(QUEUE_DETAILS_COLUMN_FAMILY, QUEUE_DETAILS_ROW, queue.getNameShortString().toString(), value, this.keyspace);
        }
        catch (CassandraDataAccessException e) {
            throw new AMQStoreException("Error in updating the queue", e);
        }
    }

    @Override
    public void configureTransactionLog(String name, TransactionLogRecoveryHandler recoveryHandler, Configuration storeConfiguration, LogSubject logSubject) throws Exception {
    }

    @Override
    public TransactionLog.Transaction newTransaction() {
        return new CassandraTransaction();
    }

    public boolean isConfigured() {
        return this.configured;
    }

    public void addContentDeletionTask(long messageId) {
        this.contentDeletionTasks.put(System.currentTimeMillis(), messageId);
    }

    private class PubSubMessageContentRemoverTask
    implements Runnable {
        private int waitInterval = 5000;
        private boolean running = true;

        public PubSubMessageContentRemoverTask(int waitInterval) {
            this.waitInterval = waitInterval;
        }

        public void run() {
            block4: while (this.running) {
                block5: while (true) {
                    try {
                        while (!CassandraMessageStore.this.pubSubMessageContentDeletionTasks.isEmpty()) {
                            Set messageIds = CassandraMessageStore.this.pubSubMessageContentDeletionTasks.keySet();
                            Iterator i$ = messageIds.iterator();
                            while (i$.hasNext()) {
                                long messageID = (Long)i$.next();
                                if (!CassandraMessageStore.this.isReadyAndRemovedMessageContent(messageID)) continue;
                                CassandraMessageStore.this.pubSubMessageContentDeletionTasks.remove(messageID);
                            }
                            try {
                                Thread.sleep(this.waitInterval);
                                continue block5;
                            }
                            catch (InterruptedException e) {
                                log.error((Object)e);
                            }
                        }
                        continue block4;
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        continue block4;
                    }
                }
            }
        }

        public boolean isRunning() {
            return this.running;
        }

        public void setRunning(boolean running) {
            this.running = running;
        }
    }

    private class ContentRemoverTask
    implements Runnable {
        private int waitInterval = 5000;
        private long timeOutPerMessage = 60000L;
        private boolean running = true;

        public ContentRemoverTask(int waitInterval) {
            this.waitInterval = waitInterval;
        }

        public void run() {
            while (this.running) {
                try {
                    if (!CassandraMessageStore.this.contentDeletionTasks.isEmpty()) {
                        long currentTime = System.currentTimeMillis();
                        SortedMap timedOutList = CassandraMessageStore.this.contentDeletionTasks.headMap(currentTime - this.timeOutPerMessage);
                        for (Long key : timedOutList.keySet()) {
                            CassandraMessageStore.this.removeMessageContent("" + timedOutList.get(key));
                        }
                        for (Long key : timedOutList.keySet()) {
                            CassandraMessageStore.this.contentDeletionTasks.remove(key);
                        }
                    }
                    try {
                        Thread.sleep(this.waitInterval);
                    }
                    catch (InterruptedException e) {
                        log.error((Object)"Error while Executing content removal Task", (Throwable)e);
                    }
                }
                catch (Throwable e) {
                    log.error((Object)"Error while Executing content removal Task", e);
                }
            }
        }

        public boolean isRunning() {
            return this.running;
        }

        public void setRunning(boolean running) {
            this.running = running;
        }
    }

    private class CassandraTransaction
    implements TransactionLog.Transaction {
        private CassandraTransaction() {
        }

        public void enqueueMessage(TransactionLogResource queue, Long messageId) throws AMQStoreException {
            try {
                Mutator mutator = HFactory.createMutator((Keyspace)CassandraMessageStore.this.keyspace, (Serializer)stringSerializer);
                String name = queue.getResourceName();
                LongSerializer ls = LongSerializer.get();
                mutator.addInsertion((Object)CassandraMessageStore.QUEUE_ENTRY_ROW, CassandraMessageStore.QUEUE_ENTRY_COLUMN_FAMILY, HFactory.createColumn((Object)name, (Object)messageId, (Serializer)stringSerializer, (Serializer)ls));
                mutator.execute();
            }
            catch (Exception e) {
                log.error((Object)"Error adding Queue Entry ", (Throwable)e);
                throw new AMQStoreException("Error adding Queue Entry " + queue.getResourceName(), e);
            }
        }

        public void dequeueMessage(TransactionLogResource queue, Long messageId) throws AMQStoreException {
            try {
                String name = queue.getResourceName();
                CassandraDataAccessHelper.deleteStringColumnFromRaw(CassandraMessageStore.QUEUE_ENTRY_COLUMN_FAMILY, CassandraMessageStore.QUEUE_DETAILS_ROW, name, CassandraMessageStore.this.keyspace);
            }
            catch (Exception e) {
                log.error((Object)"Error deleting Queue Entry", (Throwable)e);
                throw new AMQStoreException("Error deleting Queue Entry :" + queue.getResourceName(), e);
            }
        }

        public void commitTran() throws AMQStoreException {
        }

        public TransactionLog.StoreFuture commitTranAsync() throws AMQStoreException {
            return new TransactionLog.StoreFuture(){

                public boolean isComplete() {
                    return true;
                }

                public void waitForCompletion() {
                }
            };
        }

        public void abortTran() throws AMQStoreException {
        }
    }

    private class StoredCassandraMessage
    implements StoredMessage {
        private final long _messageId;
        private volatile SoftReference<StorableMessageMetaData> _metaDataRef;

        private StoredCassandraMessage(long messageId, StorableMessageMetaData metaData) {
            this._messageId = messageId;
            this._metaDataRef = new SoftReference<StorableMessageMetaData>(metaData);
            CassandraMessageStore.this.storeMetaData(this._messageId, metaData);
        }

        private StoredCassandraMessage(long messageId, StorableMessageMetaData metaData, boolean isTopics) {
            this._messageId = messageId;
            this._metaDataRef = new SoftReference<StorableMessageMetaData>(metaData);
        }

        public StorableMessageMetaData getMetaData() {
            StorableMessageMetaData metaData = this._metaDataRef.get();
            if (metaData == null) {
                metaData = CassandraMessageStore.this.getMetaData(this._messageId);
                this._metaDataRef = new SoftReference<StorableMessageMetaData>(metaData);
            }
            return metaData;
        }

        public long getMessageNumber() {
            return this._messageId;
        }

        public void addContent(int offsetInMessage, ByteBuffer src) {
            try {
                CassandraMessageStore.this.addMessageContent(this._messageId + "", offsetInMessage, src);
            }
            catch (AMQStoreException e) {
                log.error((Object)"Error while adding Message Content to Store", (Throwable)e);
            }
        }

        public int getContent(int offsetInMessage, ByteBuffer dst) {
            int c = CassandraMessageStore.this.getContent(this._messageId + "", offsetInMessage, dst);
            return c;
        }

        public TransactionLog.StoreFuture flushToStore() {
            return MessageStore.IMMEDIATE_FUTURE;
        }

        public void remove() {
        }
    }
}

