/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.security.auth.database;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.AccountNotFoundException;
import org.wso2.andes.server.security.auth.database.PrincipalDatabase;
import org.wso2.andes.server.security.auth.sasl.AuthenticationProviderInitialiser;
import org.wso2.andes.server.security.auth.sasl.UsernamePrincipal;
import org.wso2.andes.server.security.auth.sasl.crammd5.CRAMMD5Initialiser;
import org.wso2.andes.server.security.auth.sasl.plain.PlainInitialiser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesPrincipalDatabase
implements PrincipalDatabase {
    private Properties _users;
    private Map<String, AuthenticationProviderInitialiser> _saslServers;

    public PropertiesPrincipalDatabase(Properties users) {
        this._users = users;
        this._saslServers = new HashMap<String, AuthenticationProviderInitialiser>();
        PlainInitialiser cram = new PlainInitialiser();
        cram.initialise(this);
        CRAMMD5Initialiser plain = new CRAMMD5Initialiser();
        plain.initialise(this, CRAMMD5Initialiser.HashDirection.INCOMMING);
        this._saslServers.put(plain.getMechanismName(), cram);
        this._saslServers.put(cram.getMechanismName(), plain);
    }

    @Override
    public void setPassword(Principal principal, PasswordCallback callback) throws IOException, AccountNotFoundException {
        if (principal == null) {
            throw new IllegalArgumentException("principal must not be null");
        }
        String pwd = this._users.getProperty(principal.getName());
        if (pwd == null) {
            throw new AccountNotFoundException("No account found for principal " + principal);
        }
        callback.setPassword(pwd.toCharArray());
    }

    @Override
    public boolean verifyPassword(String principal, char[] password) throws AccountNotFoundException {
        char[] pwd = this._users.getProperty(principal).toCharArray();
        return this.compareCharArray(pwd, password);
    }

    @Override
    public boolean updatePassword(Principal principal, char[] password) throws AccountNotFoundException {
        return false;
    }

    @Override
    public boolean createPrincipal(Principal principal, char[] password) {
        return false;
    }

    @Override
    public boolean deletePrincipal(Principal principal) throws AccountNotFoundException {
        return false;
    }

    private boolean compareCharArray(char[] a, char[] b) {
        boolean equal = false;
        if (a.length == b.length) {
            equal = true;
            for (int index = 0; equal && index < a.length; ++index) {
                equal = a[index] == b[index];
            }
        }
        return equal;
    }

    private char[] convertPassword(String password) throws UnsupportedEncodingException {
        byte[] passwdBytes = password.getBytes("utf-8");
        char[] passwd = new char[passwdBytes.length];
        int index = 0;
        for (byte b : passwdBytes) {
            passwd[index++] = (char)b;
        }
        return passwd;
    }

    @Override
    public Map<String, AuthenticationProviderInitialiser> getMechanisms() {
        return this._saslServers;
    }

    @Override
    public List<Principal> getUsers() {
        return new LinkedList<Principal>();
    }

    @Override
    public Principal getUser(String username) {
        if (this._users.getProperty(username) != null) {
            return new UsernamePrincipal(username);
        }
        return null;
    }

    @Override
    public void reload() throws IOException {
    }
}

