/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.protocol;

import java.net.SocketAddress;
import java.util.UUID;
import org.wso2.andes.protocol.ProtocolEngine;
import org.wso2.andes.server.configuration.ConfigStore;
import org.wso2.andes.server.configuration.ConfiguredObject;
import org.wso2.andes.server.configuration.ConnectionConfig;
import org.wso2.andes.server.configuration.ConnectionConfigType;
import org.wso2.andes.server.configuration.VirtualHostConfig;
import org.wso2.andes.server.logging.messages.ConnectionMessages;
import org.wso2.andes.server.registry.IApplicationRegistry;
import org.wso2.andes.server.transport.ServerConnection;
import org.wso2.andes.transport.network.Assembler;
import org.wso2.andes.transport.network.Disassembler;
import org.wso2.andes.transport.network.InputHandler;
import org.wso2.andes.transport.network.NetworkConnection;

public class ProtocolEngine_0_10
extends InputHandler
implements ProtocolEngine,
ConnectionConfig {
    public static final int MAX_FRAME_SIZE = 65535;
    private NetworkConnection _network;
    private long _readBytes;
    private long _writtenBytes;
    private ServerConnection _connection;
    private final UUID _id;
    private final IApplicationRegistry _appRegistry;
    private long _createTime = System.currentTimeMillis();

    public ProtocolEngine_0_10(ServerConnection conn, NetworkConnection network, IApplicationRegistry appRegistry) {
        super(new Assembler(conn));
        this._connection = conn;
        this._connection.setConnectionConfig(this);
        this._network = network;
        this._id = appRegistry.getConfigStore().createId();
        this._appRegistry = appRegistry;
        this._connection.setSender(new Disassembler(this._network.getSender(), 65535));
        this._connection.onOpen(new Runnable(){

            public void run() {
                ProtocolEngine_0_10.this.getConfigStore().addConfiguredObject(ProtocolEngine_0_10.this);
            }
        });
        this._connection.getLogActor().message(ConnectionMessages.OPEN(null, null, false, false));
        this._connection.getLogActor().message(ConnectionMessages.OPEN(null, "0-10", false, true));
    }

    public SocketAddress getRemoteAddress() {
        return this._network.getRemoteAddress();
    }

    public SocketAddress getLocalAddress() {
        return this._network.getLocalAddress();
    }

    public long getReadBytes() {
        return this._readBytes;
    }

    public long getWrittenBytes() {
        return this._writtenBytes;
    }

    public void writerIdle() {
    }

    public void readerIdle() {
    }

    public VirtualHostConfig getVirtualHost() {
        return this._connection.getVirtualHost();
    }

    public String getAddress() {
        return this.getRemoteAddress().toString();
    }

    public Boolean isIncoming() {
        return true;
    }

    public Boolean isSystemConnection() {
        return false;
    }

    public Boolean isFederationLink() {
        return false;
    }

    public String getAuthId() {
        return this._connection.getAuthorizedPrincipal() == null ? null : this._connection.getAuthorizedPrincipal().getName();
    }

    public String getRemoteProcessName() {
        return null;
    }

    public Integer getRemotePID() {
        return null;
    }

    public Integer getRemoteParentPID() {
        return null;
    }

    public ConfigStore getConfigStore() {
        return this._appRegistry.getConfigStore();
    }

    public UUID getId() {
        return this._id;
    }

    public ConnectionConfigType getConfigType() {
        return ConnectionConfigType.getInstance();
    }

    public ConfiguredObject getParent() {
        return this.getVirtualHost();
    }

    public boolean isDurable() {
        return false;
    }

    public void closed() {
        super.closed();
        this.getConfigStore().removeConfiguredObject(this);
    }

    public long getCreateTime() {
        return this._createTime;
    }

    public Boolean isShadow() {
        return false;
    }

    public void mgmtClose() {
        this._connection.mgmtClose();
    }
}

