/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.protocol;

import java.net.SocketAddress;
import java.util.List;
import javax.security.auth.Subject;
import javax.security.sasl.SaslServer;
import org.wso2.andes.AMQConnectionException;
import org.wso2.andes.AMQException;
import org.wso2.andes.common.ClientProperties;
import org.wso2.andes.framing.AMQDataBlock;
import org.wso2.andes.framing.AMQShortString;
import org.wso2.andes.framing.FieldTable;
import org.wso2.andes.framing.MethodDispatcher;
import org.wso2.andes.framing.MethodRegistry;
import org.wso2.andes.protocol.AMQVersionAwareProtocolSession;
import org.wso2.andes.server.AMQChannel;
import org.wso2.andes.server.logging.LogActor;
import org.wso2.andes.server.output.ProtocolOutputConverter;
import org.wso2.andes.server.protocol.AMQConnectionModel;
import org.wso2.andes.server.security.AuthorizationHolder;
import org.wso2.andes.server.virtualhost.VirtualHost;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface AMQProtocolSession
extends AMQVersionAwareProtocolSession,
AuthorizationHolder,
AMQConnectionModel {
    public long getSessionID();

    public LogActor getLogActor();

    public void setMaxFrameSize(long var1);

    public long getMaxFrameSize();

    public boolean isClosing();

    public void dataBlockReceived(AMQDataBlock var1) throws Exception;

    public AMQShortString getContextKey();

    public void setContextKey(AMQShortString var1);

    public AMQChannel getChannel(int var1);

    public void addChannel(AMQChannel var1) throws AMQException;

    public void closeChannel(int var1) throws AMQException;

    public void closeChannelOk(int var1);

    public boolean channelAwaitingClosure(int var1);

    public void removeChannel(int var1);

    public void initHeartbeats(int var1);

    public void closeSession() throws AMQException;

    public void closeConnection(int var1, AMQConnectionException var2, boolean var3) throws AMQException;

    public Object getKey();

    public String getLocalFQDN();

    public SaslServer getSaslServer();

    public void setSaslServer(SaslServer var1);

    public FieldTable getClientProperties();

    public void setClientProperties(FieldTable var1);

    public Object getClientIdentifier();

    public VirtualHost getVirtualHost();

    public void setVirtualHost(VirtualHost var1) throws AMQException;

    public void addSessionCloseTask(Task var1);

    public void removeSessionCloseTask(Task var1);

    public ProtocolOutputConverter getProtocolOutputConverter();

    public void setAuthorizedSubject(Subject var1);

    public SocketAddress getRemoteAddress();

    @Override
    public MethodRegistry getMethodRegistry();

    public MethodDispatcher getMethodDispatcher();

    public ProtocolSessionIdentifier getSessionIdentifier();

    public String getClientVersion();

    public long getLastIoTime();

    public long getWrittenBytes();

    public Long getMaximumNumberOfChannels();

    public void setMaximumNumberOfChannels(Long var1);

    public void commitTransactions(AMQChannel var1) throws AMQException;

    public void rollbackTransactions(AMQChannel var1) throws AMQException;

    public List<AMQChannel> getChannels();

    public void mgmtCloseChannel(int var1);

    public static interface Task {
        public void doTask(AMQProtocolSession var1) throws AMQException;
    }

    public static final class ProtocolSessionIdentifier {
        private final Object _sessionIdentifier;
        private final Object _sessionInstance;

        ProtocolSessionIdentifier(AMQProtocolSession session) {
            this._sessionIdentifier = session.getClientIdentifier();
            this._sessionInstance = session.getClientProperties() == null ? null : session.getClientProperties().getObject(ClientProperties.instance.toAMQShortString());
        }

        public Object getSessionIdentifier() {
            return this._sessionIdentifier;
        }

        public Object getSessionInstance() {
            return this._sessionInstance;
        }
    }
}

