/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.handler;

import org.wso2.andes.AMQException;
import org.wso2.andes.framing.ExchangeDeleteBody;
import org.wso2.andes.framing.ExchangeDeleteOkBody;
import org.wso2.andes.protocol.AMQConstant;
import org.wso2.andes.server.exchange.ExchangeInUseException;
import org.wso2.andes.server.exchange.ExchangeRegistry;
import org.wso2.andes.server.protocol.AMQProtocolSession;
import org.wso2.andes.server.state.AMQStateManager;
import org.wso2.andes.server.state.StateAwareMethodListener;
import org.wso2.andes.server.virtualhost.VirtualHost;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExchangeDeleteHandler
implements StateAwareMethodListener<ExchangeDeleteBody> {
    private static final ExchangeDeleteHandler _instance = new ExchangeDeleteHandler();

    public static ExchangeDeleteHandler getInstance() {
        return _instance;
    }

    private ExchangeDeleteHandler() {
    }

    @Override
    public void methodReceived(AMQStateManager stateManager, ExchangeDeleteBody body, int channelId) throws AMQException {
        AMQProtocolSession session = stateManager.getProtocolSession();
        VirtualHost virtualHost = session.getVirtualHost();
        ExchangeRegistry exchangeRegistry = virtualHost.getExchangeRegistry();
        try {
            if (exchangeRegistry.getExchange(body.getExchange()) == null) {
                throw body.getChannelException(AMQConstant.NOT_FOUND, "No such exchange: " + body.getExchange());
            }
            exchangeRegistry.unregisterExchange(body.getExchange(), body.getIfUnused());
            ExchangeDeleteOkBody responseBody = session.getMethodRegistry().createExchangeDeleteOkBody();
            session.writeFrame(responseBody.generateFrame(channelId));
        }
        catch (ExchangeInUseException e) {
            throw body.getChannelException(AMQConstant.IN_USE, "Exchange in use");
        }
    }
}

