/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.handler;

import org.apache.log4j.Logger;
import org.wso2.andes.AMQException;
import org.wso2.andes.framing.ConnectionCloseBody;
import org.wso2.andes.framing.ConnectionCloseOkBody;
import org.wso2.andes.framing.MethodRegistry;
import org.wso2.andes.server.protocol.AMQProtocolSession;
import org.wso2.andes.server.state.AMQStateManager;
import org.wso2.andes.server.state.StateAwareMethodListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionCloseMethodHandler
implements StateAwareMethodListener<ConnectionCloseBody> {
    private static final Logger _logger = Logger.getLogger(ConnectionCloseMethodHandler.class);
    private static ConnectionCloseMethodHandler _instance = new ConnectionCloseMethodHandler();

    public static ConnectionCloseMethodHandler getInstance() {
        return _instance;
    }

    private ConnectionCloseMethodHandler() {
    }

    @Override
    public void methodReceived(AMQStateManager stateManager, ConnectionCloseBody body, int channelId) throws AMQException {
        AMQProtocolSession session = stateManager.getProtocolSession();
        if (_logger.isInfoEnabled()) {
            _logger.info((Object)("ConnectionClose received with reply code/reply text " + body.getReplyCode() + "/" + body.getReplyText() + " for " + session));
        }
        try {
            session.closeSession();
        }
        catch (Exception e) {
            _logger.error((Object)("Error closing protocol session: " + e), (Throwable)e);
        }
        MethodRegistry methodRegistry = session.getMethodRegistry();
        ConnectionCloseOkBody responseBody = methodRegistry.createConnectionCloseOkBody();
        session.writeFrame(responseBody.generateFrame(channelId));
    }
}

