/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.handler;

import org.apache.log4j.Logger;
import org.wso2.andes.AMQException;
import org.wso2.andes.framing.BasicRecoverBody;
import org.wso2.andes.framing.BasicRecoverOkBody;
import org.wso2.andes.framing.ProtocolVersion;
import org.wso2.andes.framing.amqp_8_0.MethodRegistry_8_0;
import org.wso2.andes.server.AMQChannel;
import org.wso2.andes.server.protocol.AMQProtocolSession;
import org.wso2.andes.server.state.AMQStateManager;
import org.wso2.andes.server.state.StateAwareMethodListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicRecoverMethodHandler
implements StateAwareMethodListener<BasicRecoverBody> {
    private static final Logger _logger = Logger.getLogger(BasicRecoverMethodHandler.class);
    private static final BasicRecoverMethodHandler _instance = new BasicRecoverMethodHandler();

    public static BasicRecoverMethodHandler getInstance() {
        return _instance;
    }

    @Override
    public void methodReceived(AMQStateManager stateManager, BasicRecoverBody body, int channelId) throws AMQException {
        AMQProtocolSession session = stateManager.getProtocolSession();
        _logger.debug((Object)("Recover received on protocol session " + session + " and channel " + channelId));
        AMQChannel channel = session.getChannel(channelId);
        if (channel == null) {
            throw body.getChannelNotFoundException(channelId);
        }
        channel.resend(body.getRequeue());
        if (session.getProtocolVersion().equals(ProtocolVersion.v8_0)) {
            MethodRegistry_8_0 methodRegistry = (MethodRegistry_8_0)session.getMethodRegistry();
            BasicRecoverOkBody recoverOk = methodRegistry.createBasicRecoverOkBody();
            session.writeFrame(recoverOk.generateFrame(channelId));
        }
    }
}

