/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.exchange;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.JMException;
import org.apache.log4j.Logger;
import org.wso2.andes.AMQException;
import org.wso2.andes.framing.AMQShortString;
import org.wso2.andes.server.ClusterResourceHolder;
import org.wso2.andes.server.binding.Binding;
import org.wso2.andes.server.cassandra.CassandraQueueMessage;
import org.wso2.andes.server.cluster.ClusterManager;
import org.wso2.andes.server.configuration.ConfigStore;
import org.wso2.andes.server.configuration.ConfiguredObject;
import org.wso2.andes.server.configuration.ExchangeConfigType;
import org.wso2.andes.server.exchange.AbstractExchangeMBean;
import org.wso2.andes.server.exchange.DirectExchange;
import org.wso2.andes.server.exchange.Exchange;
import org.wso2.andes.server.exchange.ExchangeReferrer;
import org.wso2.andes.server.exchange.ExchangeType;
import org.wso2.andes.server.logging.LogSubject;
import org.wso2.andes.server.logging.actors.CurrentActor;
import org.wso2.andes.server.logging.messages.ExchangeMessages;
import org.wso2.andes.server.logging.subjects.ExchangeLogSubject;
import org.wso2.andes.server.management.Managable;
import org.wso2.andes.server.management.ManagedObject;
import org.wso2.andes.server.message.InboundMessage;
import org.wso2.andes.server.queue.AMQQueue;
import org.wso2.andes.server.queue.BaseQueue;
import org.wso2.andes.server.queue.QueueRegistry;
import org.wso2.andes.server.store.CassandraMessageStore;
import org.wso2.andes.server.virtualhost.VirtualHost;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractExchange
implements Exchange,
Managable {
    private AMQShortString _name;
    private final AtomicBoolean _closed = new AtomicBoolean();
    private Exchange _alternateExchange;
    protected boolean _durable;
    protected int _ticket;
    private VirtualHost _virtualHost;
    private final List<Exchange.Task> _closeTaskList = new CopyOnWriteArrayList<Exchange.Task>();
    protected AbstractExchangeMBean _exchangeMbean;
    protected boolean _autoDelete;
    private LogSubject _logSubject;
    private Map<ExchangeReferrer, Object> _referrers = new ConcurrentHashMap<ExchangeReferrer, Object>();
    private final CopyOnWriteArrayList<Binding> _bindings = new CopyOnWriteArrayList();
    private final ExchangeType<? extends Exchange> _type;
    private UUID _id;
    private final AtomicInteger _bindingCountHigh = new AtomicInteger();
    private final AtomicLong _receivedMessageCount = new AtomicLong();
    private final AtomicLong _receivedMessageSize = new AtomicLong();
    private final AtomicLong _routedMessageCount = new AtomicLong();
    private final AtomicLong _routedMessageSize = new AtomicLong();
    private final CopyOnWriteArrayList<Exchange.BindingListener> _listeners = new CopyOnWriteArrayList();
    private long _createTime = System.currentTimeMillis();

    public AbstractExchange(ExchangeType<? extends Exchange> type) {
        this._type = type;
    }

    @Override
    public AMQShortString getNameShortString() {
        return this._name;
    }

    @Override
    public final AMQShortString getTypeShortString() {
        return this._type.getName();
    }

    protected abstract AbstractExchangeMBean createMBean() throws JMException;

    @Override
    public void initialise(VirtualHost host, AMQShortString name, boolean durable, int ticket, boolean autoDelete) throws AMQException {
        this._virtualHost = host;
        this._name = name;
        this._durable = durable;
        this._autoDelete = autoDelete;
        this._ticket = ticket;
        this._id = this.getConfigStore().createId();
        this.getConfigStore().addConfiguredObject(this);
        try {
            this._exchangeMbean = this.createMBean();
            this._exchangeMbean.register();
        }
        catch (JMException e) {
            this.getLogger().error((Object)e);
        }
        this._logSubject = new ExchangeLogSubject(this, this.getVirtualHost());
        CurrentActor.get().message(ExchangeMessages.CREATED(String.valueOf(this.getTypeShortString()), String.valueOf(name), durable));
    }

    public ConfigStore getConfigStore() {
        return this.getVirtualHost().getConfigStore();
    }

    public abstract Logger getLogger();

    @Override
    public boolean isDurable() {
        return this._durable;
    }

    @Override
    public boolean isAutoDelete() {
        return this._autoDelete;
    }

    @Override
    public int getTicket() {
        return this._ticket;
    }

    @Override
    public void close() throws AMQException {
        if (this._closed.compareAndSet(false, true)) {
            if (this._exchangeMbean != null) {
                this._exchangeMbean.unregister();
            }
            this.getConfigStore().removeConfiguredObject(this);
            if (this._alternateExchange != null) {
                this._alternateExchange.removeReference(this);
            }
            CurrentActor.get().message(this._logSubject, ExchangeMessages.DELETED());
            for (Exchange.Task task : this._closeTaskList) {
                task.onClose(this);
            }
            this._closeTaskList.clear();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getNameShortString() + "]";
    }

    @Override
    public ManagedObject getManagedObject() {
        return this._exchangeMbean;
    }

    @Override
    public VirtualHost getVirtualHost() {
        return this._virtualHost;
    }

    public QueueRegistry getQueueRegistry() {
        return this.getVirtualHost().getQueueRegistry();
    }

    public boolean isBound(String bindingKey, Map<String, Object> arguments, AMQQueue queue) {
        return this.isBound(new AMQShortString(bindingKey), queue);
    }

    @Override
    public boolean isBound(String bindingKey, AMQQueue queue) {
        return this.isBound(new AMQShortString(bindingKey), queue);
    }

    @Override
    public boolean isBound(String bindingKey) {
        return this.isBound(new AMQShortString(bindingKey));
    }

    @Override
    public Exchange getAlternateExchange() {
        return this._alternateExchange;
    }

    @Override
    public void setAlternateExchange(Exchange exchange) {
        if (this._alternateExchange != null) {
            this._alternateExchange.removeReference(this);
        }
        if (exchange != null) {
            exchange.addReference(this);
        }
        this._alternateExchange = exchange;
    }

    @Override
    public void removeReference(ExchangeReferrer exchange) {
        this._referrers.remove(exchange);
    }

    @Override
    public void addReference(ExchangeReferrer exchange) {
        this._referrers.put(exchange, Boolean.TRUE);
    }

    @Override
    public boolean hasReferrers() {
        return !this._referrers.isEmpty();
    }

    @Override
    public void addCloseTask(Exchange.Task task) {
        this._closeTaskList.add(task);
    }

    @Override
    public void removeCloseTask(Exchange.Task task) {
        this._closeTaskList.remove(task);
    }

    @Override
    public final void addBinding(Binding binding) {
        int maxBindingsSize;
        this._bindings.add(binding);
        int bindingCountSize = this._bindings.size();
        while ((maxBindingsSize = this._bindingCountHigh.get()) < bindingCountSize) {
            this._bindingCountHigh.compareAndSet(maxBindingsSize, bindingCountSize);
        }
        for (Exchange.BindingListener listener : this._listeners) {
            listener.bindingAdded(this, binding);
        }
        if (this instanceof DirectExchange) {
            CassandraMessageStore cassandraMessageStore = ClusterResourceHolder.getInstance().getCassandraMessageStore();
            ClusterManager clusterManager = ClusterResourceHolder.getInstance().getClusterManager();
            try {
                cassandraMessageStore.createGlobalQueue(binding.getQueue().getResourceName());
                clusterManager.handleQueueAddition(binding.getQueue().getResourceName());
            }
            catch (Exception e) {
                throw new RuntimeException("Error while adding a queue to direct exchange ", e);
            }
        }
        this.onBind(binding);
    }

    @Override
    public long getBindingCountHigh() {
        return this._bindingCountHigh.get();
    }

    @Override
    public final void removeBinding(Binding binding) {
        this.onUnbind(binding);
        for (Exchange.BindingListener listener : this._listeners) {
            listener.bindingRemoved(this, binding);
        }
        this._bindings.remove(binding);
        if (this instanceof DirectExchange) {
            List<String> userQueues;
            final CassandraMessageStore cassandraMessageStore = ClusterResourceHolder.getInstance().getCassandraMessageStore();
            ClusterManager clusterManager = ClusterResourceHolder.getInstance().getClusterManager();
            final String queueName = binding.getQueue().getResourceName();
            try {
                userQueues = cassandraMessageStore.getUserQueues(queueName);
                cassandraMessageStore.removeGlobalQueue(queueName);
                clusterManager.handleQueueRemoval(queueName);
            }
            catch (Exception e) {
                throw new RuntimeException("Error while removing queue from direct exchange", e);
            }
            Runnable deleteTask = new Runnable(){

                public void run() {
                    int msgCount = 50;
                    try {
                        while (msgCount <= 0) {
                            Queue<CassandraQueueMessage> msgs = cassandraMessageStore.getMessagesFromGlobalQueue(queueName, msgCount);
                            msgCount = msgs.size();
                            cassandraMessageStore.removeMessageBatchFromGlobalQueue((List)((Object)msgs), queueName);
                            for (CassandraQueueMessage msg : msgs) {
                                cassandraMessageStore.addContentDeletionTask(msg.getMessageId());
                            }
                        }
                        for (String userQ : userQueues) {
                            int count = 50;
                            while (count <= 0) {
                                List<CassandraQueueMessage> mlist = cassandraMessageStore.getMessagesFromUserQueue(userQ, queueName, msgCount);
                                count = mlist.size();
                                cassandraMessageStore.removeMessageBatchFromUserQueue(userQ, mlist);
                                for (CassandraQueueMessage msg : mlist) {
                                    cassandraMessageStore.addContentDeletionTask(msg.getMessageId());
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };
            Thread t = new Thread(deleteTask);
            t.setName("QueueDelete-worker");
            t.start();
        }
    }

    @Override
    public final Collection<Binding> getBindings() {
        return Collections.unmodifiableList(this._bindings);
    }

    protected abstract void onBind(Binding var1);

    protected abstract void onUnbind(Binding var1);

    @Override
    public String getName() {
        return this._name.toString();
    }

    @Override
    public ExchangeType getType() {
        return this._type;
    }

    @Override
    public Map<String, Object> getArguments() {
        return Collections.EMPTY_MAP;
    }

    @Override
    public UUID getId() {
        return this._id;
    }

    @Override
    public ExchangeConfigType getConfigType() {
        return ExchangeConfigType.getInstance();
    }

    @Override
    public ConfiguredObject getParent() {
        return this._virtualHost;
    }

    @Override
    public long getBindingCount() {
        return this.getBindings().size();
    }

    @Override
    public final ArrayList<? extends BaseQueue> route(InboundMessage message) {
        this._receivedMessageCount.incrementAndGet();
        this._receivedMessageSize.addAndGet(message.getSize());
        ArrayList<? extends BaseQueue> queues = this.doRoute(message);
        if (queues != null && !queues.isEmpty()) {
            this._routedMessageCount.incrementAndGet();
            this._routedMessageSize.addAndGet(message.getSize());
        }
        return queues;
    }

    protected abstract ArrayList<? extends BaseQueue> doRoute(InboundMessage var1);

    @Override
    public long getMsgReceives() {
        return this._receivedMessageCount.get();
    }

    @Override
    public long getMsgRoutes() {
        return this._routedMessageCount.get();
    }

    @Override
    public long getByteReceives() {
        return this._receivedMessageSize.get();
    }

    @Override
    public long getByteRoutes() {
        return this._routedMessageSize.get();
    }

    @Override
    public long getCreateTime() {
        return this._createTime;
    }

    @Override
    public void addBindingListener(Exchange.BindingListener listener) {
        this._listeners.add(listener);
    }

    @Override
    public void removeBindingListener(Exchange.BindingListener listener) {
        this._listeners.remove(listener);
    }
}

