/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.configuration;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.wso2.andes.server.configuration.BrokerConfig;
import org.wso2.andes.server.configuration.ConfigStore;
import org.wso2.andes.server.configuration.ConfiguredObject;
import org.wso2.andes.server.configuration.SystemConfig;
import org.wso2.andes.server.configuration.SystemConfigType;

public class SystemConfigImpl
implements SystemConfig {
    private static final String OS_NAME = System.getProperty("os.name");
    private static final String OS_ARCH = System.getProperty("os.arch");
    private static final String OS_VERSION = System.getProperty("os.version");
    private final UUID _id;
    private String _name;
    private final String _host;
    private final Map<UUID, BrokerConfig> _brokers = new ConcurrentHashMap<UUID, BrokerConfig>();
    private final long _createTime = System.currentTimeMillis();
    private final ConfigStore _store;

    public SystemConfigImpl(ConfigStore store) {
        this(store.createId(), store);
    }

    public SystemConfigImpl(UUID id, ConfigStore store) {
        String host;
        this._id = id;
        this._store = store;
        try {
            InetAddress addr = InetAddress.getLocalHost();
            host = addr.getHostName();
        }
        catch (UnknownHostException e) {
            host = "localhost";
        }
        this._host = host;
    }

    public String getName() {
        return this._name;
    }

    public String getOperatingSystemName() {
        return OS_NAME;
    }

    public String getNodeName() {
        return this._host;
    }

    public String getOSRelease() {
        return OS_VERSION;
    }

    public String getOSVersion() {
        return "";
    }

    public String getOSArchitecture() {
        return OS_ARCH;
    }

    public UUID getId() {
        return this._id;
    }

    public SystemConfigType getConfigType() {
        return SystemConfigType.getInstance();
    }

    public ConfiguredObject getParent() {
        return null;
    }

    public boolean isDurable() {
        return false;
    }

    public void addBroker(BrokerConfig broker) {
        broker.setSystem(this);
        this._store.addConfiguredObject(broker);
        this._brokers.put(broker.getId(), broker);
    }

    public void removeBroker(BrokerConfig broker) {
        this._brokers.remove(broker.getId());
        this._store.removeConfiguredObject(broker);
    }

    public long getCreateTime() {
        return this._createTime;
    }
}

