/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.cluster;

import java.util.List;
import javax.management.JMException;
import org.wso2.andes.management.common.mbeans.ClusterManagementInformation;
import org.wso2.andes.management.common.mbeans.annotations.MBeanConstructor;
import org.wso2.andes.management.common.mbeans.annotations.MBeanOperationParameter;
import org.wso2.andes.server.cluster.ClusterManager;
import org.wso2.andes.server.management.AMQManagedObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterManagementInformationMBean
extends AMQManagedObject
implements ClusterManagementInformation {
    private ClusterManager clusterManager;

    @MBeanConstructor(value="Creates an MBean exposing an Cluster Manager")
    public ClusterManagementInformationMBean(ClusterManager clusterManager) throws JMException {
        super(ClusterManagementInformation.class, "ClusterManagementInformation");
        this.clusterManager = clusterManager;
    }

    @Override
    public String getZkServer() {
        return this.clusterManager.getZkConnectionString();
    }

    @Override
    public String getObjectInstanceName() {
        return "ClusterManagementInformation";
    }

    @Override
    public String[] getQueues(int nodeId) {
        return this.clusterManager.getQueues(nodeId);
    }

    @Override
    public List<Integer> getZkNodes() {
        return this.clusterManager.getZkNodes();
    }

    @Override
    public int getMessageCount(@MBeanOperationParameter(name="queueName", description="Name of the queue which message count is required") String queueName) {
        return this.clusterManager.numberOfMessagesInQueue(queueName);
    }

    @Override
    public List<String> getTopics() {
        List<String> topics = null;
        try {
            topics = this.clusterManager.getTopics();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return topics;
    }

    @Override
    public List<String> getSubscribers(String topic) {
        List<String> subs = null;
        try {
            subs = this.clusterManager.getSubscribers(topic);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return subs;
    }

    @Override
    public int getSubscriberCount(@MBeanOperationParameter(name="Topic", description="Topic name") String topic) {
        try {
            return this.clusterManager.getSubscriberCount(topic);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getNodeAddress(@MBeanOperationParameter(name="Node Id", description="Node id assigned by Cluster manager") int nodeId) {
        return this.clusterManager.getNodeAddress(nodeId);
    }
}

