/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.cassandra;

import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.AMQStoreException;
import org.wso2.andes.server.store.CassandraMessageStore;

public class QueueSubscriptionAcknowledgementHandler {
    private CassandraMessageStore cassandraMessageStore;
    private Map<Long, QueueMessageTag> deliveryTagMessageMap = new ConcurrentHashMap<Long, QueueMessageTag>();
    private Map<Long, QueueMessageTag> sentMessagesMap = new ConcurrentHashMap<Long, QueueMessageTag>();
    private SortedMap<Long, Long> timeStampAckedMessageIdMap = new ConcurrentSkipListMap<Long, Long>();
    private SortedMap<Long, Long> timeStampMessageIdMap = new ConcurrentSkipListMap<Long, Long>();
    private QueueMessageTagCleanupJob cleanupJob;
    private long timeOutInMills = 10000L;
    private long ackedMessageTimeOut = 3L * this.timeOutInMills;
    private static Log log = LogFactory.getLog(QueueSubscriptionAcknowledgementHandler.class);

    public QueueSubscriptionAcknowledgementHandler(CassandraMessageStore cassandraMessageStore, String queue) {
        this.cassandraMessageStore = cassandraMessageStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkAndRegisterSent(long deliveryTag, long messageId, String queue) {
        if (!this.sentMessagesMap.containsKey(messageId) && !this.timeStampAckedMessageIdMap.containsValue(messageId)) {
            this.sentMessagesMap.put(messageId, new QueueMessageTag(queue, deliveryTag, messageId));
            this.deliveryTagMessageMap.put(deliveryTag, new QueueMessageTag(queue, deliveryTag, messageId));
            this.timeStampMessageIdMap.put(System.currentTimeMillis(), messageId);
            if (this.cleanupJob == null) {
                QueueSubscriptionAcknowledgementHandler queueSubscriptionAcknowledgementHandler = this;
                synchronized (queueSubscriptionAcknowledgementHandler) {
                    if (this.cleanupJob == null) {
                        this.cleanupJob = new QueueMessageTagCleanupJob();
                        Thread t = new Thread(this.cleanupJob);
                        t.setName(this.cleanupJob.getClass().getSimpleName());
                        t.start();
                    }
                }
            }
            return true;
        }
        return false;
    }

    public void handleAcknowledgement(long deliveryTag) {
        if (this.deliveryTagMessageMap.containsKey(deliveryTag)) {
            QueueMessageTag tag = this.deliveryTagMessageMap.get(deliveryTag);
            try {
                if (tag != null) {
                    this.cassandraMessageStore.removeMessageFromUserQueue(tag.getQueue(), tag.getMessageId());
                    this.timeStampAckedMessageIdMap.put(System.currentTimeMillis(), tag.messageId);
                    this.sentMessagesMap.remove(tag.getMessageId());
                    this.deliveryTagMessageMap.remove(deliveryTag);
                    this.cassandraMessageStore.addContentDeletionTask(tag.getMessageId());
                }
            }
            catch (AMQStoreException e) {
                e.printStackTrace();
            }
        }
    }

    private class QueueMessageTagCleanupJob
    implements Runnable {
        private boolean running = true;

        private QueueMessageTagCleanupJob() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            long currentTime = System.currentTimeMillis();
            while (this.running) {
                try {
                    if ((Long)QueueSubscriptionAcknowledgementHandler.this.timeStampMessageIdMap.firstKey() + QueueSubscriptionAcknowledgementHandler.this.timeOutInMills > currentTime) continue;
                    SortedMap headMap = QueueSubscriptionAcknowledgementHandler.this.timeStampMessageIdMap.headMap(currentTime - QueueSubscriptionAcknowledgementHandler.this.timeOutInMills);
                    if (headMap.size() > 0) {
                        for (Long l : headMap.keySet()) {
                            QueueMessageTag tag;
                            long mid = (Long)headMap.get(l);
                            QueueMessageTag mtag = (QueueMessageTag)QueueSubscriptionAcknowledgementHandler.this.sentMessagesMap.get(mid);
                            if (mtag == null) continue;
                            long deliveryTag = mtag.getDeliveryTag();
                            if (!QueueSubscriptionAcknowledgementHandler.this.deliveryTagMessageMap.containsKey(deliveryTag) || (tag = (QueueMessageTag)QueueSubscriptionAcknowledgementHandler.this.deliveryTagMessageMap.get(deliveryTag)) == null) continue;
                            if (QueueSubscriptionAcknowledgementHandler.this.sentMessagesMap.containsKey(tag.getMessageId())) {
                                QueueSubscriptionAcknowledgementHandler.this.sentMessagesMap.remove(tag.getMessageId());
                            }
                            QueueSubscriptionAcknowledgementHandler.this.deliveryTagMessageMap.remove(deliveryTag);
                        }
                        for (Long key : headMap.keySet()) {
                            QueueSubscriptionAcknowledgementHandler.this.timeStampMessageIdMap.remove(key);
                        }
                    }
                    if ((Long)QueueSubscriptionAcknowledgementHandler.this.timeStampAckedMessageIdMap.firstKey() + QueueSubscriptionAcknowledgementHandler.this.ackedMessageTimeOut >= currentTime) continue;
                    SortedMap headAckedMessagesMap = QueueSubscriptionAcknowledgementHandler.this.timeStampAckedMessageIdMap.headMap(currentTime - QueueSubscriptionAcknowledgementHandler.this.ackedMessageTimeOut);
                    for (long key : headAckedMessagesMap.keySet()) {
                        QueueSubscriptionAcknowledgementHandler.this.timeStampAckedMessageIdMap.remove(key);
                    }
                }
                catch (Exception e) {
                    log.error((Object)"Error while running Queue Message Tag Cleanup Task", (Throwable)e);
                }
                finally {
                    try {
                        Thread.sleep(60000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }

        public void stop() {
        }
    }

    private class QueueMessageTag {
        private long deliveryTag;
        private long messageId;
        private String queue;

        public QueueMessageTag(String queue, long deliveryTag, long msgId) {
            this.queue = queue;
            this.deliveryTag = deliveryTag;
            this.messageId = msgId;
        }

        public long getDeliveryTag() {
            return this.deliveryTag;
        }

        public long getMessageId() {
            return this.messageId;
        }

        public String getQueue() {
            return this.queue;
        }
    }
}

