/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.cassandra;

import java.util.ArrayList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.server.AMQChannel;
import org.wso2.andes.server.ClusterResourceHolder;
import org.wso2.andes.server.cassandra.CassandraReliableMessageCoordinator;
import org.wso2.andes.server.cassandra.CassandraSubscription;
import org.wso2.andes.server.cassandra.ClusteringEnabledSubscriptionManager;
import org.wso2.andes.server.cassandra.InOrderMessageFlusher;
import org.wso2.andes.server.cassandra.QueueSubscriptionAcknowledgementHandler;
import org.wso2.andes.server.queue.AMQQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OnceInOrderEnabledSubscriptionManager
implements ClusteringEnabledSubscriptionManager {
    private Map<String, CassandraReliableMessageCoordinator> workMap = new ConcurrentHashMap<String, CassandraReliableMessageCoordinator>();
    private Queue<String> subscriptionQueue = new ConcurrentLinkedQueue<String>();
    private static Log log = LogFactory.getLog(OnceInOrderEnabledSubscriptionManager.class);
    private ExecutorService executor = null;
    private boolean active = true;
    private Map<AMQChannel, Map<Long, Semaphore>> unAckedMessagelocks = new ConcurrentHashMap<AMQChannel, Map<Long, Semaphore>>();
    private Map<String, Semaphore> queueLock = new ConcurrentHashMap<String, Semaphore>();

    @Override
    public void init() {
        this.executor = Executors.newFixedThreadPool(ClusterResourceHolder.getInstance().getClusterConfiguration().getSubscriptionPoolSize());
        this.start();
    }

    @Override
    public void addSubscription(AMQQueue queue, CassandraSubscription subscription) {
        InOrderMessageFlusher sender = new InOrderMessageFlusher(subscription.getSubscription(), queue, subscription.getSession());
        if (!ClusterResourceHolder.getInstance().getClusterConfiguration().isClusteringEnabled().booleanValue() && this.queueLock.get(queue.getResourceName()) == null) {
            Semaphore ql = new Semaphore(1);
            this.queueLock.put(queue.getResourceName(), ql);
        }
        this.addWork(sender);
    }

    @Override
    public void removeSubscription(String queueName, String subscriptionId) {
        int remainingSubscriptionCount;
        CassandraReliableMessageCoordinator coordinator = this.workMap.get(queueName);
        if (coordinator != null && (remainingSubscriptionCount = coordinator.removeSubscription(subscriptionId)) == 0) {
            coordinator.setMarkedForRemoval(true);
            this.queueLock.remove(queueName);
        }
    }

    @Override
    public Map<AMQChannel, Map<Long, Semaphore>> getUnAcknowledgedMessageLocks() {
        return this.unAckedMessagelocks;
    }

    @Override
    public Map<AMQChannel, QueueSubscriptionAcknowledgementHandler> getAcknowledgementHandlerMap() {
        throw new UnsupportedOperationException("Not yet supported for Once In order impl");
    }

    @Override
    public void stopAllMessageFlushers() {
        throw new UnsupportedOperationException("Not yet supported for Once In order impl");
    }

    private void start() {
        this.active = true;
        this.executor.submit(new CassandraReliableMessageFlusherManagerTask());
    }

    public void stop() {
        this.active = false;
    }

    private void addWork(InOrderMessageFlusher flusher) {
        CassandraReliableMessageCoordinator coordinator = this.workMap.get(flusher.getQueue().getName());
        if (coordinator == null) {
            ArrayList<InOrderMessageFlusher> flusherList = new ArrayList<InOrderMessageFlusher>();
            flusherList.add(flusher);
            coordinator = new CassandraReliableMessageCoordinator(flusher.getQueue().getName(), flusherList);
            this.subscriptionQueue.offer(flusher.getQueue().getName());
            this.workMap.put(flusher.getQueue().getName(), coordinator);
        } else {
            coordinator.addFlusher(flusher);
        }
    }

    public Map<String, Semaphore> getQueueLock() {
        return this.queueLock;
    }

    private class CassandraReliableMessageFlusherManagerTask
    implements Runnable {
        private CassandraReliableMessageFlusherManagerTask() {
        }

        public void run() {
            while (OnceInOrderEnabledSubscriptionManager.this.active) {
                if (OnceInOrderEnabledSubscriptionManager.this.subscriptionQueue.size() > 0) {
                    String id = (String)OnceInOrderEnabledSubscriptionManager.this.subscriptionQueue.peek();
                    if (OnceInOrderEnabledSubscriptionManager.this.workMap.containsKey(id)) {
                        CassandraReliableMessageCoordinator work = (CassandraReliableMessageCoordinator)OnceInOrderEnabledSubscriptionManager.this.workMap.get(id);
                        if (work.isMarkedForRemoval()) {
                            OnceInOrderEnabledSubscriptionManager.this.workMap.remove(id);
                            OnceInOrderEnabledSubscriptionManager.this.subscriptionQueue.remove();
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Removing subscription queue " + id + " from work map"));
                            }
                        } else {
                            if (!work.isWorking()) {
                                OnceInOrderEnabledSubscriptionManager.this.executor.execute(work);
                            }
                            OnceInOrderEnabledSubscriptionManager.this.subscriptionQueue.remove();
                            OnceInOrderEnabledSubscriptionManager.this.subscriptionQueue.offer(id);
                        }
                    } else {
                        OnceInOrderEnabledSubscriptionManager.this.subscriptionQueue.remove();
                    }
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    log.error((Object)"Error in thread sleep", (Throwable)e);
                }
            }
        }
    }
}

