/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.cassandra;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.AMQStoreException;
import org.wso2.andes.server.AMQChannel;
import org.wso2.andes.server.ClusterResourceHolder;
import org.wso2.andes.server.cassandra.ClusteringEnabledSubscriptionManager;
import org.wso2.andes.server.protocol.AMQProtocolSession;
import org.wso2.andes.server.queue.AMQQueue;
import org.wso2.andes.server.queue.QueueEntry;
import org.wso2.andes.server.store.CassandraMessageStore;
import org.wso2.andes.server.subscription.Subscription;
import org.wso2.andes.server.subscription.SubscriptionImpl;

public class InOrderMessageFlusher {
    private Subscription subscription;
    private AMQQueue queue;
    private AMQProtocolSession session;
    private String id;
    private int defaultMessageCount = 1;
    private int messageCount;
    private ClusteringEnabledSubscriptionManager subscriptionManager;
    private long maxWaitTimePerMessage = 120000L;
    private static Log log = LogFactory.getLog(InOrderMessageFlusher.class);

    public InOrderMessageFlusher(Subscription subscription, AMQQueue queue, AMQProtocolSession session) {
        this.subscription = subscription;
        this.queue = queue;
        this.session = session;
        this.id = "" + subscription.getSubscriptionID();
        this.messageCount = this.defaultMessageCount;
        this.subscriptionManager = ClusterResourceHolder.getInstance().getSubscriptionManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send() {
        CassandraMessageStore messageStore = ClusterResourceHolder.getInstance().getCassandraMessageStore();
        try {
            List<QueueEntry> messages = messageStore.getMessagesFromGlobalQueue(this.queue, this.session, this.messageCount);
            if (messages.size() > 0) {
                for (QueueEntry message : messages) {
                    try {
                        if (!(this.subscription instanceof SubscriptionImpl.AckSubscription)) continue;
                        AMQChannel aMQChannel = ((SubscriptionImpl.AckSubscription)this.subscription).getChannel();
                        synchronized (aMQChannel) {
                            AMQChannel channel = ((SubscriptionImpl)this.subscription).getChannel();
                            if (!this.subscriptionManager.getUnAcknowledgedMessageLocks().containsKey(channel)) {
                                ConcurrentHashMap messageLocks = new ConcurrentHashMap();
                                this.subscriptionManager.getUnAcknowledgedMessageLocks().put(channel, messageLocks);
                            }
                            Semaphore lock = new Semaphore(1);
                            lock.acquire();
                            this.subscriptionManager.getUnAcknowledgedMessageLocks().get(channel).put(channel.getCurrentDeliveryTag() + 1L, lock);
                            this.subscription.send(message);
                            lock.tryAcquire(ClusterResourceHolder.getInstance().getClusterConfiguration().getMaxAckWaitTime(), TimeUnit.SECONDS);
                            messageStore.removeMessageFromGlobalQueue(this.queue.getName(), message.getMessage().getMessageNumber());
                        }
                    }
                    catch (Exception e) {
                        log.error((Object)"Unexpected Error in Message Flusher Task while delivering the message : ", (Throwable)e);
                    }
                }
            }
        }
        catch (AMQStoreException e) {
            log.error((Object)"Error while sending messages ", (Throwable)e);
        }
    }

    public String getSubscriptionId() {
        return this.id;
    }

    public Subscription getSubscription() {
        return this.subscription;
    }

    public AMQQueue getQueue() {
        return this.queue;
    }
}

