/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.cassandra;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.AMQException;
import org.wso2.andes.server.ClusterResourceHolder;
import org.wso2.andes.server.cassandra.CassandraSubscription;
import org.wso2.andes.server.configuration.ClusterConfiguration;
import org.wso2.andes.server.message.AMQMessage;
import org.wso2.andes.server.protocol.AMQProtocolSession;
import org.wso2.andes.server.queue.AMQQueue;
import org.wso2.andes.server.queue.QueueEntry;
import org.wso2.andes.server.store.CassandraMessageStore;
import org.wso2.andes.server.subscription.Subscription;
import org.wso2.andes.server.subscription.SubscriptionImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CassandraMessageFlusher
extends Thread {
    private Map<String, CassandraSubscription> cassandraSubscriptions;
    private AMQQueue queue;
    private boolean running = true;
    private static Log log = LogFactory.getLog(CassandraMessageFlusher.class);
    private ExecutorService executor = null;
    private int messageCount = 20;
    private int ackTime;
    private long lastProcessedId = 0L;
    private int resetCounter;
    private int resetCount = 50;

    public CassandraMessageFlusher(AMQQueue queue, Map<String, CassandraSubscription> cassandraSubscriptions) {
        this.cassandraSubscriptions = cassandraSubscriptions;
        this.queue = queue;
        ClusterConfiguration clusterConfiguration = ClusterResourceHolder.getInstance().getClusterConfiguration();
        this.messageCount = clusterConfiguration.getMessageBatchSizeForSubscribers();
        this.executor = Executors.newFixedThreadPool(clusterConfiguration.getFlusherPoolSize());
        this.ackTime = ClusterResourceHolder.getInstance().getClusterConfiguration().getMaxAckWaitTime();
    }

    @Override
    public void run() {
        while (this.running) {
            try {
                CassandraMessageStore messageStore;
                List<QueueEntry> messages;
                if (this.resetOffset()) {
                    this.lastProcessedId = 0L;
                }
                if ((messages = (messageStore = ClusterResourceHolder.getInstance().getCassandraMessageStore()).getMessagesFromUserQueue(this.queue, this.messageCount, this.lastProcessedId)).size() == this.messageCount) {
                    this.messageCount += 10;
                    if (this.messageCount > ClusterResourceHolder.getInstance().getClusterConfiguration().getFlusherPoolSize()) {
                        this.messageCount = ClusterResourceHolder.getInstance().getClusterConfiguration().getFlusherPoolSize() - 1;
                    }
                } else {
                    this.messageCount -= 10;
                    if (this.messageCount < 20) {
                        this.messageCount = 20;
                    }
                }
                if (messages.size() > 0 && this.cassandraSubscriptions.size() > 0) {
                    Iterator<CassandraSubscription> subs = this.cassandraSubscriptions.values().iterator();
                    for (int i = 0; i < messages.size(); ++i) {
                        QueueEntry message = messages.get(i);
                        try {
                            CassandraSubscription cassandraSubscription;
                            if (subs.hasNext()) {
                                cassandraSubscription = subs.next();
                            } else {
                                subs = this.cassandraSubscriptions.values().iterator();
                                cassandraSubscription = subs.next();
                            }
                            Subscription subscription = cassandraSubscription.getSubscription();
                            AMQProtocolSession session = cassandraSubscription.getSession();
                            ((AMQMessage)message.getMessage()).setClientIdentifier(session);
                            this.deliverAsynchronously(subscription, message);
                            if (i != messages.size() - 1) continue;
                            this.lastProcessedId = message.getMessage().getMessageNumber();
                            continue;
                        }
                        catch (Exception e) {
                            log.error((Object)"Unexpected Error in Message Flusher Task while delivering the message : ", (Throwable)e);
                            e.printStackTrace();
                        }
                    }
                    continue;
                }
                if (messages.size() == 0) {
                    this.resetOffset();
                }
                try {
                    Thread.sleep(ClusterResourceHolder.getInstance().getClusterConfiguration().getQueueWorkerInterval());
                }
                catch (InterruptedException interruptedException) {
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public AMQQueue getQueue() {
        return this.queue;
    }

    private void deliverAsynchronously(final Subscription subscription, final QueueEntry message) {
        Runnable r = new Runnable(){

            public void run() {
                String oldName = Thread.currentThread().getName();
                Thread.currentThread().setName("MessageFlusher-AsyncDelivery-Thread : " + oldName);
                try {
                    if (subscription instanceof SubscriptionImpl.AckSubscription) {
                        subscription.send(message);
                    } else {
                        log.error("Unexpected Subscription Implementation : " + subscription != null ? subscription.getClass().getName() : null);
                    }
                }
                catch (AMQException e) {
                    log.error((Object)"Error while delivering message ", (Throwable)e);
                }
                catch (Throwable e) {
                    log.error((Object)"Error while delivering message ", e);
                }
            }
        };
        this.executor.execute(r);
    }

    public void stopFlusher() {
        this.running = false;
    }

    private boolean resetOffset() {
        if (this.resetCounter++ > this.resetCount) {
            this.resetCounter = 0;
            return true;
        }
        return false;
    }
}

