/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server;

import java.util.Map;
import org.apache.log4j.Logger;
import org.wso2.andes.AMQException;
import org.wso2.andes.server.ack.UnacknowledgedMessageMap;
import org.wso2.andes.server.queue.QueueEntry;
import org.wso2.andes.server.store.TransactionLog;
import org.wso2.andes.server.subscription.Subscription;
import org.wso2.andes.server.txn.AutoCommitTransaction;
import org.wso2.andes.server.txn.ServerTransaction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtractResendAndRequeue
implements UnacknowledgedMessageMap.Visitor {
    private static final Logger _log = Logger.getLogger(ExtractResendAndRequeue.class);
    private final Map<Long, QueueEntry> _msgToRequeue;
    private final Map<Long, QueueEntry> _msgToResend;
    private final boolean _requeueIfUnabletoResend;
    private final UnacknowledgedMessageMap _unacknowledgedMessageMap;
    private final TransactionLog _transactionLog;

    public ExtractResendAndRequeue(UnacknowledgedMessageMap unacknowledgedMessageMap, Map<Long, QueueEntry> msgToRequeue, Map<Long, QueueEntry> msgToResend, boolean requeueIfUnabletoResend, TransactionLog txnLog) {
        this._unacknowledgedMessageMap = unacknowledgedMessageMap;
        this._msgToRequeue = msgToRequeue;
        this._msgToResend = msgToResend;
        this._requeueIfUnabletoResend = requeueIfUnabletoResend;
        this._transactionLog = txnLog;
    }

    @Override
    public boolean callback(long deliveryTag, QueueEntry message) throws AMQException {
        message.setRedelivered();
        Subscription subscription = message.getDeliveredSubscription();
        if (subscription != null) {
            if (!subscription.isClosed()) {
                this._msgToResend.put(deliveryTag, message);
            } else {
                this._msgToRequeue.put(deliveryTag, message);
            }
        } else if (!message.isQueueDeleted()) {
            if (this._requeueIfUnabletoResend) {
                this._msgToRequeue.put(deliveryTag, message);
            } else {
                this.dequeueEntry(message);
                _log.info((Object)("No DeadLetter Queue and requeue not requested so dropping message:" + message));
            }
        } else {
            this.dequeueEntry(message);
            _log.warn((Object)("Message.queue is null and no DeadLetter Queue so dropping message:" + message));
        }
        return false;
    }

    private void dequeueEntry(QueueEntry node) {
        AutoCommitTransaction txn = new AutoCommitTransaction(this._transactionLog);
        this.dequeueEntry(node, txn);
    }

    private void dequeueEntry(final QueueEntry node, ServerTransaction txn) {
        txn.dequeue(node.getQueue(), node.getMessage(), new ServerTransaction.Action(){

            public void postCommit() {
                node.discard();
            }

            public void onRollback() {
            }
        });
    }

    @Override
    public void visitComplete() {
        this._unacknowledgedMessageMap.clear();
    }
}

