/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.wso2.andes.server.ProtocolExclusion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrokerOptions {
    private static final long serialVersionUID = 8051825964945442234L;
    public static final String DEFAULT_CONFIG_FILE = "etc/config.xml";
    public static final String DEFAULT_LOG_CONFIG_FILE = "etc/log4j.xml";
    public static final String QPID_HOME = "QPID_HOME";
    public static final String PORTS = "p";
    public static final String SSL_PORTS = "s";
    public static final String BIND = "b";
    public static final String MANAGEMENT = "m";
    public static final String LOG_CONFIG = "l";
    public static final String WATCH = "w";
    public static final String CONFIG = "c";
    private final Set<Integer> _ports = new HashSet<Integer>();
    private final Set<Integer> _sslPorts = new HashSet<Integer>();
    private final Map<ProtocolExclusion, Set<Integer>> _exclusionMap = new HashMap<ProtocolExclusion, Set<Integer>>();
    private String _configFile;
    private String _logConfigFile;
    private String _bind;
    private Integer _jmxPort;
    private Integer _logWatchFrequency = 0;

    public void addPort(int port) {
        this._ports.add(port);
    }

    public void addSSLPort(int sslPort) {
        this._sslPorts.add(sslPort);
    }

    public Set<Integer> getPorts() {
        return Collections.unmodifiableSet(this._ports);
    }

    public Set<Integer> getSSLPorts() {
        return Collections.unmodifiableSet(this._sslPorts);
    }

    public String getConfigFile() {
        return this._configFile;
    }

    public void setConfigFile(String configFile) {
        this._configFile = configFile;
    }

    public String getLogConfigFile() {
        return this._logConfigFile;
    }

    public void setLogConfigFile(String logConfigFile) {
        this._logConfigFile = logConfigFile;
    }

    public Integer getJmxPort() {
        return this._jmxPort;
    }

    public void setJmxPort(int jmxPort) {
        this._jmxPort = jmxPort;
    }

    public String getQpidHome() {
        return System.getProperty(QPID_HOME);
    }

    public Set<Integer> getExcludedPorts(ProtocolExclusion excludeProtocol) {
        Set<Integer> excludedPorts = this._exclusionMap.get((Object)excludeProtocol);
        return excludedPorts == null ? Collections.emptySet() : excludedPorts;
    }

    public void addExcludedPort(ProtocolExclusion excludeProtocol, int port) {
        if (!this._exclusionMap.containsKey((Object)excludeProtocol)) {
            this._exclusionMap.put(excludeProtocol, new HashSet());
        }
        Set<Integer> ports = this._exclusionMap.get((Object)excludeProtocol);
        ports.add(port);
    }

    public String getBind() {
        return this._bind;
    }

    public void setBind(String bind) {
        this._bind = bind;
    }

    public int getLogWatchFrequency() {
        return this._logWatchFrequency;
    }

    public void setLogWatchFrequency(int logWatchFrequency) {
        this._logWatchFrequency = logWatchFrequency;
    }
}

