/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.management.common.mbeans;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.wso2.andes.management.common.mbeans.annotations.MBeanAttribute;
import org.wso2.andes.management.common.mbeans.annotations.MBeanOperationParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface ClusterManagementInformation {
    public static final String TYPE = "ClusterManagementInformation";
    public static final String ATTR_NODE_ID = "nodeId";
    public static final String ATTR_ADDRESS = "Address";
    public static final String ATTR_PORT = "Port";
    public static final List<String> CLUSTER_ATTRIBUTES = Collections.unmodifiableList(new ArrayList<String>(new HashSet<String>(Arrays.asList("nodeId", "Address", "Port"))));

    @MBeanAttribute(name="Address", description="zookeeper Server")
    public String getZkServer();

    @MBeanAttribute(name="Queues", description="Existing queues in the node")
    public String[] getQueues(int var1);

    @MBeanAttribute(name="zooKeeperNodes", description="Existing zookeeper nodes")
    public List<Integer> getZkNodes();

    @MBeanAttribute(name="MessageCount", description="Message Count in the queue")
    public int getMessageCount(@MBeanOperationParameter(name="queueName", description="Name of the queue which message count is required") String var1);

    @MBeanAttribute(name="Topics", description="Topics where subscribers are available")
    public List<String> getTopics();

    @MBeanAttribute(name="Subscribers", description="Subscribers for a given topic")
    public List<String> getSubscribers(@MBeanOperationParameter(name="Topic", description="Topic name") String var1);

    @MBeanAttribute(name="Subscriber Count", description="Number of subscribers for a given topic")
    public int getSubscriberCount(@MBeanOperationParameter(name="Topic", description="Topic name") String var1);
}

