/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.framing.amqp_0_91;

import org.apache.mina.common.ByteBuffer;
import org.wso2.andes.AMQException;
import org.wso2.andes.framing.AMQFrameDecodingException;
import org.wso2.andes.framing.AMQMethodBody;
import org.wso2.andes.framing.AMQMethodBodyInstanceFactory;
import org.wso2.andes.framing.AMQShortString;
import org.wso2.andes.framing.ConnectionCloseBody;
import org.wso2.andes.framing.MethodDispatcher;
import org.wso2.andes.framing.amqp_0_91.AMQMethodBody_0_91;
import org.wso2.andes.framing.amqp_0_91.MethodDispatcher_0_91;

public class ConnectionCloseBodyImpl
extends AMQMethodBody_0_91
implements ConnectionCloseBody {
    private static final AMQMethodBodyInstanceFactory FACTORY_INSTANCE = new AMQMethodBodyInstanceFactory(){

        public AMQMethodBody newInstance(ByteBuffer in, long size) throws AMQFrameDecodingException {
            return new ConnectionCloseBodyImpl(in);
        }
    };
    public static final int CLASS_ID = 10;
    public static final int METHOD_ID = 50;
    private final int _replyCode;
    private final AMQShortString _replyText;
    private final int _classId;
    private final int _methodId;

    public static AMQMethodBodyInstanceFactory getFactory() {
        return FACTORY_INSTANCE;
    }

    public ConnectionCloseBodyImpl(ByteBuffer buffer) throws AMQFrameDecodingException {
        this._replyCode = this.readUnsignedShort(buffer);
        this._replyText = this.readAMQShortString(buffer);
        this._classId = this.readUnsignedShort(buffer);
        this._methodId = this.readUnsignedShort(buffer);
    }

    public ConnectionCloseBodyImpl(int replyCode, AMQShortString replyText, int classId, int methodId) {
        this._replyCode = replyCode;
        this._replyText = replyText;
        this._classId = classId;
        this._methodId = methodId;
    }

    public int getClazz() {
        return 10;
    }

    public int getMethod() {
        return 50;
    }

    public final int getReplyCode() {
        return this._replyCode;
    }

    public final AMQShortString getReplyText() {
        return this._replyText;
    }

    public final int getClassId() {
        return this._classId;
    }

    public final int getMethodId() {
        return this._methodId;
    }

    protected int getBodySize() {
        int size = 6;
        return size += this.getSizeOf(this._replyText);
    }

    public void writeMethodPayload(ByteBuffer buffer) {
        this.writeUnsignedShort(buffer, this._replyCode);
        this.writeAMQShortString(buffer, this._replyText);
        this.writeUnsignedShort(buffer, this._classId);
        this.writeUnsignedShort(buffer, this._methodId);
    }

    public boolean execute(MethodDispatcher dispatcher, int channelId) throws AMQException {
        return ((MethodDispatcher_0_91)dispatcher).dispatchConnectionClose(this, channelId);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("[ConnectionCloseBodyImpl: ");
        buf.append("replyCode=");
        buf.append(this.getReplyCode());
        buf.append(", ");
        buf.append("replyText=");
        buf.append(this.getReplyText());
        buf.append(", ");
        buf.append("classId=");
        buf.append(this.getClassId());
        buf.append(", ");
        buf.append("methodId=");
        buf.append(this.getMethodId());
        buf.append("]");
        return buf.toString();
    }
}

