/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.andes.core;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.andes.core.QueueManagerException;
import org.wso2.carbon.andes.core.QueueManagerService;
import org.wso2.carbon.andes.core.internal.registry.QueueManagementBeans;
import org.wso2.carbon.andes.core.internal.util.Utils;
import org.wso2.carbon.andes.core.types.Queue;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;

public class QueueManagerServiceImpl
implements QueueManagerService {
    private static int DEFAULT_ANDES_PORT = 5672;
    private static Log log = LogFactory.getLog(QueueManagerServiceImpl.class);
    private static String CARBON_CONFIG_PORT_OFFSET = "Ports.Offset";
    private static int CARBON_DEFAULT_PORT_OFFSET = 0;

    @Override
    public void createQueue(String queueName) throws QueueManagerException {
        try {
            String userName = QueueManagerServiceImpl.getLoggedInUserName();
            QueueManagementBeans.getInstance();
            if (!QueueManagementBeans.queueExists(queueName)) {
                QueueManagementBeans.getInstance().createQueue(queueName, userName);
            }
        }
        catch (Exception e) {
            log.error((Object)"Error in creating queue", (Throwable)e);
            throw new QueueManagerException("Error in creating queue ", e);
        }
    }

    @Override
    public List<Queue> getAllQueues() throws QueueManagerException {
        return QueueManagementBeans.getInstance().getAllQueues();
    }

    @Override
    public void deleteQueue(String queueName) throws QueueManagerException {
        try {
            UserRegistry userRegistry = Utils.getUserRegistry();
            String resourcePath = "event/queues/jms/" + queueName;
            QueueManagementBeans.getInstance();
            if (QueueManagementBeans.queueExists(queueName)) {
                QueueManagementBeans.getInstance().deleteQueue(queueName);
                userRegistry.delete(resourcePath);
            }
        }
        catch (RegistryException e) {
            throw new QueueManagerException("Failed to delete queue: " + queueName, e);
        }
    }

    private int readPortOffset() {
        ServerConfiguration carbonConfig = ServerConfiguration.getInstance();
        String portOffset = carbonConfig.getFirstProperty(CARBON_CONFIG_PORT_OFFSET);
        try {
            return portOffset != null ? Integer.parseInt(portOffset.trim()) : CARBON_DEFAULT_PORT_OFFSET;
        }
        catch (NumberFormatException e) {
            return CARBON_DEFAULT_PORT_OFFSET;
        }
    }

    private static String getLoggedInUserName() {
        String userName = "";
        userName = CarbonContext.getCurrentContext().getTenantId() != 0 ? CarbonContext.getCurrentContext().getUsername() + "!" + CarbonContext.getCurrentContext().getTenantDomain() : CarbonContext.getCurrentContext().getUsername();
        return userName.trim();
    }
}

