/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.andes.admin;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.andes.admin.internal.Exception.QueueManagerAdminException;
import org.wso2.carbon.andes.admin.internal.Queue;
import org.wso2.carbon.andes.admin.util.AndesQueueManagerAdminServiceDSHolder;
import org.wso2.carbon.andes.core.QueueManagerException;
import org.wso2.carbon.andes.core.QueueManagerService;
import org.wso2.carbon.core.AbstractAdmin;

public class AndesAdminService
extends AbstractAdmin {
    private static Log log = LogFactory.getLog(AndesAdminService.class);

    public void createQueue(String queueName) throws QueueManagerAdminException {
        QueueManagerService queueManagerService = AndesQueueManagerAdminServiceDSHolder.getInstance().getQueueManagerService();
        try {
            queueManagerService.createQueue(queueName);
        }
        catch (QueueManagerException e) {
            log.error((Object)"Error in creating the queue", (Throwable)e);
            throw new QueueManagerAdminException("Error in creating the queue", e);
        }
    }

    public Queue[] getAllQueues() throws QueueManagerAdminException {
        ArrayList<Queue> allQueues = new ArrayList<Queue>();
        Queue[] queuesDTO = null;
        try {
            QueueManagerService queueManagerService = AndesQueueManagerAdminServiceDSHolder.getInstance().getQueueManagerService();
            List queues = queueManagerService.getAllQueues();
            queuesDTO = new Queue[queues.size()];
            for (org.wso2.carbon.andes.core.types.Queue queue : queues) {
                Queue queueDTO = new Queue();
                queueDTO.setQueueName(queue.getQueueName());
                queueDTO.setMessageCount(queue.getMessageCount());
                queueDTO.setCreatedTime(queue.getCreatedTime());
                queueDTO.setUpdatedTime(queue.getUpdatedTime());
                allQueues.add(queueDTO);
            }
            allQueues.toArray(queuesDTO);
        }
        catch (QueueManagerException e) {
            throw new QueueManagerAdminException("Problem in getting queues from back end", e);
        }
        return queuesDTO;
    }

    public void deleteQueue(String queueName) throws QueueManagerAdminException {
        try {
            QueueManagerService queueManagerService = AndesQueueManagerAdminServiceDSHolder.getInstance().getQueueManagerService();
            queueManagerService.deleteQueue(queueName);
        }
        catch (QueueManagerException e) {
            throw new QueueManagerAdminException("Error in deleting queue", e);
        }
    }
}

