/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.andes.cluster.mgt.ui;

import java.rmi.RemoteException;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.wso2.carbon.andes.mgt.stub.AndesManagerServiceClusterMgtAdminExceptionException;
import org.wso2.carbon.andes.mgt.stub.AndesManagerServiceStub;
import org.wso2.carbon.andes.mgt.stub.types.carbon.NodeDetail;
import org.wso2.carbon.andes.mgt.stub.types.carbon.Queue;
import org.wso2.carbon.andes.mgt.stub.types.carbon.Topic;

public class ClusterManagerClient {
    private AndesManagerServiceStub stub;

    public ClusterManagerClient(ConfigurationContext configCtx, String backendServerURL, String cookie) throws Exception {
        String serviceURL = backendServerURL + "AndesManagerService";
        this.stub = new AndesManagerServiceStub(configCtx, serviceURL);
        ServiceClient client = this.stub._getServiceClient();
        Options options = client.getOptions();
        options.setManageSession(true);
        options.setProperty("Cookie", (Object)cookie);
    }

    public NodeDetail[] getAllNodeDetail(int startingIndex, int maxMessageBoxesCount) throws RemoteException, AndesManagerServiceClusterMgtAdminExceptionException {
        NodeDetail[] result = this.stub.getAllNodeDetail(startingIndex, maxMessageBoxesCount);
        return result;
    }

    public int getNumOfNodes() throws RemoteException, AndesManagerServiceClusterMgtAdminExceptionException {
        return this.stub.getNumOfNodes();
    }

    public Queue[] getQueuesOfNode(String hostName, int startingIndex, int maxTopicCount) throws RemoteException, AndesManagerServiceClusterMgtAdminExceptionException {
        Queue[] result = this.stub.getAllQueuesForNode(hostName, startingIndex, maxTopicCount);
        return result;
    }

    public Topic[] getAllTopics(int startingIndex, int maxTopicCount) throws RemoteException, AndesManagerServiceClusterMgtAdminExceptionException {
        return this.stub.getAllTopicsForNode(startingIndex, maxTopicCount);
    }

    public long updateNumOfSubscriptionsForTopic(String topicName) throws RemoteException, AndesManagerServiceClusterMgtAdminExceptionException {
        return this.stub.getNumberofSubscriptionsForTopic(topicName);
    }

    public long updateMemoryUsage(String hostName) throws RemoteException, AndesManagerServiceClusterMgtAdminExceptionException {
        return this.stub.getMemoryUsage(hostName);
    }

    public long updateTopicCount() throws RemoteException, AndesManagerServiceClusterMgtAdminExceptionException {
        return this.stub.getNumberOfTopics();
    }

    public long updateNumOfMessagesForQueue(String queueName) throws AndesManagerServiceClusterMgtAdminExceptionException, RemoteException {
        return this.stub.getNumberOfMessagesForQueue(queueName);
    }

    public long updateQueueCountForNode(String hostName) throws RemoteException, AndesManagerServiceClusterMgtAdminExceptionException {
        return this.stub.getNumberOfQueues(hostName);
    }

    public long updateThroughputForNode(String hostName) throws RemoteException, AndesManagerServiceClusterMgtAdminExceptionException {
        return this.stub.getThroughputForNode(hostName);
    }

    public boolean restartNode(String hostName) {
        return true;
    }

    public String getCassandraConnection() throws RemoteException, AndesManagerServiceClusterMgtAdminExceptionException {
        return this.stub.getCassandraConnection();
    }

    public String getZookeeperConnection() throws RemoteException, AndesManagerServiceClusterMgtAdminExceptionException {
        return this.stub.getZookeeperConnection();
    }

    public boolean updateWorkerForQueue(String queueToUpdate, String newNodeToAssign) throws RemoteException {
        boolean result = this.stub.updateWorkerForQueue(queueToUpdate, newNodeToAssign);
        return result;
    }
}

