/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.transport;

import java.util.LinkedHashMap;
import java.util.Map;
import org.wso2.andes.transport.Method;
import org.wso2.andes.transport.MethodDelegate;
import org.wso2.andes.transport.Option;
import org.wso2.andes.transport.codec.Decoder;
import org.wso2.andes.transport.codec.Encoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class QueueDelete
extends Method {
    public static final int TYPE = 2050;
    private short packing_flags = 0;
    private String queue;

    @Override
    public final int getStructType() {
        return 2050;
    }

    @Override
    public final int getSizeWidth() {
        return 0;
    }

    @Override
    public final int getPackWidth() {
        return 2;
    }

    @Override
    public final boolean hasPayload() {
        return false;
    }

    @Override
    public final byte getEncodedTrack() {
        return 3;
    }

    @Override
    public final boolean isConnectionControl() {
        return false;
    }

    public QueueDelete() {
    }

    public QueueDelete(String queue, Option ... _options) {
        if (queue != null) {
            this.setQueue(queue);
        }
        block8: for (int i = 0; i < _options.length; ++i) {
            switch (_options[i]) {
                case IF_UNUSED: {
                    this.packing_flags = (short)(this.packing_flags | 0x200);
                    continue block8;
                }
                case IF_EMPTY: {
                    this.packing_flags = (short)(this.packing_flags | 0x400);
                    continue block8;
                }
                case SYNC: {
                    this.setSync(true);
                    continue block8;
                }
                case BATCH: {
                    this.setBatch(true);
                    continue block8;
                }
                case UNRELIABLE: {
                    this.setUnreliable(true);
                    continue block8;
                }
                case NONE: {
                    continue block8;
                }
                default: {
                    throw new IllegalArgumentException("invalid option: " + (Object)((Object)_options[i]));
                }
            }
        }
    }

    @Override
    public <C> void dispatch(C context, MethodDelegate<C> delegate) {
        delegate.queueDelete(context, this);
    }

    public final boolean hasQueue() {
        return (this.packing_flags & 0x100) != 0;
    }

    public final QueueDelete clearQueue() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFFEFF);
        this.queue = null;
        this.dirty = true;
        return this;
    }

    public final String getQueue() {
        return this.queue;
    }

    public final QueueDelete setQueue(String value) {
        this.queue = value;
        this.packing_flags = (short)(this.packing_flags | 0x100);
        this.dirty = true;
        return this;
    }

    public final QueueDelete queue(String value) {
        return this.setQueue(value);
    }

    public final boolean hasIfUnused() {
        return (this.packing_flags & 0x200) != 0;
    }

    public final QueueDelete clearIfUnused() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFFDFF);
        this.dirty = true;
        return this;
    }

    public final boolean getIfUnused() {
        return this.hasIfUnused();
    }

    public final QueueDelete setIfUnused(boolean value) {
        this.packing_flags = value ? (short)(this.packing_flags | 0x200) : (short)(this.packing_flags & 0xFFFFFDFF);
        this.dirty = true;
        return this;
    }

    public final QueueDelete ifUnused(boolean value) {
        return this.setIfUnused(value);
    }

    public final boolean hasIfEmpty() {
        return (this.packing_flags & 0x400) != 0;
    }

    public final QueueDelete clearIfEmpty() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFFBFF);
        this.dirty = true;
        return this;
    }

    public final boolean getIfEmpty() {
        return this.hasIfEmpty();
    }

    public final QueueDelete setIfEmpty(boolean value) {
        this.packing_flags = value ? (short)(this.packing_flags | 0x400) : (short)(this.packing_flags & 0xFFFFFBFF);
        this.dirty = true;
        return this;
    }

    public final QueueDelete ifEmpty(boolean value) {
        return this.setIfEmpty(value);
    }

    @Override
    public void write(Encoder enc) {
        enc.writeUint16(this.packing_flags);
        if ((this.packing_flags & 0x100) != 0) {
            enc.writeStr8(this.queue);
        }
    }

    @Override
    public void read(Decoder dec) {
        this.packing_flags = (short)dec.readUint16();
        if ((this.packing_flags & 0x100) != 0) {
            this.queue = dec.readStr8();
        }
    }

    @Override
    public Map<String, Object> getFields() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        if ((this.packing_flags & 0x100) != 0) {
            result.put("queue", this.getQueue());
        }
        if ((this.packing_flags & 0x200) != 0) {
            result.put("ifUnused", this.getIfUnused());
        }
        if ((this.packing_flags & 0x400) != 0) {
            result.put("ifEmpty", this.getIfEmpty());
        }
        return result;
    }
}

