/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.tools.utils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.andes.tools.utils.CommandParser;
import org.wso2.andes.tools.utils.Console;
import org.wso2.andes.tools.utils.SimpleCommandParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleConsole
implements Console {
    private static Logger _devlog = LoggerFactory.getLogger(SimpleConsole.class);
    protected BufferedWriter _consoleWriter;
    protected BufferedReader _consoleReader;
    protected CommandParser _parser;

    public SimpleConsole(BufferedWriter writer, BufferedReader reader) {
        this._consoleWriter = writer;
        this._consoleReader = reader;
        this._parser = new SimpleCommandParser(this._consoleReader);
    }

    @Override
    public void print(String ... message) {
        try {
            for (String s : message) {
                this._consoleWriter.write(s);
            }
            this._consoleWriter.flush();
        }
        catch (IOException e) {
            _devlog.error(e.getMessage() + ": Occurred whilst trying to write:" + Arrays.asList(message));
        }
    }

    @Override
    public void println(String ... message) {
        this.print(message);
        this.print(System.getProperty("line.separator"));
    }

    @Override
    public String readln() {
        try {
            return this._consoleReader.readLine();
        }
        catch (IOException e) {
            _devlog.debug("Unable to read input due to:" + e.getMessage());
            return null;
        }
    }

    @Override
    public String[] readCommand() {
        try {
            return this._parser.parse();
        }
        catch (IOException e) {
            _devlog.error("Error reading command:" + e.getMessage());
            return new String[0];
        }
    }

    @Override
    public CommandParser getCommandParser() {
        return this._parser;
    }

    @Override
    public void setCommandParser(CommandParser parser) {
        this._parser = parser;
    }

    @Override
    public void displayList(boolean hasTitle, String ... list) {
        LinkedList<List> data = new LinkedList<List>();
        LinkedList<String> values = new LinkedList<String>();
        data.add(values);
        for (String value : list) {
            values.add(value);
        }
        if (hasTitle) {
            values.add(1, "*divider");
        }
        this.printMap(null, data);
    }

    @Override
    public void printMap(String title, List<List> entries) {
        try {
            int columns = entries.size();
            int[] columnWidth = new int[columns];
            int rowMax = 0;
            int itemMax = 0;
            for (int i = 0; i < columns; ++i) {
                int columnIRowMax = entries.get(i).size();
                if (columnIRowMax > rowMax) {
                    rowMax = columnIRowMax;
                }
                for (Object values : entries.get(i)) {
                    if (values.toString().equals("*divider")) continue;
                    int itemLength = values.toString().length();
                    if (itemLength > itemMax) {
                        itemMax = itemLength;
                    }
                    if (itemLength <= columnWidth[i]) continue;
                    columnWidth[i] = itemLength;
                }
            }
            int tableWidth = 0;
            int i = 0;
            while (i < columns) {
                int n = i++;
                columnWidth[n] = columnWidth[n] + 2;
            }
            for (int size : columnWidth) {
                tableWidth += size;
            }
            tableWidth += columns - 1;
            if (title != null) {
                if (title.length() > tableWidth) {
                    tableWidth = title.length();
                }
                this.printCellRow("+", "-", tableWidth);
                this.printCell(Console.CellFormat.CENTRED, "|", tableWidth, " " + title + " ", 0);
                this._consoleWriter.newLine();
            }
            this.printCellRow("+", "-", tableWidth);
            block6: for (int row = 0; row < rowMax; ++row) {
                for (int i2 = 0; i2 < columns; ++i2) {
                    List columnData = entries.get(i2);
                    String value = columnData.size() > row ? " " + columnData.get(row).toString() + " " : "  ";
                    if (i2 == 0 && value.equals(" *divider ")) {
                        this.printCellRow("+", "-", tableWidth);
                        continue block6;
                    }
                    this.printCell(Console.CellFormat.LEFT, "|", columnWidth[i2], value, i2);
                    if (i2 != columns - 1) continue;
                    this._consoleWriter.newLine();
                }
            }
            this.printCellRow("+", "-", tableWidth);
        }
        catch (IOException e) {
            _devlog.error(e.getMessage() + ": Occured whilst trying to write.");
        }
    }

    @Override
    public void close() {
        try {
            this._consoleReader.close();
        }
        catch (IOException e) {
            _devlog.error(e.getMessage() + ": Occured whilst trying to close reader.");
        }
        try {
            this._consoleWriter.close();
        }
        catch (IOException e) {
            _devlog.error(e.getMessage() + ": Occured whilst trying to close writer.");
        }
    }

    private void printCell(Console.CellFormat format, String edge, int cellWidth, String cell, int column) throws IOException {
        int pad = cellWidth - cell.length();
        if (column == 0) {
            this._consoleWriter.write(edge);
        }
        switch (format) {
            case CENTRED: {
                this.printPad(" ", pad / 2);
                break;
            }
            case RIGHT: {
                this.printPad(" ", pad);
            }
        }
        this._consoleWriter.write(cell);
        switch (format) {
            case CENTRED: {
                if (pad % 2 == 0) {
                    this.printPad(" ", pad / 2);
                    break;
                }
                this.printPad(" ", pad / 2 + 1);
                break;
            }
            case LEFT: {
                this.printPad(" ", pad);
            }
        }
        this._consoleWriter.write(edge);
    }

    private void printCellRow(String edge, String mid, int cellWidth) throws IOException {
        this._consoleWriter.write(edge);
        this.printPad(mid, cellWidth);
        this._consoleWriter.write(edge);
        this._consoleWriter.newLine();
    }

    private void printPad(String padChar, int count) throws IOException {
        for (int i = 0; i < count; ++i) {
            this._consoleWriter.write(padChar);
        }
    }
}

