/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.tools.messagestore.commands;

import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.wso2.andes.framing.AMQShortString;
import org.wso2.andes.server.exchange.Exchange;
import org.wso2.andes.server.queue.AMQQueue;
import org.wso2.andes.server.registry.ApplicationRegistry;
import org.wso2.andes.server.virtualhost.VirtualHost;
import org.wso2.andes.tools.messagestore.MessageStoreTool;
import org.wso2.andes.tools.messagestore.commands.AbstractCommand;

public class Select
extends AbstractCommand {
    public Select(MessageStoreTool tool) {
        super(tool);
    }

    public String help() {
        return "Perform a selection.";
    }

    public String usage() {
        return "select virtualhost <name> |exchange <name> |queue <name> | msg id=<msgids eg. 1,2,4-10>";
    }

    public String getCommand() {
        return "select";
    }

    public void execute(String ... args) {
        assert (args.length > 2);
        assert (args[0].equals("select"));
        if (args.length < 3) {
            if (args[1].equals("show")) {
                this.doSelect(args[1], null);
            } else {
                this._console.print("select : unknown command:");
                this._console.println(this.help());
            }
        } else if (args[1].equals("virtualhost") || args[1].equals("vhost") || args[1].equals("exchange") || args[1].equals("queue") || args[1].equals("msg")) {
            this.doSelect(args[1], args[2]);
        } else {
            this._console.println(this.help());
        }
    }

    private void doSelect(String type, String item) {
        VirtualHost vhost;
        if (type.equals("virtualhost")) {
            vhost = ApplicationRegistry.getInstance().getVirtualHostRegistry().getVirtualHost(item);
            if (vhost == null) {
                this._console.println("Virtualhost '" + item + "' not found.");
            } else {
                this._tool.getState().setVhost(vhost);
            }
        }
        if (type.equals("exchange")) {
            vhost = this._tool.getState().getVhost();
            if (vhost == null) {
                this._console.println("No Virtualhost open. Open a Virtualhost first.");
                return;
            }
            Exchange exchange = vhost.getExchangeRegistry().getExchange(new AMQShortString(item));
            if (exchange == null) {
                this._console.println("Exchange  '" + item + "' not found.");
            } else {
                this._tool.getState().setExchange(exchange);
            }
            if (this._tool.getState().getQueue() != null && !exchange.isBound(this._tool.getState().getQueue())) {
                this._tool.getState().setQueue(null);
            }
        }
        if (type.equals("queue")) {
            vhost = this._tool.getState().getVhost();
            if (vhost == null) {
                this._console.println("No Virtualhost open. Open a Virtualhost first.");
                return;
            }
            AMQQueue queue = vhost.getQueueRegistry().getQueue(new AMQShortString(item));
            if (queue == null) {
                this._console.println("Queue '" + item + "' not found.");
            } else {
                this._tool.getState().setQueue(queue);
                if (this._tool.getState().getExchange() == null) {
                    for (AMQShortString exchangeName : vhost.getExchangeRegistry().getExchangeNames()) {
                        Exchange exchange = vhost.getExchangeRegistry().getExchange(exchangeName);
                        if (!exchange.isBound(queue)) continue;
                        this._tool.getState().setExchange(exchange);
                        break;
                    }
                }
                this._tool.getState().setMessages((List<Long>)null);
            }
        }
        if (type.equals("msg") && item.startsWith("id=")) {
            StringTokenizer tok = new StringTokenizer(item.substring(item.indexOf("=") + 1), ",");
            LinkedList<Long> msgids = null;
            if (tok.hasMoreTokens()) {
                msgids = new LinkedList<Long>();
            }
            while (tok.hasMoreTokens()) {
                String next = tok.nextToken();
                if (next.contains("-")) {
                    Long start = Long.parseLong(next.substring(0, next.indexOf("-")));
                    Long end = Long.parseLong(next.substring(next.indexOf("-") + 1));
                    if (end < start) continue;
                    for (long l = start.longValue(); l <= end; ++l) {
                        msgids.add(l);
                    }
                    continue;
                }
                msgids.add(Long.parseLong(next));
            }
            this._tool.getState().setMessages(msgids);
        }
        if (type.equals("show")) {
            this._console.println(this._tool.getState().toString());
            if (this._tool.getState().getMessages() != null) {
                this._console.print("Msgs:");
                for (Long l : this._tool.getState().getMessages()) {
                    this._console.print(" " + l);
                }
                this._console.println("");
            }
        }
    }
}

