/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.transport;

import java.lang.ref.WeakReference;
import java.security.Principal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;
import javax.security.auth.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.andes.AMQException;
import org.wso2.andes.protocol.AMQConstant;
import org.wso2.andes.protocol.ProtocolEngine;
import org.wso2.andes.server.configuration.ConfigStore;
import org.wso2.andes.server.configuration.ConfiguredObject;
import org.wso2.andes.server.configuration.ConnectionConfig;
import org.wso2.andes.server.configuration.SessionConfig;
import org.wso2.andes.server.configuration.SessionConfigType;
import org.wso2.andes.server.logging.LogActor;
import org.wso2.andes.server.logging.LogSubject;
import org.wso2.andes.server.logging.actors.CurrentActor;
import org.wso2.andes.server.logging.actors.GenericActor;
import org.wso2.andes.server.logging.messages.ChannelMessages;
import org.wso2.andes.server.message.EnqueableMessage;
import org.wso2.andes.server.message.ServerMessage;
import org.wso2.andes.server.protocol.AMQConnectionModel;
import org.wso2.andes.server.protocol.AMQSessionModel;
import org.wso2.andes.server.queue.AMQQueue;
import org.wso2.andes.server.queue.BaseQueue;
import org.wso2.andes.server.queue.QueueEntry;
import org.wso2.andes.server.security.AuthorizationHolder;
import org.wso2.andes.server.store.MessageStore;
import org.wso2.andes.server.subscription.Subscription_0_10;
import org.wso2.andes.server.transport.ServerConnection;
import org.wso2.andes.server.txn.AutoCommitTransaction;
import org.wso2.andes.server.txn.LocalTransaction;
import org.wso2.andes.server.txn.ServerTransaction;
import org.wso2.andes.server.virtualhost.VirtualHost;
import org.wso2.andes.transport.Binary;
import org.wso2.andes.transport.Connection;
import org.wso2.andes.transport.MessageTransfer;
import org.wso2.andes.transport.Method;
import org.wso2.andes.transport.Range;
import org.wso2.andes.transport.RangeSet;
import org.wso2.andes.transport.Session;
import org.wso2.andes.transport.SessionDelegate;
import org.wso2.andes.util.Serial;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerSession
extends Session
implements AuthorizationHolder,
SessionConfig,
AMQSessionModel,
LogSubject {
    private static final Logger _logger = LoggerFactory.getLogger(ServerSession.class);
    private static final String NULL_DESTINTATION = UUID.randomUUID().toString();
    private final UUID _id;
    private ConnectionConfig _connectionConfig;
    private long _createTime = System.currentTimeMillis();
    private LogActor _actor = GenericActor.getInstance(this);
    private final SortedMap<Integer, MessageDispositionChangeListener> _messageDispositionListenerMap = new ConcurrentSkipListMap<Integer, MessageDispositionChangeListener>();
    private ServerTransaction _transaction;
    private final AtomicLong _txnStarts = new AtomicLong(0L);
    private final AtomicLong _txnCommits = new AtomicLong(0L);
    private final AtomicLong _txnRejects = new AtomicLong(0L);
    private final AtomicLong _txnCount = new AtomicLong(0L);
    private final AtomicLong _txnUpdateTime = new AtomicLong(0L);
    private Map<String, Subscription_0_10> _subscriptions = new ConcurrentHashMap<String, Subscription_0_10>();
    private final List<Task> _taskList = new CopyOnWriteArrayList<Task>();
    private final WeakReference<Session> _reference;

    ServerSession(Connection connection, SessionDelegate delegate, Binary name, long expiry) {
        this(connection, delegate, name, expiry, ((ServerConnection)connection).getConfig());
    }

    @Override
    protected void setState(Session.State state) {
        super.setState(state);
        if (state == Session.State.OPEN) {
            this._actor.message(ChannelMessages.CREATE());
        }
    }

    public ServerSession(Connection connection, SessionDelegate delegate, Binary name, long expiry, ConnectionConfig connConfig) {
        super(connection, delegate, name, expiry);
        this._connectionConfig = connConfig;
        this._transaction = new AutoCommitTransaction(this.getMessageStore());
        this._reference = new WeakReference<ServerSession>(this);
        this._id = this.getConfigStore().createId();
        this.getConfigStore().addConfiguredObject(this);
    }

    private ConfigStore getConfigStore() {
        return this.getConnectionConfig().getConfigStore();
    }

    @Override
    protected boolean isFull(int id) {
        return this.isCommandsFull(id);
    }

    public void enqueue(final ServerMessage message, final ArrayList<? extends BaseQueue> queues) {
        this.getConnectionModel().registerMessageReceived(message.getSize(), message.getArrivalTime());
        this._transaction.enqueue(queues, (EnqueableMessage)message, new ServerTransaction.Action(){
            BaseQueue[] _queues;
            {
                this._queues = queues.toArray(new BaseQueue[queues.size()]);
            }

            public void postCommit() {
                for (int i = 0; i < this._queues.length; ++i) {
                    try {
                        this._queues[i].enqueue(message);
                        continue;
                    }
                    catch (AMQException e) {
                        throw new RuntimeException(e);
                    }
                }
            }

            public void onRollback() {
            }
        });
        this.incrementOutstandingTxnsIfNecessary();
        this.updateTransactionalActivity();
    }

    public void sendMessage(MessageTransfer xfr, Runnable postIdSettingAction) {
        this.invoke((Method)xfr, postIdSettingAction);
        this.getConnectionModel().registerMessageDelivered(xfr.getBodySize());
    }

    public void onMessageDispositionChange(MessageTransfer xfr, MessageDispositionChangeListener acceptListener) {
        this._messageDispositionListenerMap.put(xfr.getId(), acceptListener);
    }

    public void accept(RangeSet ranges) {
        this.dispositionChange(ranges, new MessageDispositionAction(){

            public void performAction(MessageDispositionChangeListener listener) {
                listener.onAccept();
            }
        });
    }

    public void release(RangeSet ranges) {
        this.dispositionChange(ranges, new MessageDispositionAction(){

            public void performAction(MessageDispositionChangeListener listener) {
                listener.onRelease();
            }
        });
    }

    public void reject(RangeSet ranges) {
        this.dispositionChange(ranges, new MessageDispositionAction(){

            public void performAction(MessageDispositionChangeListener listener) {
                listener.onReject();
            }
        });
    }

    public RangeSet acquire(RangeSet transfers) {
        RangeSet acquired = new RangeSet();
        if (!this._messageDispositionListenerMap.isEmpty()) {
            Iterator<Integer> unacceptedMessages = this._messageDispositionListenerMap.keySet().iterator();
            Iterator<Range> rangeIter = transfers.iterator();
            if (rangeIter.hasNext()) {
                Range range = rangeIter.next();
                while (range != null && unacceptedMessages.hasNext()) {
                    MessageDispositionChangeListener changeListener;
                    int next = unacceptedMessages.next();
                    while (Serial.gt(next, range.getUpper())) {
                        if (rangeIter.hasNext()) {
                            range = rangeIter.next();
                            continue;
                        }
                        range = null;
                        break;
                    }
                    if (range == null || !range.includes(next) || (changeListener = (MessageDispositionChangeListener)this._messageDispositionListenerMap.get(next)) == null || !changeListener.acquire()) continue;
                    acquired.add(next);
                }
            }
        }
        return acquired;
    }

    public void dispositionChange(RangeSet ranges, MessageDispositionAction action) {
        if (ranges != null && !this._messageDispositionListenerMap.isEmpty()) {
            Iterator<Integer> unacceptedMessages = this._messageDispositionListenerMap.keySet().iterator();
            Iterator<Range> rangeIter = ranges.iterator();
            if (rangeIter.hasNext()) {
                Range range = rangeIter.next();
                while (range != null && unacceptedMessages.hasNext()) {
                    int next = unacceptedMessages.next();
                    while (Serial.gt(next, range.getUpper())) {
                        if (rangeIter.hasNext()) {
                            range = rangeIter.next();
                            continue;
                        }
                        range = null;
                        break;
                    }
                    if (range == null || !range.includes(next)) continue;
                    MessageDispositionChangeListener changeListener = (MessageDispositionChangeListener)this._messageDispositionListenerMap.remove(next);
                    action.performAction(changeListener);
                }
            }
        }
    }

    public void removeDispositionListener(Method method) {
        this._messageDispositionListenerMap.remove(method.getId());
    }

    public void onClose() {
        this._transaction.rollback();
        for (MessageDispositionChangeListener listener : this._messageDispositionListenerMap.values()) {
            listener.onRelease();
        }
        this._messageDispositionListenerMap.clear();
        this.getConfigStore().removeConfiguredObject(this);
        for (Task task : this._taskList) {
            task.doTask(this);
        }
        CurrentActor.get().message(this.getLogSubject(), ChannelMessages.CLOSE());
    }

    @Override
    protected void awaitClose() {
    }

    public void acknowledge(final Subscription_0_10 sub, final QueueEntry entry) {
        this._transaction.dequeue(entry.getQueue(), entry.getMessage(), new ServerTransaction.Action(){

            public void postCommit() {
                sub.acknowledge(entry);
            }

            public void onRollback() {
                entry.release();
            }
        });
        this.updateTransactionalActivity();
    }

    public Collection<Subscription_0_10> getSubscriptions() {
        return this._subscriptions.values();
    }

    public void register(String destination, Subscription_0_10 sub) {
        this._subscriptions.put(destination == null ? NULL_DESTINTATION : destination, sub);
    }

    public Subscription_0_10 getSubscription(String destination) {
        return this._subscriptions.get(destination == null ? NULL_DESTINTATION : destination);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(Subscription_0_10 sub) {
        this._subscriptions.remove(sub.getConsumerTag().toString());
        try {
            sub.getSendLock();
            AMQQueue queue = sub.getQueue();
            if (queue != null) {
                queue.unregisterSubscription(sub);
            }
        }
        catch (AMQException e) {
            _logger.error("Failed to unregister subscription", (Throwable)e);
        }
        finally {
            sub.releaseSendLock();
        }
    }

    @Override
    public boolean isTransactional() {
        return !(this._transaction instanceof AutoCommitTransaction);
    }

    public boolean inTransaction() {
        return this.isTransactional() && this._txnUpdateTime.get() > 0L && this._transaction.getTransactionStartTime() > 0L;
    }

    public void selectTx() {
        this._transaction = new LocalTransaction(this.getMessageStore());
        this._txnStarts.incrementAndGet();
    }

    public void commit() {
        this._transaction.commit();
        this._txnCommits.incrementAndGet();
        this._txnStarts.incrementAndGet();
        this.decrementOutstandingTxnsIfNecessary();
    }

    public void rollback() {
        this._transaction.rollback();
        this._txnRejects.incrementAndGet();
        this._txnStarts.incrementAndGet();
        this.decrementOutstandingTxnsIfNecessary();
    }

    private void incrementOutstandingTxnsIfNecessary() {
        if (this.isTransactional()) {
            this._txnCount.compareAndSet(0L, 1L);
        }
    }

    private void decrementOutstandingTxnsIfNecessary() {
        if (this.isTransactional()) {
            this._txnCount.compareAndSet(1L, 0L);
        }
    }

    public void updateTransactionalActivity() {
        if (this.isTransactional()) {
            this._txnUpdateTime.set(System.currentTimeMillis());
        }
    }

    @Override
    public Long getTxnStarts() {
        return this._txnStarts.get();
    }

    @Override
    public Long getTxnCommits() {
        return this._txnCommits.get();
    }

    @Override
    public Long getTxnRejects() {
        return this._txnRejects.get();
    }

    @Override
    public Long getTxnCount() {
        return this._txnCount.get();
    }

    @Override
    public Principal getAuthorizedPrincipal() {
        return ((ServerConnection)this.getConnection()).getAuthorizedPrincipal();
    }

    @Override
    public Subject getAuthorizedSubject() {
        return ((ServerConnection)this.getConnection()).getAuthorizedSubject();
    }

    public void addSessionCloseTask(Task task) {
        this._taskList.add(task);
    }

    public void removeSessionCloseTask(Task task) {
        this._taskList.remove(task);
    }

    public WeakReference<Session> getReference() {
        return this._reference;
    }

    public MessageStore getMessageStore() {
        return this.getVirtualHost().getMessageStore();
    }

    @Override
    public VirtualHost getVirtualHost() {
        return (VirtualHost)this._connectionConfig.getVirtualHost();
    }

    @Override
    public UUID getId() {
        return this._id;
    }

    @Override
    public SessionConfigType getConfigType() {
        return SessionConfigType.getInstance();
    }

    @Override
    public ConfiguredObject getParent() {
        return this.getVirtualHost();
    }

    @Override
    public boolean isDurable() {
        return false;
    }

    @Override
    public boolean isAttached() {
        return true;
    }

    @Override
    public long getDetachedLifespan() {
        return 0L;
    }

    @Override
    public Long getExpiryTime() {
        return null;
    }

    @Override
    public Long getMaxClientRate() {
        return null;
    }

    @Override
    public ConnectionConfig getConnectionConfig() {
        return this._connectionConfig;
    }

    @Override
    public String getSessionName() {
        return this.getName().toString();
    }

    @Override
    public long getCreateTime() {
        return this._createTime;
    }

    @Override
    public void mgmtClose() {
        this.close();
    }

    @Override
    public Object getID() {
        return this.getName();
    }

    @Override
    public AMQConnectionModel getConnectionModel() {
        return (ServerConnection)this.getConnection();
    }

    @Override
    public String getClientID() {
        return this.getConnection().getClientId();
    }

    public LogActor getLogActor() {
        return this._actor;
    }

    @Override
    public LogSubject getLogSubject() {
        return this;
    }

    @Override
    public void checkTransactionStatus(long openWarn, long openClose, long idleWarn, long idleClose) throws AMQException {
        if (this.inTransaction()) {
            long currentTime = System.currentTimeMillis();
            long openTime = currentTime - this._transaction.getTransactionStartTime();
            long idleTime = currentTime - this._txnUpdateTime.get();
            if (idleWarn > 0L && idleTime > idleWarn) {
                CurrentActor.get().message(this.getLogSubject(), ChannelMessages.IDLE_TXN(openTime));
                _logger.warn("IDLE TRANSACTION ALERT " + this.getLogSubject().toString() + " " + idleTime + " ms");
            } else if (openWarn > 0L && openTime > openWarn) {
                CurrentActor.get().message(this.getLogSubject(), ChannelMessages.OPEN_TXN(openTime));
                _logger.warn("OPEN TRANSACTION ALERT " + this.getLogSubject().toString() + " " + openTime + " ms");
            }
            if (idleClose > 0L && idleTime > idleClose) {
                this.getConnectionModel().closeSession(this, AMQConstant.RESOURCE_ERROR, "Idle transaction timed out");
            } else if (openClose > 0L && openTime > openClose) {
                this.getConnectionModel().closeSession(this, AMQConstant.RESOURCE_ERROR, "Open transaction timed out");
            }
        }
    }

    @Override
    public String toLogString() {
        return "[" + MessageFormat.format("con:{0}({1}@{2}/{3})/ch:{4}", this.getConnection().getConnectionId(), this.getClientID(), ((ProtocolEngine)((Object)this._connectionConfig)).getRemoteAddress().toString(), this.getVirtualHost().getName(), this.getChannel()) + "] ";
    }

    private static interface MessageDispositionAction {
        public void performAction(MessageDispositionChangeListener var1);
    }

    public static interface Task {
        public void doTask(ServerSession var1);
    }

    public static interface MessageDispositionChangeListener {
        public void onAccept();

        public void onRelease();

        public void onReject();

        public boolean acquire();
    }
}

