/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.subscription;

import java.nio.ByteBuffer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.wso2.andes.AMQException;
import org.wso2.andes.framing.AMQShortString;
import org.wso2.andes.framing.BasicContentHeaderProperties;
import org.wso2.andes.framing.FieldTable;
import org.wso2.andes.server.ClusterResourceHolder;
import org.wso2.andes.server.configuration.ConfigStore;
import org.wso2.andes.server.configuration.ConfiguredObject;
import org.wso2.andes.server.configuration.SessionConfig;
import org.wso2.andes.server.configuration.SubscriptionConfig;
import org.wso2.andes.server.configuration.SubscriptionConfigType;
import org.wso2.andes.server.filter.FilterManager;
import org.wso2.andes.server.flow.CreditCreditManager;
import org.wso2.andes.server.flow.FlowCreditManager;
import org.wso2.andes.server.flow.FlowCreditManager_0_10;
import org.wso2.andes.server.flow.WindowCreditManager;
import org.wso2.andes.server.logging.LogActor;
import org.wso2.andes.server.logging.LogSubject;
import org.wso2.andes.server.logging.actors.CurrentActor;
import org.wso2.andes.server.logging.actors.GenericActor;
import org.wso2.andes.server.logging.messages.SubscriptionMessages;
import org.wso2.andes.server.message.AMQMessage;
import org.wso2.andes.server.message.MessageTransferMessage;
import org.wso2.andes.server.message.ServerMessage;
import org.wso2.andes.server.queue.AMQQueue;
import org.wso2.andes.server.queue.QueueEntry;
import org.wso2.andes.server.subscription.ExplicitAcceptDispositionChangeListener;
import org.wso2.andes.server.subscription.ImplicitAcceptDispositionChangeListener;
import org.wso2.andes.server.subscription.MessageAcceptCompletionListener;
import org.wso2.andes.server.subscription.Subscription;
import org.wso2.andes.server.transport.ServerSession;
import org.wso2.andes.server.txn.AutoCommitTransaction;
import org.wso2.andes.server.txn.ServerTransaction;
import org.wso2.andes.transport.DeliveryProperties;
import org.wso2.andes.transport.Header;
import org.wso2.andes.transport.MessageAcceptMode;
import org.wso2.andes.transport.MessageAcquireMode;
import org.wso2.andes.transport.MessageCreditUnit;
import org.wso2.andes.transport.MessageDeliveryPriority;
import org.wso2.andes.transport.MessageFlowMode;
import org.wso2.andes.transport.MessageProperties;
import org.wso2.andes.transport.MessageTransfer;
import org.wso2.andes.transport.Method;
import org.wso2.andes.transport.Option;
import org.wso2.andes.transport.Struct;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Subscription_0_10
implements Subscription,
FlowCreditManager.FlowCreditManagerListener,
SubscriptionConfig,
LogSubject {
    private static final AtomicLong idGenerator = new AtomicLong(0L);
    private final long _subscriptionID = idGenerator.getAndIncrement();
    private final QueueEntry.SubscriptionAcquiredState _owningState = new QueueEntry.SubscriptionAcquiredState(this);
    private final QueueEntry.SubscriptionAssignedState _assignedState = new QueueEntry.SubscriptionAssignedState(this);
    private final Lock _stateChangeLock = new ReentrantLock();
    private final AtomicReference<Subscription.State> _state = new AtomicReference<Subscription.State>(Subscription.State.ACTIVE);
    private AMQQueue.Context _queueContext;
    private final AtomicBoolean _deleted = new AtomicBoolean(false);
    private FlowCreditManager_0_10 _creditManager;
    private Subscription.StateListener _stateListener = new Subscription.StateListener(){

        public void stateChange(Subscription sub, Subscription.State oldState, Subscription.State newState) {
            CurrentActor.get().message(SubscriptionMessages.STATE(newState.toString()));
        }
    };
    private AMQQueue _queue;
    private final String _destination;
    private boolean _noLocal;
    private final FilterManager _filters;
    private final MessageAcceptMode _acceptMode;
    private final MessageAcquireMode _acquireMode;
    private MessageFlowMode _flowMode;
    private final ServerSession _session;
    private AtomicBoolean _stopped = new AtomicBoolean(true);
    private ConcurrentHashMap<Integer, QueueEntry> _sentMap = new ConcurrentHashMap();
    private static final Struct[] EMPTY_STRUCT_ARRAY = new Struct[0];
    private LogActor _logActor;
    private Map<String, Object> _properties = new ConcurrentHashMap<String, Object>();
    private UUID _id;
    private String _traceExclude;
    private String _trace;
    private long _createTime = System.currentTimeMillis();
    private final AtomicLong _deliveredCount = new AtomicLong(0L);
    private final Map<String, Object> _arguments;
    private final AddMessageDispositionListnerAction _postIdSettingAction = new AddMessageDispositionListnerAction();

    public Subscription_0_10(ServerSession session, String destination, MessageAcceptMode acceptMode, MessageAcquireMode acquireMode, MessageFlowMode flowMode, FlowCreditManager_0_10 creditManager, FilterManager filters, Map<String, Object> arguments) {
        this._session = session;
        this._destination = destination;
        this._acceptMode = acceptMode;
        this._acquireMode = acquireMode;
        this._creditManager = creditManager;
        this._flowMode = flowMode;
        this._filters = filters;
        this._creditManager.addStateListener(this);
        this._arguments = arguments == null ? Collections.emptyMap() : Collections.unmodifiableMap(arguments);
        this._state.set(this._creditManager.hasCredit() ? Subscription.State.ACTIVE : Subscription.State.SUSPENDED);
    }

    @Override
    public void setNoLocal(boolean noLocal) {
        this._noLocal = noLocal;
    }

    @Override
    public AMQQueue getQueue() {
        return this._queue;
    }

    @Override
    public QueueEntry.SubscriptionAcquiredState getOwningState() {
        return this._owningState;
    }

    @Override
    public QueueEntry.SubscriptionAssignedState getAssignedState() {
        return this._assignedState;
    }

    @Override
    public void setQueue(AMQQueue queue, boolean exclusive) {
        if (this.getQueue() != null) {
            throw new IllegalStateException("Attempt to set queue for subscription " + this + " to " + queue + "when already set to " + this.getQueue());
        }
        this._queue = queue;
        Map<String, Object> arguments = queue.getArguments() == null ? Collections.EMPTY_MAP : queue.getArguments();
        this._traceExclude = (String)arguments.get("qpid.trace.exclude");
        this._trace = (String)arguments.get("qpid.trace.id");
        this._id = this.getConfigStore().createId();
        this.getConfigStore().addConfiguredObject(this);
        String filterLogString = null;
        this._logActor = GenericActor.getInstance(this);
        if (CurrentActor.get().getRootMessageLogger().isMessageEnabled(this._logActor, this, "qpid.message.subscription.create")) {
            filterLogString = this.getFilterLogString();
            CurrentActor.get().message(this, SubscriptionMessages.CREATE(filterLogString, queue.isDurable() && exclusive, filterLogString.length() > 0));
        }
    }

    @Override
    public AMQShortString getConsumerTag() {
        return new AMQShortString(this._destination);
    }

    @Override
    public boolean isSuspended() {
        return !this.isActive() || this._deleted.get();
    }

    @Override
    public boolean hasInterest(QueueEntry entry) {
        if (entry.isRejectedBy(this)) {
            return false;
        }
        if (this._noLocal && entry.getMessage() instanceof MessageTransferMessage && ((MessageTransferMessage)entry.getMessage()).getSession() == this._session) {
            return false;
        }
        return this.checkFilters(entry);
    }

    private boolean checkFilters(QueueEntry entry) {
        return this._filters == null || this._filters.allAllow(entry);
    }

    @Override
    public boolean isAutoClose() {
        return false;
    }

    @Override
    public boolean isClosed() {
        return this.getState() == Subscription.State.CLOSED;
    }

    public boolean isBrowser() {
        return this._acquireMode == MessageAcquireMode.NOT_ACQUIRED;
    }

    @Override
    public boolean seesRequeues() {
        return this._acquireMode != MessageAcquireMode.NOT_ACQUIRED || this._acceptMode == MessageAcceptMode.EXPLICIT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        boolean closed = false;
        Subscription.State state = this.getState();
        this._stateChangeLock.lock();
        try {
            while (!closed && state != Subscription.State.CLOSED) {
                closed = this._state.compareAndSet(state, Subscription.State.CLOSED);
                if (!closed) {
                    state = this.getState();
                    continue;
                }
                this._stateListener.stateChange(this, state, Subscription.State.CLOSED);
            }
            this._creditManager.removeListener(this);
            this.getConfigStore().removeConfiguredObject(this);
            CurrentActor.get().message(this.getLogSubject(), SubscriptionMessages.CLOSE());
        }
        finally {
            this._stateChangeLock.unlock();
        }
    }

    public ConfigStore getConfigStore() {
        return this.getQueue().getConfigStore();
    }

    @Override
    public Long getDelivered() {
        return this._deliveredCount.get();
    }

    @Override
    public void creditStateChanged(boolean hasCredit) {
        if (hasCredit) {
            if (this._state.compareAndSet(Subscription.State.SUSPENDED, Subscription.State.ACTIVE)) {
                this._stateListener.stateChange(this, Subscription.State.SUSPENDED, Subscription.State.ACTIVE);
            } else {
                this._stateListener.stateChange(this, Subscription.State.ACTIVE, Subscription.State.ACTIVE);
            }
        } else if (this._state.compareAndSet(Subscription.State.ACTIVE, Subscription.State.SUSPENDED)) {
            this._stateListener.stateChange(this, Subscription.State.ACTIVE, Subscription.State.SUSPENDED);
        }
    }

    @Override
    public void send(final QueueEntry entry) throws AMQException {
        MessageTransfer xfr;
        ServerMessage serverMsg = entry.getMessage();
        MessageProperties messageProps = null;
        if (serverMsg instanceof MessageTransferMessage) {
            MessageTransferMessage msg = (MessageTransferMessage)serverMsg;
            Struct[] headers = msg.getHeader() == null ? EMPTY_STRUCT_ARRAY : msg.getHeader().getStructs();
            ArrayList<Struct> newHeaders = new ArrayList<Struct>(headers.length);
            DeliveryProperties origDeliveryProps = null;
            for (Struct header : headers) {
                if (header instanceof DeliveryProperties) {
                    origDeliveryProps = (DeliveryProperties)header;
                    continue;
                }
                if (header instanceof MessageProperties) {
                    messageProps = (MessageProperties)header;
                }
                newHeaders.add(header);
            }
            DeliveryProperties deliveryProps = new DeliveryProperties();
            if (origDeliveryProps != null) {
                if (origDeliveryProps.hasDeliveryMode()) {
                    deliveryProps.setDeliveryMode(origDeliveryProps.getDeliveryMode());
                }
                if (origDeliveryProps.hasExchange()) {
                    deliveryProps.setExchange(origDeliveryProps.getExchange());
                }
                if (origDeliveryProps.hasExpiration()) {
                    deliveryProps.setExpiration(origDeliveryProps.getExpiration());
                }
                if (origDeliveryProps.hasPriority()) {
                    deliveryProps.setPriority(origDeliveryProps.getPriority());
                }
                if (origDeliveryProps.hasRoutingKey()) {
                    deliveryProps.setRoutingKey(origDeliveryProps.getRoutingKey());
                }
                if (origDeliveryProps.hasTimestamp()) {
                    deliveryProps.setTimestamp(origDeliveryProps.getTimestamp());
                }
            }
            deliveryProps.setRedelivered(entry.isRedelivered());
            newHeaders.add(deliveryProps);
            if (this._trace != null && messageProps == null) {
                messageProps = new MessageProperties();
                newHeaders.add(messageProps);
            }
            Header header = new Header(newHeaders);
            xfr = new MessageTransfer(this._destination, this._acceptMode, this._acquireMode, header, msg.getBody(), new Option[0]);
        } else if (serverMsg instanceof AMQMessage) {
            AMQMessage message_0_8 = (AMQMessage)serverMsg;
            DeliveryProperties deliveryProps = new DeliveryProperties();
            messageProps = new MessageProperties();
            int size = (int)message_0_8.getSize();
            ByteBuffer body = ByteBuffer.allocate(size);
            message_0_8.getContent(body, 0);
            body.flip();
            Struct[] headers = new Struct[]{deliveryProps, messageProps};
            BasicContentHeaderProperties properties = (BasicContentHeaderProperties)message_0_8.getContentHeaderBody().getProperties();
            AMQShortString exchange = message_0_8.getMessagePublishInfo().getExchange();
            if (exchange != null) {
                deliveryProps.setExchange(exchange.toString());
            }
            deliveryProps.setExpiration(message_0_8.getExpiration());
            deliveryProps.setImmediate(message_0_8.isImmediate());
            deliveryProps.setPriority(MessageDeliveryPriority.get(properties.getPriority()));
            deliveryProps.setRedelivered(entry.isRedelivered());
            deliveryProps.setRoutingKey(message_0_8.getRoutingKey());
            deliveryProps.setTimestamp(properties.getTimestamp());
            messageProps.setContentEncoding(properties.getEncodingAsString());
            messageProps.setContentLength(size);
            if (properties.getAppId() != null) {
                messageProps.setAppId(properties.getAppId().getBytes());
            }
            messageProps.setContentType(properties.getContentTypeAsString());
            if (properties.getCorrelationId() != null) {
                messageProps.setCorrelationId(properties.getCorrelationId().getBytes());
            }
            if (properties.getUserId() != null) {
                messageProps.setUserId(properties.getUserId().getBytes());
            }
            FieldTable fieldTable = properties.getHeaders();
            Map<String, Object> appHeaders = FieldTable.convertToMap(fieldTable);
            messageProps.setApplicationHeaders(appHeaders);
            Header header = new Header(headers);
            xfr = new MessageTransfer(this._destination, this._acceptMode, this._acquireMode, header, body, new Option[0]);
        } else {
            DeliveryProperties deliveryProps = new DeliveryProperties();
            messageProps = new MessageProperties();
            int size = (int)serverMsg.getSize();
            ByteBuffer body = ByteBuffer.allocate(size);
            serverMsg.getContent(body, 0);
            body.flip();
            Struct[] headers = new Struct[]{deliveryProps, messageProps};
            deliveryProps.setExpiration(serverMsg.getExpiration());
            deliveryProps.setImmediate(serverMsg.isImmediate());
            deliveryProps.setPriority(MessageDeliveryPriority.get(serverMsg.getMessageHeader().getPriority()));
            deliveryProps.setRedelivered(entry.isRedelivered());
            deliveryProps.setRoutingKey(serverMsg.getRoutingKey());
            deliveryProps.setTimestamp(serverMsg.getMessageHeader().getTimestamp());
            messageProps.setContentEncoding(serverMsg.getMessageHeader().getEncoding());
            messageProps.setContentLength(size);
            messageProps.setContentType(serverMsg.getMessageHeader().getMimeType());
            if (serverMsg.getMessageHeader().getCorrelationId() != null) {
                messageProps.setCorrelationId(serverMsg.getMessageHeader().getCorrelationId().getBytes());
            }
            HashMap appHeaders = new HashMap();
            Header header = new Header(headers);
            xfr = new MessageTransfer(this._destination, this._acceptMode, this._acquireMode, header, body, new Option[0]);
        }
        boolean excludeDueToFederation = false;
        if (this._trace != null) {
            Map<String, Object> appHeaders;
            String trace;
            if (!messageProps.hasApplicationHeaders()) {
                messageProps.setApplicationHeaders(new HashMap<String, Object>());
            }
            if ((trace = (String)(appHeaders = messageProps.getApplicationHeaders()).get("x-qpid.trace")) == null) {
                trace = this._trace;
            } else {
                if (this._traceExclude != null) {
                    excludeDueToFederation = Arrays.asList(trace.split(",")).contains(this._traceExclude);
                }
                trace = trace + "," + this._trace;
            }
            appHeaders.put("x-qpid.trace", trace);
        }
        if (!excludeDueToFederation) {
            if (this._acceptMode == MessageAcceptMode.NONE && this._acquireMode != MessageAcquireMode.PRE_ACQUIRED) {
                xfr.setCompletionListener(new MessageAcceptCompletionListener(this, this._session, entry, this._flowMode == MessageFlowMode.WINDOW));
            } else if (this._flowMode == MessageFlowMode.WINDOW) {
                xfr.setCompletionListener(new Method.CompletionListener(){

                    public void onComplete(Method method) {
                        Subscription_0_10.this.restoreCredit(entry);
                    }
                });
            }
            this._postIdSettingAction._xfr = xfr;
            this._postIdSettingAction._action = this._acceptMode == MessageAcceptMode.EXPLICIT ? new ExplicitAcceptDispositionChangeListener(entry, this) : (this._acquireMode != MessageAcquireMode.PRE_ACQUIRED ? new ImplicitAcceptDispositionChangeListener(entry, this) : null);
            this._session.sendMessage(xfr, this._postIdSettingAction);
            this._deliveredCount.incrementAndGet();
            if (this._acceptMode == MessageAcceptMode.NONE && this._acquireMode == MessageAcquireMode.PRE_ACQUIRED) {
                this.forceDequeue(entry, false);
            }
        } else {
            this.forceDequeue(entry, this._flowMode == MessageFlowMode.WINDOW);
        }
    }

    private void forceDequeue(final QueueEntry entry, final boolean restoreCredit) {
        AutoCommitTransaction txn = new AutoCommitTransaction(this.getQueue().getVirtualHost().getTransactionLog());
        txn.dequeue(entry.getQueue(), entry.getMessage(), new ServerTransaction.Action(){

            public void postCommit() {
                if (restoreCredit) {
                    Subscription_0_10.this.restoreCredit(entry);
                }
                entry.discard();
            }

            public void onRollback() {
            }
        });
    }

    void reject(QueueEntry entry) {
        entry.setRedelivered();
        entry.routeToAlternate();
    }

    void release(QueueEntry entry) {
        entry.setRedelivered();
        entry.release();
    }

    @Override
    public void queueDeleted(AMQQueue queue) {
        this._deleted.set(true);
    }

    @Override
    public boolean wouldSuspend(QueueEntry msg) {
        return !this._creditManager.useCreditForMessage(msg.getMessage());
    }

    @Override
    public void getSendLock() {
        this._stateChangeLock.lock();
    }

    @Override
    public void releaseSendLock() {
        this._stateChangeLock.unlock();
    }

    @Override
    public void restoreCredit(QueueEntry queueEntry) {
        this._creditManager.restoreCredit(1L, queueEntry.getSize());
    }

    @Override
    public void onDequeue(QueueEntry queueEntry) {
        ClusterResourceHolder.getInstance().getCassandraMessageStore().addAckedMessage(queueEntry.getMessage().getMessageNumber());
    }

    @Override
    public void setStateListener(Subscription.StateListener listener) {
        this._stateListener = listener;
    }

    @Override
    public Subscription.State getState() {
        return this._state.get();
    }

    @Override
    public AMQQueue.Context getQueueContext() {
        return this._queueContext;
    }

    @Override
    public void setQueueContext(AMQQueue.Context queueContext) {
        this._queueContext = queueContext;
    }

    @Override
    public boolean isActive() {
        return this.getState() == Subscription.State.ACTIVE;
    }

    @Override
    public void confirmAutoClose() {
    }

    @Override
    public void set(String key, Object value) {
        this._properties.put(key, value);
    }

    @Override
    public Object get(String key) {
        return this._properties.get(key);
    }

    public FlowCreditManager_0_10 getCreditManager() {
        return this._creditManager;
    }

    public void stop() {
        if (this._state.compareAndSet(Subscription.State.ACTIVE, Subscription.State.SUSPENDED)) {
            this._stateListener.stateChange(this, Subscription.State.ACTIVE, Subscription.State.SUSPENDED);
        }
        this._stopped.set(true);
        FlowCreditManager_0_10 creditManager = this.getCreditManager();
        creditManager.clearCredit();
    }

    public void addCredit(MessageCreditUnit unit, long value) {
        FlowCreditManager_0_10 creditManager = this.getCreditManager();
        switch (unit) {
            case MESSAGE: {
                creditManager.addCredit(value, 0L);
                break;
            }
            case BYTE: {
                creditManager.addCredit(0L, value);
            }
        }
        this._stopped.set(false);
        if (creditManager.hasCredit() && this._state.compareAndSet(Subscription.State.SUSPENDED, Subscription.State.ACTIVE)) {
            this._stateListener.stateChange(this, Subscription.State.SUSPENDED, Subscription.State.ACTIVE);
        }
    }

    public void setFlowMode(MessageFlowMode flowMode) {
        this._creditManager.removeListener(this);
        switch (flowMode) {
            case CREDIT: {
                this._creditManager = new CreditCreditManager(0L, 0L);
                break;
            }
            case WINDOW: {
                this._creditManager = new WindowCreditManager(0L, 0L);
                break;
            }
            default: {
                throw new RuntimeException("Unknown message flow mode: " + (Object)((Object)flowMode));
            }
        }
        this._flowMode = flowMode;
        if (this._state.compareAndSet(Subscription.State.ACTIVE, Subscription.State.SUSPENDED)) {
            this._stateListener.stateChange(this, Subscription.State.ACTIVE, Subscription.State.SUSPENDED);
        }
        this._creditManager.addStateListener(this);
    }

    public boolean isStopped() {
        return this._stopped.get();
    }

    @Override
    public boolean acquires() {
        return this._acquireMode == MessageAcquireMode.PRE_ACQUIRED;
    }

    public void acknowledge(QueueEntry entry) {
        if (entry.isAcquiredBy(this)) {
            entry.discard();
        }
    }

    public void flush() throws AMQException {
        this._queue.flushSubscription(this);
        this.stop();
    }

    @Override
    public long getSubscriptionID() {
        return this._subscriptionID;
    }

    @Override
    public LogActor getLogActor() {
        return this._logActor;
    }

    @Override
    public boolean isTransient() {
        return false;
    }

    ServerSession getSession() {
        return this._session;
    }

    @Override
    public SessionConfig getSessionConfig() {
        return this.getSession();
    }

    @Override
    public boolean isBrowsing() {
        return this._acquireMode == MessageAcquireMode.NOT_ACQUIRED;
    }

    @Override
    public boolean isExclusive() {
        return this.getQueue().hasExclusiveSubscriber();
    }

    @Override
    public ConfiguredObject getParent() {
        return this.getSessionConfig();
    }

    @Override
    public boolean isDurable() {
        return false;
    }

    @Override
    public SubscriptionConfigType getConfigType() {
        return SubscriptionConfigType.getInstance();
    }

    @Override
    public boolean isExplicitAcknowledge() {
        return this._acceptMode == MessageAcceptMode.EXPLICIT;
    }

    @Override
    public String getCreditMode() {
        return this._flowMode.toString();
    }

    @Override
    public UUID getId() {
        return this._id;
    }

    @Override
    public String getName() {
        return this._destination;
    }

    @Override
    public Map<String, Object> getArguments() {
        return this._arguments;
    }

    @Override
    public boolean isSessionTransactional() {
        return this._session.isTransactional();
    }

    @Override
    public long getCreateTime() {
        return this._createTime;
    }

    @Override
    public String toLogString() {
        String queueInfo = MessageFormat.format("vh(/{0})/qu({1})", this._queue.getVirtualHost().getName(), this._queue.getNameShortString());
        String result = "[" + MessageFormat.format("sub:{0}", this.getSubscriptionID()) + "(" + queueInfo.substring(0, queueInfo.length() - 1) + ")" + "] ";
        return result;
    }

    private String getFilterLogString() {
        StringBuilder filterLogString = new StringBuilder();
        String delimiter = ", ";
        boolean hasEntries = false;
        if (this._filters != null && this._filters.hasFilters()) {
            filterLogString.append(this._filters.toString());
            hasEntries = true;
        }
        if (this.isBrowser()) {
            if (hasEntries) {
                filterLogString.append(delimiter);
            }
            filterLogString.append("Browser");
            hasEntries = true;
        }
        if (this.isDurable()) {
            if (hasEntries) {
                filterLogString.append(delimiter);
            }
            filterLogString.append("Durable");
            hasEntries = true;
        }
        return filterLogString.toString();
    }

    public LogSubject getLogSubject() {
        return this;
    }

    private class AddMessageDispositionListnerAction
    implements Runnable {
        public MessageTransfer _xfr;
        public ServerSession.MessageDispositionChangeListener _action;

        private AddMessageDispositionListnerAction() {
        }

        public void run() {
            if (this._action != null) {
                Subscription_0_10.this._session.onMessageDispositionChange(this._xfr, this._action);
            }
        }
    }
}

