/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.security.auth.rmi;

import javax.management.remote.JMXAuthenticator;
import javax.management.remote.JMXPrincipal;
import javax.security.auth.Subject;
import org.wso2.andes.server.security.auth.AuthenticationResult;
import org.wso2.andes.server.security.auth.manager.AuthenticationManager;

public class RMIPasswordAuthenticator
implements JMXAuthenticator {
    static final String UNABLE_TO_LOOKUP = "The broker was unable to lookup the user details";
    static final String SHOULD_BE_STRING_ARRAY = "User details should be String[]";
    static final String SHOULD_HAVE_2_ELEMENTS = "User details should have 2 elements, username, password";
    static final String SHOULD_BE_NON_NULL = "Supplied username and password should be non-null";
    static final String INVALID_CREDENTIALS = "Invalid user details supplied";
    static final String CREDENTIALS_REQUIRED = "User details are required. Please ensure you are using an up to date management console to connect.";
    private AuthenticationManager _authenticationManager = null;

    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this._authenticationManager = authenticationManager;
    }

    public Subject authenticate(Object credentials) throws SecurityException {
        if (!(credentials instanceof String[])) {
            if (credentials == null) {
                throw new SecurityException(CREDENTIALS_REQUIRED);
            }
            throw new SecurityException(SHOULD_BE_STRING_ARRAY);
        }
        String[] userCredentials = (String[])credentials;
        if (userCredentials.length != 2) {
            throw new SecurityException(SHOULD_HAVE_2_ELEMENTS);
        }
        String username = userCredentials[0];
        String password = userCredentials[1];
        if (username == null || password == null) {
            throw new SecurityException(SHOULD_BE_NON_NULL);
        }
        if (this._authenticationManager == null) {
            throw new SecurityException(UNABLE_TO_LOOKUP);
        }
        AuthenticationResult result = this._authenticationManager.authenticate(username, password);
        if (AuthenticationResult.AuthenticationStatus.ERROR.equals((Object)result.getStatus())) {
            throw new SecurityException("Authentication manager failed", result.getCause());
        }
        if (AuthenticationResult.AuthenticationStatus.SUCCESS.equals((Object)result.getStatus())) {
            Subject subject = result.getSubject();
            subject.getPrincipals().add(new JMXPrincipal(username));
            subject.setReadOnly();
            return subject;
        }
        throw new SecurityException(INVALID_CREDENTIALS);
    }
}

