/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.security.auth.database;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.security.Principal;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.AccountNotFoundException;
import org.apache.log4j.Logger;
import org.wso2.andes.server.security.auth.database.PlainUser;
import org.wso2.andes.server.security.auth.database.PrincipalDatabase;
import org.wso2.andes.server.security.auth.sasl.AuthenticationProviderInitialiser;
import org.wso2.andes.server.security.auth.sasl.UsernamePrincipal;
import org.wso2.andes.server.security.auth.sasl.amqplain.AmqPlainInitialiser;
import org.wso2.andes.server.security.auth.sasl.crammd5.CRAMMD5Initialiser;
import org.wso2.andes.server.security.auth.sasl.plain.PlainInitialiser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlainPasswordFilePrincipalDatabase
implements PrincipalDatabase {
    public static final String DEFAULT_ENCODING = "utf-8";
    private static final Logger _logger = Logger.getLogger(PlainPasswordFilePrincipalDatabase.class);
    private File _passwordFile;
    private Pattern _regexp = Pattern.compile(":");
    private Map<String, AuthenticationProviderInitialiser> _saslServers;
    private Map<String, PlainUser> _users = new HashMap<String, PlainUser>();
    private ReentrantLock _userUpdate = new ReentrantLock();

    public PlainPasswordFilePrincipalDatabase() {
        this._saslServers = new HashMap<String, AuthenticationProviderInitialiser>();
        AmqPlainInitialiser amqplain = new AmqPlainInitialiser();
        amqplain.initialise(this);
        PlainInitialiser plain = new PlainInitialiser();
        plain.initialise(this);
        CRAMMD5Initialiser cram = new CRAMMD5Initialiser();
        cram.initialise(this);
        this._saslServers.put(amqplain.getMechanismName(), amqplain);
        this._saslServers.put(plain.getMechanismName(), plain);
        this._saslServers.put(cram.getMechanismName(), cram);
    }

    public void setPasswordFile(String passwordFile) throws IOException {
        File f = new File(passwordFile);
        _logger.info((Object)("PlainPasswordFile using file " + f.getAbsolutePath()));
        this._passwordFile = f;
        if (!f.exists()) {
            throw new FileNotFoundException("Cannot find password file " + f);
        }
        if (!f.canRead()) {
            throw new FileNotFoundException("Cannot read password file " + f + ". Check permissions.");
        }
        this.loadPasswordFile();
    }

    @Override
    public void setPassword(Principal principal, PasswordCallback callback) throws AccountNotFoundException {
        if (this._passwordFile == null) {
            throw new AccountNotFoundException("Unable to locate principal since no password file was specified during initialisation");
        }
        if (principal == null) {
            throw new IllegalArgumentException("principal must not be null");
        }
        char[] pwd = this.lookupPassword(principal.getName());
        if (pwd == null) {
            throw new AccountNotFoundException("No account found for principal " + principal);
        }
        callback.setPassword(pwd);
    }

    @Override
    public boolean verifyPassword(String principal, char[] password) throws AccountNotFoundException {
        char[] pwd = this.lookupPassword(principal);
        if (pwd == null) {
            throw new AccountNotFoundException("Unable to lookup the specfied users password");
        }
        return this.compareCharArray(pwd, password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updatePassword(Principal principal, char[] password) throws AccountNotFoundException {
        PlainUser user = this._users.get(principal.getName());
        if (user == null) {
            throw new AccountNotFoundException(principal.getName());
        }
        char[] orig = user.getPassword();
        this._userUpdate.lock();
        try {
            user.setPassword(password);
            this.savePasswordFile();
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            _logger.error((Object)("Unable to save password file due to '" + e.getMessage() + "', password change for user '" + principal + "' discarded"));
            user.setPassword(orig);
            boolean bl = false;
            return bl;
        }
        finally {
            this._userUpdate.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean createPrincipal(Principal principal, char[] password) {
        if (this._users.get(principal.getName()) != null) {
            return false;
        }
        PlainUser user = new PlainUser(principal.getName(), password);
        try {
            this._userUpdate.lock();
            this._users.put(user.getName(), user);
            try {
                this.savePasswordFile();
                boolean bl = true;
                return bl;
            }
            catch (IOException e) {
                this._users.remove(user.getName());
                _logger.warn((Object)("Unable to create user '" + user.getName()));
                boolean bl = false;
                this._userUpdate.unlock();
                return bl;
            }
        }
        finally {
            this._userUpdate.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deletePrincipal(Principal principal) throws AccountNotFoundException {
        PlainUser user = this._users.get(principal.getName());
        if (user == null) {
            throw new AccountNotFoundException(principal.getName());
        }
        try {
            this._userUpdate.lock();
            user.delete();
            try {
                this.savePasswordFile();
            }
            catch (IOException e) {
                _logger.error((Object)("Unable to remove user '" + user.getName() + "' from password file."));
                boolean bl = false;
                this._userUpdate.unlock();
                return bl;
            }
            this._users.remove(user.getName());
        }
        finally {
            this._userUpdate.unlock();
        }
        return true;
    }

    @Override
    public Map<String, AuthenticationProviderInitialiser> getMechanisms() {
        return this._saslServers;
    }

    @Override
    public List<Principal> getUsers() {
        return new LinkedList<Principal>(this._users.values());
    }

    @Override
    public Principal getUser(String username) {
        if (this._users.containsKey(username)) {
            return new UsernamePrincipal(username);
        }
        return null;
    }

    private boolean compareCharArray(char[] a, char[] b) {
        boolean equal = false;
        if (a.length == b.length) {
            equal = true;
            for (int index = 0; equal && index < a.length; ++index) {
                equal = a[index] == b[index];
            }
        }
        return equal;
    }

    private char[] lookupPassword(String name) {
        PlainUser user = this._users.get(name);
        if (user == null) {
            return null;
        }
        return user.getPassword();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPasswordFile() throws IOException {
        try {
            this._userUpdate.lock();
            this._users.clear();
            BufferedReader reader = null;
            try {
                String line;
                reader = new BufferedReader(new FileReader(this._passwordFile));
                while ((line = reader.readLine()) != null) {
                    String[] result = this._regexp.split(line);
                    if (result == null || result.length < 2 || result[0].startsWith("#")) continue;
                    PlainUser user = new PlainUser(result);
                    _logger.info((Object)("Created user:" + user));
                    this._users.put(user.getName(), user);
                }
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
        finally {
            this._userUpdate.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void savePasswordFile() throws IOException {
        try {
            File tmp;
            this._userUpdate.lock();
            BufferedReader reader = null;
            PrintStream writer = null;
            Random r = new Random();
            while ((tmp = new File(this._passwordFile.getPath() + r.nextInt() + ".tmp")).exists()) {
            }
            tmp.deleteOnExit();
            try {
                byte[] password;
                String line;
                writer = new PrintStream(tmp);
                reader = new BufferedReader(new FileReader(this._passwordFile));
                while ((line = reader.readLine()) != null) {
                    String[] result = this._regexp.split(line);
                    if (result == null || result.length < 2 || result[0].startsWith("#")) {
                        writer.write(line.getBytes(DEFAULT_ENCODING));
                        writer.println();
                        continue;
                    }
                    PlainUser user = this._users.get(result[0]);
                    if (user == null) {
                        writer.write(line.getBytes(DEFAULT_ENCODING));
                        writer.println();
                        continue;
                    }
                    if (user.isDeleted()) continue;
                    if (!user.isModified()) {
                        writer.write(line.getBytes(DEFAULT_ENCODING));
                        writer.println();
                        continue;
                    }
                    password = user.getPasswordBytes();
                    writer.write((user.getName() + ":").getBytes(DEFAULT_ENCODING));
                    writer.write(password);
                    writer.println();
                    user.saved();
                }
                for (PlainUser user : this._users.values()) {
                    if (!user.isModified()) continue;
                    password = user.getPasswordBytes();
                    writer.write((user.getName() + ":").getBytes(DEFAULT_ENCODING));
                    writer.write(password);
                    writer.println();
                    user.saved();
                }
            }
            catch (IOException e) {
                _logger.error((Object)("Unable to create the new password file: " + e));
                throw new IOException("Unable to create the new password file" + e);
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
                if (writer != null) {
                    writer.close();
                }
            }
            File old = new File(this._passwordFile.getAbsoluteFile() + ".old");
            if (old.exists()) {
                old.delete();
            }
            if (!this._passwordFile.renameTo(old)) {
                _logger.error((Object)"Could not backup the existing password file");
                throw new IOException("Could not backup the existing password file");
            }
            if (!tmp.renameTo(this._passwordFile)) {
                if (!old.renameTo(this._passwordFile)) {
                    _logger.error((Object)"Could not rename the new password file into place, and unable to restore original file");
                    throw new IOException("Could not rename the new password file into place, and unable to restore original file");
                }
                _logger.error((Object)"Could not rename the new password file into place");
                throw new IOException("Could not rename the new password file into place");
            }
        }
        finally {
            this._userUpdate.unlock();
        }
    }

    @Override
    public void reload() throws IOException {
        this.loadPasswordFile();
    }
}

