/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.handler;

import org.apache.log4j.Logger;
import org.wso2.andes.AMQException;
import org.wso2.andes.framing.ConnectionCloseOkBody;
import org.wso2.andes.server.protocol.AMQProtocolSession;
import org.wso2.andes.server.state.AMQState;
import org.wso2.andes.server.state.AMQStateManager;
import org.wso2.andes.server.state.StateAwareMethodListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionCloseOkMethodHandler
implements StateAwareMethodListener<ConnectionCloseOkBody> {
    private static final Logger _logger = Logger.getLogger(ConnectionCloseOkMethodHandler.class);
    private static ConnectionCloseOkMethodHandler _instance = new ConnectionCloseOkMethodHandler();

    public static ConnectionCloseOkMethodHandler getInstance() {
        return _instance;
    }

    private ConnectionCloseOkMethodHandler() {
    }

    @Override
    public void methodReceived(AMQStateManager stateManager, ConnectionCloseOkBody body, int channelId) throws AMQException {
        AMQProtocolSession session = stateManager.getProtocolSession();
        _logger.info((Object)"Received Connection-close-ok");
        try {
            stateManager.changeState(AMQState.CONNECTION_CLOSED);
            session.closeSession();
        }
        catch (Exception e) {
            _logger.error((Object)("Error closing protocol session: " + e), (Throwable)e);
        }
    }
}

