/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.handler;

import org.apache.log4j.Logger;
import org.wso2.andes.AMQException;
import org.wso2.andes.framing.ChannelFlowBody;
import org.wso2.andes.framing.ChannelFlowOkBody;
import org.wso2.andes.framing.MethodRegistry;
import org.wso2.andes.server.AMQChannel;
import org.wso2.andes.server.protocol.AMQProtocolSession;
import org.wso2.andes.server.state.AMQStateManager;
import org.wso2.andes.server.state.StateAwareMethodListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChannelFlowHandler
implements StateAwareMethodListener<ChannelFlowBody> {
    private static final Logger _logger = Logger.getLogger(ChannelFlowHandler.class);
    private static ChannelFlowHandler _instance = new ChannelFlowHandler();

    public static ChannelFlowHandler getInstance() {
        return _instance;
    }

    private ChannelFlowHandler() {
    }

    @Override
    public void methodReceived(AMQStateManager stateManager, ChannelFlowBody body, int channelId) throws AMQException {
        AMQProtocolSession session = stateManager.getProtocolSession();
        AMQChannel channel = session.getChannel(channelId);
        if (channel == null) {
            throw body.getChannelNotFoundException(channelId);
        }
        channel.setSuspended(!body.getActive());
        _logger.debug((Object)("Channel.Flow for channel " + channelId + ", active=" + body.getActive()));
        MethodRegistry methodRegistry = session.getMethodRegistry();
        ChannelFlowOkBody responseBody = methodRegistry.createChannelFlowOkBody(body.getActive());
        session.writeFrame(responseBody.generateFrame(channelId));
    }
}

