/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.handler;

import org.apache.log4j.Logger;
import org.wso2.andes.AMQException;
import org.wso2.andes.framing.ChannelCloseBody;
import org.wso2.andes.framing.ChannelCloseOkBody;
import org.wso2.andes.framing.MethodRegistry;
import org.wso2.andes.protocol.AMQConstant;
import org.wso2.andes.server.AMQChannel;
import org.wso2.andes.server.protocol.AMQProtocolSession;
import org.wso2.andes.server.state.AMQStateManager;
import org.wso2.andes.server.state.StateAwareMethodListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChannelCloseHandler
implements StateAwareMethodListener<ChannelCloseBody> {
    private static final Logger _logger = Logger.getLogger(ChannelCloseHandler.class);
    private static ChannelCloseHandler _instance = new ChannelCloseHandler();

    public static ChannelCloseHandler getInstance() {
        return _instance;
    }

    private ChannelCloseHandler() {
    }

    @Override
    public void methodReceived(AMQStateManager stateManager, ChannelCloseBody body, int channelId) throws AMQException {
        AMQChannel channel;
        AMQProtocolSession session = stateManager.getProtocolSession();
        if (_logger.isInfoEnabled()) {
            _logger.info((Object)("Received channel close for id " + channelId + " citing class " + body.getClassId() + " and method " + body.getMethodId()));
        }
        if ((channel = session.getChannel(channelId)) == null) {
            throw body.getConnectionException(AMQConstant.CHANNEL_ERROR, "Trying to close unknown channel");
        }
        session.closeChannel(channelId);
        stateManager.getProtocolSession().closeChannelOk(channelId);
        MethodRegistry methodRegistry = session.getMethodRegistry();
        ChannelCloseOkBody responseBody = methodRegistry.createChannelCloseOkBody();
        session.writeFrame(responseBody.generateFrame(channelId));
    }
}

