/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.handler;

import org.apache.log4j.Logger;
import org.wso2.andes.AMQException;
import org.wso2.andes.framing.AMQShortString;
import org.wso2.andes.framing.BasicGetBody;
import org.wso2.andes.framing.BasicGetEmptyBody;
import org.wso2.andes.framing.FieldTable;
import org.wso2.andes.framing.MethodRegistry;
import org.wso2.andes.protocol.AMQConstant;
import org.wso2.andes.server.AMQChannel;
import org.wso2.andes.server.flow.FlowCreditManager;
import org.wso2.andes.server.flow.MessageOnlyCreditManager;
import org.wso2.andes.server.message.AMQMessage;
import org.wso2.andes.server.protocol.AMQProtocolSession;
import org.wso2.andes.server.protocol.AMQSessionModel;
import org.wso2.andes.server.queue.AMQQueue;
import org.wso2.andes.server.queue.QueueEntry;
import org.wso2.andes.server.state.AMQStateManager;
import org.wso2.andes.server.state.StateAwareMethodListener;
import org.wso2.andes.server.subscription.ClientDeliveryMethod;
import org.wso2.andes.server.subscription.RecordDeliveryMethod;
import org.wso2.andes.server.subscription.Subscription;
import org.wso2.andes.server.subscription.SubscriptionFactoryImpl;
import org.wso2.andes.server.subscription.SubscriptionImpl;
import org.wso2.andes.server.virtualhost.VirtualHost;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicGetMethodHandler
implements StateAwareMethodListener<BasicGetBody> {
    private static final Logger _log = Logger.getLogger(BasicGetMethodHandler.class);
    private static final BasicGetMethodHandler _instance = new BasicGetMethodHandler();

    public static BasicGetMethodHandler getInstance() {
        return _instance;
    }

    private BasicGetMethodHandler() {
    }

    @Override
    public void methodReceived(AMQStateManager stateManager, BasicGetBody body, int channelId) throws AMQException {
        AMQSessionModel session;
        AMQQueue queue;
        AMQProtocolSession protocolConnection = stateManager.getProtocolSession();
        VirtualHost vHost = protocolConnection.getVirtualHost();
        AMQChannel channel = protocolConnection.getChannel(channelId);
        if (channel == null) {
            throw body.getChannelNotFoundException(channelId);
        }
        AMQQueue aMQQueue = queue = body.getQueue() == null ? channel.getDefaultQueue() : vHost.getQueueRegistry().getQueue(body.getQueue());
        if (queue == null) {
            _log.info((Object)("No queue for '" + body.getQueue() + "'"));
            if (body.getQueue() != null) {
                throw body.getConnectionException(AMQConstant.NOT_FOUND, "No such queue, '" + body.getQueue() + "'");
            }
            throw body.getConnectionException(AMQConstant.NOT_ALLOWED, "No queue name provided, no default queue defined.");
        }
        if (queue.isExclusive() && ((session = queue.getExclusiveOwningSession()) == null || session.getConnectionModel() != protocolConnection)) {
            throw body.getConnectionException(AMQConstant.NOT_ALLOWED, "Queue is exclusive, but not created on this Connection.");
        }
        if (!BasicGetMethodHandler.performGet(queue, protocolConnection, channel, !body.getNoAck())) {
            MethodRegistry methodRegistry = protocolConnection.getMethodRegistry();
            BasicGetEmptyBody responseBody = methodRegistry.createBasicGetEmptyBody(null);
            protocolConnection.writeFrame(responseBody.generateFrame(channelId));
        }
    }

    public static boolean performGet(final AMQQueue queue, final AMQProtocolSession session, final AMQChannel channel, boolean acks) throws AMQException {
        final MessageOnlyCreditManager singleMessageCredit = new MessageOnlyCreditManager(1L);
        ClientDeliveryMethod getDeliveryMethod = new ClientDeliveryMethod(){
            int _msg;

            public void deliverToClient(Subscription sub, QueueEntry entry, long deliveryTag) throws AMQException {
                singleMessageCredit.useCreditForMessage(entry.getMessage());
                if (!(entry.getMessage() instanceof AMQMessage)) {
                    throw new AMQException(AMQConstant.NOT_IMPLEMENTED, "Not implemented conversion of 0-10 message", null);
                }
                session.getProtocolOutputConverter().writeGetOk(entry, channel.getChannelId(), deliveryTag, queue.getMessageCount());
            }
        };
        RecordDeliveryMethod getRecordMethod = new RecordDeliveryMethod(){

            public void recordMessageDelivery(Subscription sub, QueueEntry entry, long deliveryTag) {
                channel.addUnacknowledgedMessage(entry, deliveryTag, null);
            }
        };
        Subscription sub = acks ? SubscriptionFactoryImpl.INSTANCE.createSubscription(channel, session, null, acks, null, false, singleMessageCredit, getDeliveryMethod, getRecordMethod) : new GetNoAckSubscription(channel, session, null, null, false, singleMessageCredit, getDeliveryMethod, getRecordMethod);
        queue.registerSubscription(sub, false);
        queue.flushSubscription(sub);
        queue.unregisterSubscription(sub);
        return !singleMessageCredit.hasCredit();
    }

    public static final class GetNoAckSubscription
    extends SubscriptionImpl.NoAckSubscription {
        public GetNoAckSubscription(AMQChannel channel, AMQProtocolSession protocolSession, AMQShortString consumerTag, FieldTable filters, boolean noLocal, FlowCreditManager creditManager, ClientDeliveryMethod deliveryMethod, RecordDeliveryMethod recordMethod) throws AMQException {
            super(channel, protocolSession, consumerTag, filters, noLocal, creditManager, deliveryMethod, recordMethod);
        }

        public boolean isTransient() {
            return true;
        }

        public boolean wouldSuspend(QueueEntry msg) {
            return !this.getCreditManager().useCreditForMessage(msg.getMessage());
        }
    }
}

