/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.flow;

import org.wso2.andes.server.flow.AbstractFlowCreditManager;
import org.wso2.andes.server.flow.FlowCreditManager_0_10;
import org.wso2.andes.server.message.ServerMessage;

public class WindowCreditManager
extends AbstractFlowCreditManager
implements FlowCreditManager_0_10 {
    private volatile long _bytesCreditLimit;
    private volatile long _messageCreditLimit;
    private volatile long _bytesUsed;
    private volatile long _messageUsed;

    public WindowCreditManager() {
        this(0L, 0L);
    }

    public WindowCreditManager(long bytesCreditLimit, long messageCreditLimit) {
        this._bytesCreditLimit = bytesCreditLimit;
        this._messageCreditLimit = messageCreditLimit;
        this.setSuspended(!this.hasCredit());
    }

    public synchronized void setCreditLimits(long bytesCreditLimit, long messageCreditLimit) {
        this._bytesCreditLimit = bytesCreditLimit;
        this._messageCreditLimit = messageCreditLimit;
        this.setSuspended(!this.hasCredit());
    }

    public long getMessageCredit() {
        return this._messageCreditLimit == -1L ? Long.MAX_VALUE : (this._messageUsed < this._messageCreditLimit ? this._messageCreditLimit - this._messageUsed : 0L);
    }

    public long getBytesCredit() {
        return this._bytesCreditLimit == -1L ? Long.MAX_VALUE : (this._bytesUsed < this._bytesCreditLimit ? this._bytesCreditLimit - this._bytesUsed : 0L);
    }

    public synchronized void restoreCredit(long messageCredit, long bytesCredit) {
        boolean notifyIncrease = true;
        if (this._messageCreditLimit > 0L) {
            notifyIncrease = this._messageUsed != this._messageCreditLimit;
            this._messageUsed -= messageCredit;
            if (this._messageUsed < 0L) {
                this._messageUsed = 0L;
            }
        }
        if (this._bytesCreditLimit > 0L) {
            notifyIncrease = notifyIncrease && bytesCredit > 0L;
            this._bytesUsed -= bytesCredit;
            if (this._bytesUsed < 0L) {
                this._bytesUsed = 0L;
            }
            if (notifyIncrease) {
                this.notifyIncreaseBytesCredit();
            }
        }
        this.setSuspended(!this.hasCredit());
    }

    public synchronized boolean hasCredit() {
        return !(this._bytesCreditLimit >= 0L && this._bytesCreditLimit <= this._bytesUsed || this._messageCreditLimit >= 0L && this._messageCreditLimit <= this._messageUsed);
    }

    public synchronized boolean useCreditForMessage(ServerMessage msg) {
        if (this._messageCreditLimit >= 0L) {
            if (this._messageUsed < this._messageCreditLimit) {
                if (this._bytesCreditLimit < 0L) {
                    ++this._messageUsed;
                    return true;
                }
                if (this._bytesUsed + msg.getSize() <= this._bytesCreditLimit) {
                    ++this._messageUsed;
                    this._bytesUsed += msg.getSize();
                    return true;
                }
                return false;
            }
            this.setSuspended(true);
            return false;
        }
        if (this._bytesCreditLimit >= 0L) {
            if (this._bytesUsed + msg.getSize() <= this._bytesCreditLimit) {
                this._bytesUsed += msg.getSize();
                return true;
            }
            return false;
        }
        return true;
    }

    public void stop() {
        if (this._bytesCreditLimit > 0L) {
            this._bytesCreditLimit = 0L;
        }
        if (this._messageCreditLimit > 0L) {
            this._messageCreditLimit = 0L;
        }
    }

    public synchronized void addCredit(long count, long bytes) {
        if (bytes > 0L) {
            this._bytesCreditLimit += bytes;
        } else if (bytes == -1L) {
            this._bytesCreditLimit = -1L;
        }
        if (count > 0L) {
            this._messageCreditLimit += count;
        } else if (count == -1L) {
            this._messageCreditLimit = -1L;
        }
    }

    public void clearCredit() {
        this._bytesCreditLimit = 0L;
        this._messageCreditLimit = 0L;
        this.setSuspended(true);
    }
}

