/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.exchange.headers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.wso2.andes.framing.AMQShortString;
import org.wso2.andes.framing.AMQTypedValue;
import org.wso2.andes.framing.FieldTable;
import org.wso2.andes.server.exchange.headers.HeaderKey;
import org.wso2.andes.server.exchange.headers.HeaderKeyDictionary;
import org.wso2.andes.server.exchange.headers.HeaderMatcherResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeadersMatcherDFAState {
    private final Collection<HeaderMatcherResult> _results;
    private final Map<HeaderKey, Map<AMQTypedValue, HeadersMatcherDFAState>> _nextStateMap;
    private final HeaderKeyDictionary _dictionary;

    public HeadersMatcherDFAState(Map<HeaderKey, Map<AMQTypedValue, HeadersMatcherDFAState>> nextStateMap, Collection<HeaderMatcherResult> results, HeaderKeyDictionary dictionary) {
        this._nextStateMap = nextStateMap;
        this._results = results;
        this._dictionary = dictionary;
    }

    public Collection<HeaderMatcherResult> match(FieldTable table) {
        return this.match(table.iterator());
    }

    public Collection<HeaderMatcherResult> match(Iterator<Map.Entry<AMQShortString, AMQTypedValue>> fieldTableIterator) {
        if (this._nextStateMap.isEmpty()) {
            return this._results;
        }
        while (fieldTableIterator.hasNext()) {
            Map<AMQTypedValue, HeadersMatcherDFAState> valueToStateMap;
            Map.Entry<AMQShortString, AMQTypedValue> fieldTableEntry = fieldTableIterator.next();
            HeaderKey key = this._dictionary.get(fieldTableEntry.getKey());
            if (key == HeaderKey.UNKNOWN || (valueToStateMap = this._nextStateMap.get(key)) == null) continue;
            HeadersMatcherDFAState nextState = valueToStateMap.get(fieldTableEntry.getValue());
            if (nextState == null) {
                nextState = valueToStateMap.get(null);
            }
            if (nextState == null || nextState == this) continue;
            return nextState.match(fieldTableIterator);
        }
        return this._results;
    }

    HeadersMatcherDFAState mergeStateMachines(HeadersMatcherDFAState otherStateMachine) {
        Collection<HeaderMatcherResult> results;
        assert (otherStateMachine._dictionary == this._dictionary);
        HashMap<Set<HeadersMatcherDFAState>, HeadersMatcherDFAState> newStateMap = new HashMap<Set<HeadersMatcherDFAState>, HeadersMatcherDFAState>();
        if (this._results.isEmpty()) {
            results = otherStateMachine._results;
        } else if (otherStateMachine._results.isEmpty()) {
            results = this._results;
        } else {
            results = new HashSet<HeaderMatcherResult>(this._results);
            results.addAll(otherStateMachine._results);
        }
        HashMap<HeaderKey, Map<AMQTypedValue, HeadersMatcherDFAState>> newNextStateMap = new HashMap<HeaderKey, Map<AMQTypedValue, HeadersMatcherDFAState>>();
        HeadersMatcherDFAState newState = new HeadersMatcherDFAState(newNextStateMap, results, this._dictionary);
        HashSet<HeadersMatcherDFAState> oldStates = new HashSet<HeadersMatcherDFAState>();
        oldStates.add(this);
        oldStates.add(otherStateMachine);
        newStateMap.put(oldStates, newState);
        this.mergeStateMachines(oldStates, newNextStateMap, newStateMap);
        return newState;
    }

    /*
     * WARNING - void declaration
     */
    private void mergeStateMachines(Set<HeadersMatcherDFAState> oldStates, Map<HeaderKey, Map<AMQTypedValue, HeadersMatcherDFAState>> newNextStateMap, Map<Set<HeadersMatcherDFAState>, HeadersMatcherDFAState> newStateMap) {
        Map valueToStatesMap;
        HashMap nfaMap = new HashMap();
        HashSet<HeaderKey> distinctKeys = new HashSet<HeaderKey>();
        for (HeadersMatcherDFAState state : oldStates) {
            Map<HeaderKey, Map<AMQTypedValue, HeadersMatcherDFAState>> map = state._nextStateMap;
            for (Map.Entry<HeaderKey, Map<AMQTypedValue, HeadersMatcherDFAState>> entry : map.entrySet()) {
                Map map2 = (Map)nfaMap.get(entry.getKey());
                if (map2 == null) {
                    HashMap hashMap = new HashMap();
                    nfaMap.put(entry.getKey(), hashMap);
                }
                for (Map.Entry<AMQTypedValue, HeadersMatcherDFAState> valueToStateEntry : entry.getValue().entrySet()) {
                    void var11_21;
                    HashSet<HeadersMatcherDFAState> states = (HashSet<HeadersMatcherDFAState>)var11_21.get(valueToStateEntry.getKey());
                    if (states == null) {
                        states = new HashSet<HeadersMatcherDFAState>();
                        var11_21.put(valueToStateEntry.getKey(), states);
                    }
                    states.add(valueToStateEntry.getValue());
                }
                distinctKeys.add(entry.getKey());
            }
        }
        HashMap<HeaderKey, Set> anyValueStates = new HashMap<HeaderKey, Set>();
        for (HeaderKey headerKey : distinctKeys) {
            Set statesForKeyDefault;
            Map valueToStateMap = (Map)nfaMap.get(headerKey);
            if (valueToStateMap == null || (statesForKeyDefault = (Set)valueToStateMap.get(null)) == null) continue;
            anyValueStates.put(headerKey, statesForKeyDefault);
        }
        for (Map.Entry entry : nfaMap.entrySet()) {
            valueToStatesMap = (Map)entry.getValue();
            for (Map.Entry entry2 : valueToStatesMap.entrySet()) {
                Set defaults;
                if (entry2.getKey() == null || (defaults = (Set)anyValueStates.get(entry.getKey())) == null) continue;
                ((Set)entry2.getValue()).addAll(defaults);
            }
        }
        for (HeaderKey headerKey : distinctKeys) {
            valueToStatesMap = (Map)nfaMap.get(headerKey);
            for (HeadersMatcherDFAState headersMatcherDFAState : oldStates) {
                if (headersMatcherDFAState._nextStateMap.containsKey(headerKey)) continue;
                for (Set endStates : valueToStatesMap.values()) {
                    endStates.add(headersMatcherDFAState);
                }
            }
        }
        for (Map.Entry entry : nfaMap.entrySet()) {
            Map<AMQTypedValue, HeadersMatcherDFAState> valueToDFAState = newNextStateMap.get(entry.getKey());
            if (valueToDFAState == null) {
                valueToDFAState = new HashMap<AMQTypedValue, HeadersMatcherDFAState>();
                newNextStateMap.put((HeaderKey)entry.getKey(), valueToDFAState);
            }
            for (Map.Entry entry3 : ((Map)entry.getValue()).entrySet()) {
                Set destinations = (Set)entry3.getValue();
                HeadersMatcherDFAState nextState = newStateMap.get(destinations);
                if (nextState == null) {
                    if (destinations.size() == 1) {
                        nextState = (HeadersMatcherDFAState)destinations.iterator().next();
                        newStateMap.put(destinations, nextState);
                    } else {
                        HashSet<HeaderMatcherResult> results;
                        HashSet<Collection<HeaderMatcherResult>> resultSets = new HashSet<Collection<HeaderMatcherResult>>();
                        for (HeadersMatcherDFAState headersMatcherDFAState : destinations) {
                            resultSets.add(headersMatcherDFAState._results);
                        }
                        resultSets.remove(Collections.EMPTY_SET);
                        if (resultSets.size() == 0) {
                            results = Collections.EMPTY_SET;
                        } else if (resultSets.size() == 1) {
                            results = (Collection)resultSets.iterator().next();
                        } else {
                            results = new HashSet();
                            for (Collection collection : resultSets) {
                                results.addAll(collection);
                            }
                        }
                        HashMap<HeaderKey, Map<AMQTypedValue, HeadersMatcherDFAState>> nextStateMap = new HashMap<HeaderKey, Map<AMQTypedValue, HeadersMatcherDFAState>>();
                        nextState = new HeadersMatcherDFAState(nextStateMap, results, this._dictionary);
                        newStateMap.put(destinations, nextState);
                        this.mergeStateMachines(destinations, nextStateMap, newStateMap);
                    }
                }
                valueToDFAState.put((AMQTypedValue)entry3.getKey(), nextState);
            }
        }
        ArrayList<HeaderKey> removeKeyList = new ArrayList<HeaderKey>();
        for (Map.Entry<HeaderKey, Map<AMQTypedValue, HeadersMatcherDFAState>> entry : this._nextStateMap.entrySet()) {
            ArrayList<AMQTypedValue> removeValueList = new ArrayList<AMQTypedValue>();
            for (Map.Entry<AMQTypedValue, HeadersMatcherDFAState> valueToDFAState : entry.getValue().entrySet()) {
                HeadersMatcherDFAState defaultState;
                if (valueToDFAState.getValue() != this || (defaultState = entry.getValue().get(null)) != null && defaultState != this) continue;
                removeValueList.add(valueToDFAState.getKey());
            }
            for (AMQTypedValue removeValue : removeValueList) {
                entry.getValue().remove(removeValue);
            }
            if (!entry.getValue().isEmpty()) continue;
            removeKeyList.add(entry.getKey());
        }
        for (HeaderKey removeKey : removeKeyList) {
            this._nextStateMap.remove(removeKey);
        }
    }
}

