/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.configuration;

import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.wso2.andes.server.configuration.plugins.ConfigurationPlugin;

public class TopicConfig
extends ConfigurationPlugin {
    public TopicConfig() {
        this._configuration = new PropertiesConfiguration();
    }

    public String[] getElementsProcessed() {
        return new String[]{"name", "subscriptionName"};
    }

    public String getName() {
        return this.getStringValue("name", "#");
    }

    public String getSubscriptionName() {
        return this.getStringValue("subscriptionName");
    }

    public void validateConfiguration() throws ConfigurationException {
        if (this._configuration.isEmpty()) {
            throw new ConfigurationException("Topic section cannot be empty.");
        }
        if (this.getStringValue("name") == null && this.getSubscriptionName() == null) {
            throw new ConfigurationException("Topic section must have a 'name' or 'subscriptionName' element.");
        }
        System.err.println("********* Created TC:" + this);
    }

    public String formatToString() {
        String response = "Topic:" + this.getName();
        if (this.getSubscriptionName() != null) {
            response = response + ", SubscriptionName:" + this.getSubscriptionName();
        }
        return response;
    }
}

